/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.io.File;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;

public class JNewScriptModel {
    public static final int ACTION_CANCEL = 0;
    public static final int ACTION_ACCEPT = 1;
    private String type;
    private String name;
    private String description;
    private String language;
    private File path;
    private String createdBy;
    private String version;
    private int action;
    private final ScriptingManager manager;
    private TreePath initialSelectedPath = null;

    public JNewScriptModel(ScriptingManager manager) {
        this.manager = manager;
    }

    public void validate() throws Exception {
        ScriptingFolder folder;
        String theName = this.getName();
        if (StringUtils.isBlank((CharSequence)theName)) {
            throw new Exception("Name must not be empty.");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getType(), (CharSequence)"Script")) {
            String ext = FilenameUtils.getExtension((String)theName);
            if (StringUtils.isBlank((CharSequence)ext)) {
                this.setName(theName + "." + this.getExtension());
            } else if (!StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)this.getExtension())) {
                throw new Exception("Invalid extension '" + ext + "' for type '" + this.getType() + "', expected '" + this.getExtension() + "'.");
            }
        }
        if (!this.manager.validateUnitId(folder = this.manager.getFolder(this.getPath()), this.getName())) {
            throw new Exception("This file already exists.\nWrite another name for the script");
        }
    }

    public String getExtension() {
        return this.manager.getExtensionOfLanguage(this.getLanguage());
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setPath(File path) {
        this.path = path.getAbsoluteFile();
    }

    public File getPath() {
        return this.path;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    void setSelectionPath(TreePath path) {
        this.initialSelectedPath = path;
    }

    TreePath getSelectionPath() {
        return this.initialSelectedPath;
    }
}

