/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.scripting.ScriptingBaseScript;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingLocator;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.impl.composer.ChangeListenerSupport;
import org.gvsig.scripting.swing.impl.composer.JPropertiesScriptView;

public class JPropertiesScript
extends JPropertiesScriptView {
    private static final long serialVersionUID = 1503322333448146954L;
    private final ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
    private final ChangeListenerSupport changeListeners = new ChangeListenerSupport();

    public JPropertiesScript(ScriptingUnit unit) {
        this.initComponents();
        if (unit != null) {
            this.set(unit);
        }
    }

    private void initComponents() {
        this.txtName.addKeyListener(new MyKeyListener("name", this.txtName));
        this.txtDescription.addKeyListener(new MyKeyListener("description", this.txtDescription));
        this.txtCreatedBy.addKeyListener(new MyKeyListener("createdBy", this.txtCreatedBy));
        this.txtVersion.addKeyListener(new MyKeyListener("version", this.txtVersion));
        this.txtIsolationGroup.addKeyListener(new MyKeyListener("isolation", this.txtIsolationGroup));
        this.chkEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JPropertiesScript.this.changeListeners.fireChange("enabled", JPropertiesScript.this.chkEnabled.isSelected());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(ScriptingUnit unit) {
        boolean enabled = this.changeListeners.setEnabled(false);
        try {
            if (unit instanceof ScriptingFolder) {
                this.txtName.setEditable(false);
                this.txtDescription.setEditable(false);
                this.txtCreatedBy.setEditable(false);
                this.txtVersion.setEditable(false);
            } else {
                this.txtName.setEditable(true);
                this.txtDescription.setEditable(true);
                this.txtCreatedBy.setEditable(true);
                this.txtVersion.setEditable(true);
            }
            this.cboLibraryVersion.setEnabled(false);
            this.txtName.setText(unit.getName());
            this.txtDescription.setText(unit.getDescription());
            this.txtCreatedBy.setText(unit.getCreatedBy());
            this.txtVersion.setText(unit.getVersion());
            if (unit instanceof ScriptingBaseScript) {
                ScriptingBaseScript script = (ScriptingBaseScript)unit;
                this.chkEnabled.setEnabled(true);
                this.chkEnabled.setSelected(script.isEnabled());
                this.cboLibraryVersion.removeAllItems();
                ScriptingManager manager = ScriptingLocator.getManager();
                Map versions = manager.getLibFoldersVersions();
                if (versions != null) {
                    this.cboLibraryVersion.setEnabled(true);
                    this.cboLibraryVersion.addItem(new VersionItem(null, "Current version"));
                    this.cboLibraryVersion.setSelectedIndex(0);
                    for (Map.Entry entrySet : versions.entrySet()) {
                        String suffix = (String)entrySet.getKey();
                        String label = (String)entrySet.getValue();
                        this.cboLibraryVersion.addItem(new VersionItem(suffix, label));
                        if (!StringUtils.equals((CharSequence)suffix, (CharSequence)script.getLibrarySuffix())) continue;
                        this.cboLibraryVersion.setSelectedIndex(this.cboLibraryVersion.getItemCount() - 1);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)script.getIsolationGroup())) {
                    this.txtIsolationGroup.setText("");
                } else {
                    this.txtIsolationGroup.setText(script.getIsolationGroup());
                }
            } else {
                this.chkEnabled.setEnabled(false);
                this.chkEnabled.setSelected(false);
            }
        }
        finally {
            this.changeListeners.setEnabled(enabled);
        }
    }

    public void fectch(ScriptingUnit unit) {
        unit.setName(this.txtName.getText());
        unit.setDescription(this.txtDescription.getText());
        unit.setCreatedBy(this.txtCreatedBy.getText());
        unit.setVersion(this.txtVersion.getText());
        if (unit instanceof ScriptingBaseScript) {
            String s;
            ScriptingBaseScript script = (ScriptingBaseScript)unit;
            script.setEnabled(this.chkEnabled.isSelected());
            VersionItem version = (VersionItem)this.cboLibraryVersion.getSelectedItem();
            if (version != null) {
                script.setLibrarySuffix(version.suffix);
            }
            if (StringUtils.isEmpty((CharSequence)(s = this.txtIsolationGroup.getText()))) {
                script.setIsolationGroup(null);
            } else {
                script.setIsolationGroup(s.trim());
            }
        }
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addChangeListener(listener);
    }

    private static class VersionItem {
        private final String suffix;
        private final String label;

        VersionItem(String suffix, String label) {
            this.suffix = suffix;
            this.label = label;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String toString() {
            return this.label;
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private final String name;
        private final JTextComponent text;

        public MyKeyListener(String name, JTextComponent text) {
            this.name = name;
            this.text = text;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JPropertiesScript.this.changeListeners.fireChange(this.name, this.text.getText());
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

