/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.gvsig.scripting.ScriptingErrorException;
import org.gvsig.scripting.swing.api.JScriptingComposer;
import org.gvsig.scripting.swing.api.ScriptingUIManager;

public class DefaultProblems
extends JPanel
implements JScriptingComposer.Problems {
    private static final long serialVersionUID = 7728033081188167969L;
    private static final int COLUMN_TYPE = 0;
    private static final int COLUMN_MESSAGE = 1;
    private static final int COLUMN_RESOURCE = 2;
    private static final int COLUMN_LOCATION = 3;
    private static final int NUM_COLUMNS = 4;
    private JTable table;
    private ProblemsTableMode tableModel;
    private final ScriptingUIManager uimanager;
    private Set<ListSelectionListener> selectionListeners;

    public DefaultProblems(ScriptingUIManager uimanager) {
        this.uimanager = uimanager;
        this.initComponents();
    }

    private void initComponents() {
        this.selectionListeners = new HashSet<ListSelectionListener>();
        this.tableModel = new ProblemsTableMode(this.uimanager);
        this.table = new JTable(this.tableModel);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        JScrollPane scrollProblems = new JScrollPane(this.table);
        scrollProblems.setAutoscrolls(true);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollProblems, "Center");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evnt) {
                if (evnt.getClickCount() == 1) {
                    DefaultProblems.this.fireSelectionListeners();
                }
            }
        });
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
        this.selectionListeners.add(listener);
    }

    private void fireSelectionListeners() {
        int row = this.table.getSelectedRow();
        for (ListSelectionListener listener : this.selectionListeners) {
            try {
                listener.valueChanged(new ListSelectionEvent(this, row, row, false));
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void removeAll() {
        this.tableModel.removeAll();
        this.table.updateUI();
    }

    public void add(String type, String message, String resource, String location) {
        this.tableModel.add(type, message, resource, location, null);
    }

    public void add(String type, String message, String resource, int line, int column) {
        this.add(type, message, resource, line + ":" + column);
    }

    public void add(String type, String message, String resourceName, int line, int column, File resource) {
        this.tableModel.add(type, message, resourceName, line + ":" + column, resource);
    }

    public void add(String type, Exception e) {
        if (e instanceof ScriptingErrorException) {
            ScriptingErrorException se = (ScriptingErrorException)e;
            this.add("Error", se.getMessage(), se.getScriptName(), se.getLineNumber(), se.getColumnNumber(), se.getScriptFile());
        } else {
            this.add("Error", "Error", e == null ? "unknown" : e.getMessage(), null);
        }
    }

    public JScriptingComposer.Problems.Problem getSelect() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.get(row);
    }

    public int getCount() {
        return this.tableModel.getRowCount();
    }

    public JScriptingComposer.Problems.Problem get(int row) {
        return this.tableModel.getProblem(row);
    }

    public JComponent asJComponent() {
        return this;
    }

    public static class ProblemsTableMode
    extends DefaultTableModel
    implements TableModel {
        private static final long serialVersionUID = -3294067602561419422L;
        private final ScriptingUIManager uimanager;
        private List<DefaultProblem> data;
        private String[] columnNames;

        public ProblemsTableMode(ScriptingUIManager uimanager) {
            this.uimanager = uimanager;
            this.columnNames = new String[]{this.uimanager.getTranslation("Category"), this.uimanager.getTranslation("Description"), this.uimanager.getTranslation("Resource"), this.uimanager.getTranslation("Location")};
        }

        private List<DefaultProblem> getData() {
            if (this.data == null) {
                this.data = new ArrayList<DefaultProblem>();
            }
            return this.data;
        }

        public void add(DefaultProblem row) {
            this.getData().add(row);
            this.fireTableDataChanged();
        }

        private void add(String type, String message, String resourceName, String location, File resource) {
            DefaultProblem problem = new DefaultProblem(type, message, resourceName, location, resource);
            this.add(problem);
        }

        @Override
        public int getRowCount() {
            return this.getData().size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getData().get(rowIndex).get(columnIndex);
        }

        public JScriptingComposer.Problems.Problem getProblem(int rowIndex) {
            return this.getData().get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.getData().get(rowIndex).setValue(columnIndex, (String)aValue);
        }

        public void removeAll() {
            this.getData().clear();
        }

        public static class DefaultProblem
        implements JScriptingComposer.Problems.Problem {
            String[] row;
            private File resource;

            public DefaultProblem() {
                this.row = new String[4];
            }

            public DefaultProblem(String[] row) {
                this.row = row;
            }

            public DefaultProblem(String type, String message, String resourceName, String location, File resource) {
                String[] theRow = new String[]{type, message, resourceName, location};
                this.resource = resource;
                this.row = theRow;
            }

            public String get(int index) {
                return this.row[index];
            }

            public String getValue(int index) {
                return this.row[index];
            }

            public void setValue(int index, String value) {
                this.row[index] = value;
            }

            public String getType() {
                return this.row[0];
            }

            public String getMessage() {
                return this.row[1];
            }

            public String getResourceName() {
                return this.row[2];
            }

            public File getResource() {
                return this.resource;
            }

            public int getLineNumber() {
                try {
                    String[] lineAndColumn = this.row[3].split(":");
                    if (lineAndColumn.length > 0) {
                        int lineno = Integer.parseInt(lineAndColumn[0].trim());
                        return lineno;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -1;
            }
        }
    }
}

