/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.script.ScriptSwingManager;

public class ScriptPickerController
extends AbstractPickerController<Script> {
    private Script script;
    private final JTextField txtText;
    private final JButton btnChooser;

    public ScriptPickerController(JTextField text, JButton chooser) {
        this.txtText = text;
        this.btnChooser = chooser;
        this.txtText.setEditable(false);
        this.btnChooser.setEnabled(true);
        this.btnChooser.setIcon(this.getIcon("picker-script"));
        this.btnChooser.setText("");
        this.btnChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPickerController.this.doChooseScript();
            }
        });
        this.txtText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == ' ' || e.getKeyChar() == '\u007f') {
                    ScriptPickerController.this.doClearScriptSelection();
                }
            }
        });
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        manager.addClearButton((JTextComponent)this.txtText, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPickerController.this.doClearScriptSelection();
            }
        });
        manager.setDefaultPopupMenu((JTextComponent)this.txtText, "Script");
    }

    private void doClearScriptSelection() {
        this.set(null);
        this.fireChangeEvent();
    }

    private void doChooseScript() {
        Script theScript;
        ScriptingUIManager manager = ScriptingSwingLocator.getUIManager();
        ScriptSwingManager.ScriptChooserPanel chooser = manager.createScriptChooserPanel();
        chooser.showDialog();
        if (chooser.getAction() == 1 && (theScript = chooser.getScript()) != null) {
            this.set(theScript);
            this.fireChangeEvent();
        }
    }

    public Script get() {
        return this.script;
    }

    public void set(Script value) {
        this.script = value;
        if (value == null) {
            this.txtText.setText("");
        } else if (this.script instanceof ScriptingUnit) {
            this.txtText.setText(((ScriptingUnit)this.script).getUserPath());
        } else {
            this.txtText.setText(this.script.getName());
        }
    }

    public void coerceAndSet(Object value) {
        if (value instanceof Script) {
            this.set((Script)value);
            return;
        }
        String s = "null";
        if (value != null) {
            s = value.getClass().getName();
        }
        throw new IllegalArgumentException("Can't coerce '" + s + "' to Script.");
    }

    public void setEnabled(boolean enabled) {
        this.btnChooser.setEnabled(enabled);
        this.txtText.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.btnChooser.isEnabled();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.btnChooser.setEnabled(editable);
    }
}

