/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BandNotification;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.lib.buffer.impl.BufferInterpolation;
import org.gvsig.raster.lib.buffer.impl.DefaultBufferNotification;
import org.gvsig.raster.lib.buffer.impl.statistics.DefaultStatistics;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBuffer
extends BaseWeakReferencingObservable
implements Buffer {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractBuffer.class);
    protected List<Band> bands;
    protected IProjection projection;
    protected Statistics statistics;
    protected BufferDimensions dimensions = null;
    private final Object lock = new Object();
    private boolean disposed = false;

    public AbstractBuffer() {
        if (ToolsLocator.getDisposableManager() != null) {
            ToolsLocator.getDisposableManager().bind((Disposable)this);
        } else {
            logger.warn("Can't retrieve the disposable manager,");
        }
    }

    public Statistics getStatistics(SimpleTaskStatus status) {
        if (this.statistics == null) {
            this.statistics = new DefaultStatistics();
        }
        if (!this.statistics.isCalculated()) {
            this.statistics.calculate(status, this.bands);
        }
        return this.statistics;
    }

    public Iterator<Band> iterator() {
        return this.bands.iterator();
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof BandNotification && observable instanceof Band) {
            Notification bandNotification = (Notification)notification;
            if (bandNotification.getType().equals("copy_from_band_notification") || bandNotification.getType().equals("fill_band_notification") || bandNotification.getType().equals("put_row_band_notification") || bandNotification.getType().equals("set_band_notification")) {
                this.statistics = null;
                this.notifyObservers((Object)new DefaultBufferNotification("change_band_buffer_notification", new Object[]{observable}));
            } else if (bandNotification.getType().equals("loaded_page_notification")) {
                this.notifyObservers((Object)new DefaultBufferNotification("loaded_page_band_buffer_notification", new Object[]{this}));
            }
        }
    }

    public int getBandCount() {
        return this.bands.size();
    }

    public Band[] getBands() {
        Band[] arrayBands = new Band[this.bands.size()];
        return this.bands.toArray(arrayBands);
    }

    public int getColumns() {
        return this.dimensions.getColumns();
    }

    public int getRows() {
        return this.dimensions.getRows();
    }

    public Envelope getEnvelope() {
        return this.dimensions.getEnvelope();
    }

    public BufferDimensions getDimensions() {
        return this.dimensions;
    }

    public IProjection getProjection() {
        return this.projection;
    }

    public boolean isInside(int cellX, int cellY) {
        return cellX >= 0 && cellX < this.getColumns() && cellY >= 0 && cellY < this.getRows();
    }

    public boolean isInside(Point point) {
        if (this.getEnvelope() == null) {
            return false;
        }
        try {
            return this.getEnvelope().getGeometry().contains((Geometry)point);
        }
        catch (GeometryOperationException | GeometryOperationNotSupportedException e) {
            logger.warn("It could not determine if the point is on the envelope", e);
            return false;
        }
    }

    public void addBand(Band band) {
        if (band.getColumns() != this.getColumns() || band.getRows() != this.getRows()) {
            throw new IllegalArgumentException("Can not add band to buffer. Band must have the same rows and columns as buffer.");
        }
        this.bands.add(band);
        DisposeUtils.bind((Disposable)band);
        band.addObserver((Observer)this);
        this.statistics = null;
        this.notifyObservers((Object)new DefaultBufferNotification("add_band_buffer_notification", new Object[]{band}));
    }

    public void setBand(int pos, Band band) throws BandException {
        this.bands.get(pos).copyFrom(band);
        this.statistics = null;
        this.notifyObservers((Object)new DefaultBufferNotification("set_band_buffer_notification", new Object[]{pos, band}));
    }

    public void removeBand(int pos) {
        Band band = this.bands.get(pos);
        band.deleteObserver((Observer)this);
        this.bands.remove(pos);
        this.statistics = null;
        this.notifyObservers((Object)new DefaultBufferNotification("remove_band_buffer_notification", new Object[]{pos}));
    }

    public Band getBand(int pos) {
        return this.bands.get(pos);
    }

    public Band.BandByte getBandByte(int pos) {
        if (this.bands.get(pos).getDataType() != 0) {
            throw new IllegalArgumentException(String.format("Band in position %1s is type of %2s, byte expected", pos, this.bands.get(pos).getDataType()));
        }
        return (Band.BandByte)this.bands.get(pos);
    }

    public Band.BandShort getBandShort(int pos) {
        if (this.bands.get(pos).getDataType() != 2) {
            throw new IllegalArgumentException(String.format("Band in position %1s is type of %2s, short expected", pos, this.bands.get(pos).getDataType()));
        }
        return (Band.BandShort)this.bands.get(pos);
    }

    public Band.BandInt getBandInt(int pos) {
        if (this.bands.get(pos).getDataType() != 3) {
            throw new IllegalArgumentException(String.format("Band in position %1s is type of %2s, int expected", pos, this.bands.get(pos).getDataType()));
        }
        return (Band.BandInt)this.bands.get(pos);
    }

    public Band.BandFloat getBandFloat(int pos) {
        if (this.bands.get(pos).getDataType() != 4) {
            throw new IllegalArgumentException(String.format("Band in position %1s is type of %2s, float expected", pos, this.bands.get(pos).getDataType()));
        }
        return (Band.BandFloat)this.bands.get(pos);
    }

    public Band.BandDouble getBandDouble(int pos) {
        if (this.bands.get(pos).getDataType() != 5) {
            throw new IllegalArgumentException(String.format("Band in position %1s is type of %2s, double expected", pos, this.bands.get(pos).getDataType()));
        }
        return (Band.BandDouble)this.bands.get(pos);
    }

    public void switchBands(int[] positions) {
        ArrayList<Integer> visited = new ArrayList<Integer>();
        if (positions.length != this.getBandCount()) {
            throw new IllegalArgumentException("Position array length has to be the same as band count");
        }
        for (int i = 0; i < positions.length; ++i) {
            Integer position = new Integer(positions[i]);
            if (visited.contains(position)) {
                throw new IllegalArgumentException(String.format("Position array can not have duplicated bands. Duplicated value: %1s", position));
            }
            visited.add(position);
        }
        ArrayList<Band> auxBands = new ArrayList<Band>(this.bands.size());
        for (int i = 0; i < visited.size(); ++i) {
            auxBands.add(this.bands.get((Integer)visited.get(i)));
        }
        this.bands = auxBands;
        this.statistics = null;
        this.notifyObservers((Object)new DefaultBufferNotification("switch_band_buffer_notification", new Object[]{positions}));
    }

    public void switchBands(int pos1, int pos2) {
        Band auxBand = this.bands.get(pos1);
        this.bands.set(pos1, this.bands.get(pos2));
        this.bands.set(pos2, auxBand);
        this.statistics = null;
        this.notifyObservers((Object)new DefaultBufferNotification("switch_band_buffer_notification", new Object[]{pos1, pos2}));
    }

    public Buffer createInterpolated(int rows, int columns, int interpolationMode, SimpleTaskStatus status) throws BufferException {
        if (rows == 0 || columns == 0) {
            return null;
        }
        try {
            Buffer target = BufferLocator.getBufferManager().createBuffer(rows, columns, this.getBandTypes(), this.getBandNoData(), this.getProjection(), this.getEnvelope(), null);
            BufferInterpolation interp = new BufferInterpolation();
            switch (interpolationMode) {
                case 1: {
                    interp.nearestNeighbourInterpolation(this, target, status);
                    break;
                }
                case 2: {
                    interp.bilinearInterpolation(this, target, status);
                    break;
                }
                case 3: {
                    interp.inverseDistanceInterpolation(this, target, status);
                    break;
                }
                case 4: {
                    interp.bicubicSplineInterpolation(this, target, status);
                    break;
                }
                case 5: {
                    interp.bSplineInterpolation(this, target, status);
                }
            }
            return target;
        }
        catch (LocatorException e) {
            throw new BufferException((Throwable)e);
        }
    }

    public Buffer convert(ICoordTrans ct, SimpleTaskStatus status) throws BufferException {
        Point point;
        AffineTransform inverseBufferAf;
        if (this.getEnvelope() == null) {
            throw new IllegalStateException("Buffer envelope is null. A buffer allways has to have envelope");
        }
        boolean isMyStatus = false;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(String.format("Projecting buffer from %1s to %2s", ct.getPOrig().getAbrev(), ct.getPDest().getAbrev()));
            status.add();
            isMyStatus = true;
        } else {
            status.push();
        }
        Envelope projectedBufferEnvelope = this.getEnvelope().convert(ct);
        double[] newsize = this.getSize(this.getEnvelope(), projectedBufferEnvelope, this.getColumns(), this.getRows());
        int projectedBufferColumns = (int)newsize[0];
        int projectedBufferRows = (int)newsize[1];
        int[] bandDataTypes = this.getBandTypes();
        NoData[] bandNoData = this.getBandNoData();
        status.message("Creating projected buffer");
        Buffer projectedBuffer = BufferLocator.getBufferManager().createBuffer(projectedBufferRows, projectedBufferColumns, bandDataTypes, bandNoData, ct.getPDest(), projectedBufferEnvelope);
        AffineTransform bufferAf = this.calculateAffineTransform(this.getEnvelope(), this.getRows(), this.getColumns());
        AffineTransform projectedBufferAf = this.calculateAffineTransform(projectedBufferEnvelope, projectedBufferRows, projectedBufferColumns);
        ICoordTrans invertedCt = ct.getInverted();
        try {
            inverseBufferAf = bufferAf.createInverse();
        }
        catch (NoninvertibleTransformException e1) {
            status.abort();
            logger.error("Can not create inverse transformation of {}", (Object)bufferAf);
            throw new BufferException((Throwable)e1);
        }
        status.setRangeOfValues(0L, (long)(projectedBuffer.getRows() * projectedBuffer.getColumns() * projectedBuffer.getBandCount()));
        status.message("Projecting buffer");
        try {
            point = (Point)GeometryLocator.getGeometryManager().create(1, 0);
        }
        catch (CreateGeometryException | LocatorException e1) {
            status.abort();
            logger.error("Can not create point geometry to project buffer");
            throw new BufferException(e1);
        }
        for (int row = 0; row < projectedBuffer.getRows(); ++row) {
            if (status.isCancellationRequested()) {
                status.cancel();
                return projectedBuffer;
            }
            for (int col = 0; col < projectedBuffer.getColumns(); ++col) {
                point.setX((double)col);
                point.setY((double)row);
                point.transform(projectedBufferAf);
                point.reProject(invertedCt);
                point.transform(inverseBufferAf);
                double floorPointX = Math.floor(point.getX());
                double floorPointY = Math.floor(point.getY());
                boolean isValidPoint = point.getX() >= 0.0 && floorPointX < (double)this.getColumns() && point.getY() >= 0.0 && floorPointY < (double)this.getRows();
                block13: for (int k = 0; k < this.getBandCount(); ++k) {
                    status.setCurValue((long)(row * col * k));
                    Band band = this.bands.get(k);
                    Number value = null;
                    if (isValidPoint) {
                        value = (Number)band.get((int)floorPointY, (int)floorPointX);
                    } else {
                        if (!band.getNoData().isDefined()) continue;
                        value = band.getNoData().getValue();
                    }
                    Band projectedBand = projectedBuffer.getBand(k);
                    int dataType = projectedBand.getDataType();
                    switch (dataType) {
                        case 0: {
                            projectedBand.set(row, col, (Object)value.byteValue());
                            continue block13;
                        }
                        case 2: {
                            projectedBand.set(row, col, (Object)value.shortValue());
                            continue block13;
                        }
                        case 3: {
                            projectedBand.set(row, col, (Object)value.intValue());
                            continue block13;
                        }
                        case 4: {
                            projectedBand.set(row, col, (Object)Float.valueOf(value.floatValue()));
                            continue block13;
                        }
                        case 5: {
                            projectedBand.set(row, col, (Object)value.doubleValue());
                            continue block13;
                        }
                    }
                }
            }
        }
        if (isMyStatus) {
            status.terminate();
        } else {
            status.pop();
        }
        return projectedBuffer;
    }

    private double[] getSize(Envelope envelope, Envelope projectedEnvelope, int p1x, int p1y) {
        double sumSideOldBBox = envelope.getLength(0) + envelope.getLength(1);
        double sumSideNewBBox = projectedEnvelope.getLength(0) + projectedEnvelope.getLength(1);
        double d1x = envelope.getLength(0) * 100.0 / sumSideOldBBox;
        double d1y = envelope.getLength(1) * 100.0 / sumSideOldBBox;
        double d2x = projectedEnvelope.getLength(0) * 100.0 / sumSideNewBBox;
        double d2y = projectedEnvelope.getLength(1) * 100.0 / sumSideNewBBox;
        double p2y = (double)p1y * d2y / d1y;
        double p2x = (double)p1x * d2x / d1x;
        double newCellSizeX = projectedEnvelope.getLength(0) / p2x;
        double newCellSizeY = projectedEnvelope.getLength(1) / p2y;
        return new double[]{Math.round(p2x), Math.round(p2y), newCellSizeX, newCellSizeY};
    }

    private AffineTransform calculateAffineTransform(Envelope projectedBufferEnvelope, int projectedBufferRows, int projectedBufferColumns) {
        double cellSizeX = projectedBufferEnvelope.getLength(0) / (double)projectedBufferColumns;
        double cellSizeY = projectedBufferEnvelope.getLength(1) / (double)projectedBufferRows;
        return new AffineTransform(cellSizeX, 0.0, 0.0, -cellSizeY, projectedBufferEnvelope.getMinimum(0), projectedBufferEnvelope.getMaximum(1));
    }

    public int[] getBandTypes() {
        int[] bandDataTypes = new int[this.getBandCount()];
        for (int i = 0; i < this.bands.size(); ++i) {
            bandDataTypes[i] = this.bands.get(i).getDataType();
        }
        return bandDataTypes;
    }

    public boolean areAllBandsOfTheSameType() {
        if (this.bands.isEmpty()) {
            return true;
        }
        int type = this.bands.get(0).getDataType();
        for (int i = 1; i < this.bands.size(); ++i) {
            if (type == this.bands.get(i).getDataType()) continue;
            return false;
        }
        return true;
    }

    public NoData[] getBandNoData() {
        NoData[] bandNoData = new NoData[this.getBandCount()];
        for (int i = 0; i < this.bands.size(); ++i) {
            bandNoData[i] = this.bands.get(i).getNoData();
        }
        return bandNoData;
    }

    public Buffer clip(Envelope envelope) throws BufferException {
        try {
            return BufferLocator.getBufferManager().createClippedBuffer((Buffer)this, envelope);
        }
        catch (BufferException | LocatorException e) {
            throw new BufferException(e);
        }
    }

    public double getPixelSizeX() {
        return this.dimensions.getPixelSizeX();
    }

    public double getPixelSizeY() {
        return this.dimensions.getPixelSizeY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.disposed && ToolsLocator.getDisposableManager().release((Disposable)this)) {
                try {
                    this.doDispose();
                }
                catch (BaseException ex) {
                    logger.error("Error performing dispose", (Throwable)ex);
                }
                this.disposed = true;
            }
        }
    }

    public void doDispose() throws BaseException {
        for (Band band : this.bands) {
            DisposeUtils.dispose((Disposable)band);
        }
        this.bands.removeAll(this.bands);
        this.projection = null;
        this.statistics = null;
        this.dimensions = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public BandInfo[] getBandsInfo() {
        BandInfo[] bandsInfo = new BandInfo[this.bands.size()];
        for (int i = 0; i < this.bands.size(); ++i) {
            bandsInfo[i] = this.bands.get(i).getBandInfo();
        }
        return bandsInfo;
    }
}

