/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.impl.AbstractBand;
import org.gvsig.raster.lib.buffer.impl.ClippedBuffer;
import org.gvsig.raster.lib.buffer.impl.exceptions.CopyFromBandException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableManager;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;

public abstract class AbstractClippedBand
extends AbstractBand
implements Band {
    protected Band band;
    protected int firstRow;
    protected int firstColumn;

    public AbstractClippedBand(Buffer buffer, Band band) {
        if (!(buffer instanceof ClippedBuffer)) {
            throw new IllegalArgumentException("buffer isn't a ClippedBuffer");
        }
        ClippedBuffer clippedBuffer = (ClippedBuffer)buffer;
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        disposableManager.bind((Disposable)band);
        this.band = band;
        this.rows = clippedBuffer.getRows();
        this.columns = clippedBuffer.getColumns();
        this.firstRow = clippedBuffer.getFirstRow();
        this.firstColumn = clippedBuffer.getFirstColumn();
        this.noData = this.band.getNoData();
    }

    @Override
    public BandInfo getBandInfo() {
        return this.band.getBandInfo();
    }

    public int getDataType() {
        return this.band.getDataType();
    }

    public Object get(int row, int column) {
        int bandRow = row + this.firstRow;
        int bandColumn = column + this.firstColumn;
        return this.band.get(bandRow, bandColumn);
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        throw new UnsupportedOperationException("Can't write in a clipped band.");
    }

    @Override
    protected void doFill(Object value) {
        throw new UnsupportedOperationException("Can't write in a clipped band.");
    }

    @Override
    protected void doCopyFrom(Band source) throws CopyFromBandException {
        throw new UnsupportedOperationException("Can't write in a clipped band.");
    }

    @Override
    protected void doCopyFrom(Band source, int row, int column) throws CopyFromBandException {
        throw new UnsupportedOperationException("Can't write in a clipped band.");
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        throw new UnsupportedOperationException("Can't write in a clipped band.");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void doDispose() throws BaseException {
        super.doDispose();
        DisposeUtils.dispose((Disposable)this.band);
        this.band = null;
    }
}

