/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.impl.AbstractBand;
import org.gvsig.raster.lib.buffer.impl.ConvertedTypeBuffer;
import org.gvsig.raster.lib.buffer.impl.exceptions.CopyFromBandException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableManager;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;

public abstract class AbstractConvertedTypeBand
extends AbstractBand
implements Band {
    protected Band band;

    public AbstractConvertedTypeBand(Buffer buffer, Band band) {
        if (!(buffer instanceof ConvertedTypeBuffer)) {
            throw new IllegalArgumentException("buffer isn't a ConvertedTypeBuffer");
        }
        ConvertedTypeBuffer convertedTypeBuffer = (ConvertedTypeBuffer)buffer;
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        disposableManager.bind((Disposable)band);
        this.band = band;
        this.noData = this.getNoData();
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        switch (this.band.getDataType()) {
            case 0: {
                ((Band.BandByte)this.band).setValue(row, column, ((Number)value).byteValue());
                break;
            }
            case 1: 
            case 2: {
                ((Band.BandShort)this.band).setValue(row, column, ((Number)value).shortValue());
                break;
            }
            case 3: {
                ((Band.BandInt)this.band).setValue(row, column, ((Number)value).intValue());
                break;
            }
            case 4: {
                ((Band.BandFloat)this.band).setValue(row, column, ((Number)value).floatValue());
                break;
            }
            case 5: {
                ((Band.BandDouble)this.band).setValue(row, column, ((Number)value).doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow dataType " + this.band.getDataType() + ".");
            }
        }
    }

    @Override
    protected void doFill(Object value) {
        throw new UnsupportedOperationException("Can't write in a converted type band.");
    }

    @Override
    protected void doCopyFrom(Band source) throws CopyFromBandException {
        throw new UnsupportedOperationException("Can't write in a converted type band.");
    }

    @Override
    protected void doCopyFrom(Band source, int row, int column) throws CopyFromBandException {
        throw new UnsupportedOperationException("Can't write in a converted type band.");
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        throw new UnsupportedOperationException("Can't write in a converted type band.");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void doDispose() throws BaseException {
        super.doDispose();
        DisposeUtils.dispose((Disposable)this.band);
        this.band = null;
    }

    @Override
    public int getRows() {
        return this.band.getRows();
    }

    @Override
    public int getColumns() {
        return this.band.getColumns();
    }

    @Override
    public BandInfo getBandInfo() {
        BandInfo bandInfo = this.band.getBandInfo();
        return BufferLocator.getBufferManager().createBandInfo(bandInfo.getBand(), bandInfo.getName(), bandInfo.getDescription(), this.getDataType(), bandInfo.getValues());
    }
}

