/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractConvertedTypeBand;

public class ConvertedTypeBandByte
extends AbstractConvertedTypeBand
implements Band.BandByte {
    public ConvertedTypeBandByte(Buffer buffer, Band band) {
        super(buffer, band);
    }

    public byte[] createRowBuffer() {
        return new byte[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        for (int i = 0; i < this.getColumns(); ++i) {
            ((byte[])rowBuffer)[i] = ((Number)this.band.get(row, i)).byteValue();
        }
    }

    public byte getValue(int row, int column) {
        return ((Number)this.get(row, column)).byteValue();
    }

    public void setValue(int row, int column, byte value) {
        this.doSet(row, column, new Byte(value));
    }

    public int getDataType() {
        return 0;
    }

    public Object get(int row, int column) {
        return ((Number)this.get(row, column)).byteValue();
    }

    @Override
    public NoData getNoData() {
        NoData bandNoData = this.band.getNoData();
        if (bandNoData == null) {
            this.noData = BufferLocator.getBufferManager().createNoData(null, null);
        } else {
            Byte value = null;
            Byte defaultValue = null;
            Number bandvalue = bandNoData.getValue();
            Number bandDefaultValue = bandNoData.getDefaultValue();
            if (bandvalue != null) {
                value = bandvalue.byteValue();
            }
            if (bandDefaultValue != null) {
                defaultValue = bandDefaultValue.byteValue();
            }
            this.noData = BufferLocator.getBufferManager().createNoData((Number)value, (Number)defaultValue);
        }
        return this.noData;
    }
}

