/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractConvertedTypeBand;

public class ConvertedTypeBandShort
extends AbstractConvertedTypeBand
implements Band.BandShort {
    public ConvertedTypeBandShort(Buffer buffer, Band band) {
        super(buffer, band);
    }

    public short[] createRowBuffer() {
        return new short[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        for (int i = 0; i < this.getColumns(); ++i) {
            ((short[])rowBuffer)[i] = ((Number)this.band.get(row, i)).shortValue();
        }
    }

    public short getValue(int row, int column) {
        return ((Number)this.get(row, column)).shortValue();
    }

    public void setValue(int row, int column, short value) {
        this.doSet(row, column, new Short(value));
    }

    public int getDataType() {
        return 2;
    }

    public Object get(int row, int column) {
        return ((Number)this.get(row, column)).shortValue();
    }

    @Override
    public NoData getNoData() {
        NoData bandNoData = this.band.getNoData();
        if (bandNoData == null) {
            this.noData = BufferLocator.getBufferManager().createNoData(null, null);
        } else {
            Short value = null;
            Short defaultValue = null;
            Number bandvalue = bandNoData.getValue();
            Number bandDefaultValue = bandNoData.getDefaultValue();
            if (bandvalue != null) {
                value = bandvalue.shortValue();
            }
            if (bandDefaultValue != null) {
                defaultValue = bandDefaultValue.shortValue();
            }
            this.noData = BufferLocator.getBufferManager().createNoData((Number)value, (Number)defaultValue);
        }
        return this.noData;
    }
}

