/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.raster.lib.buffer.api.VectorROI;
import org.gvsig.raster.lib.buffer.api.exceptions.GettingEnvelopeException;
import org.gvsig.raster.lib.buffer.impl.AbstractROI;
import org.gvsig.tools.locator.LocatorException;

public class DefaultVectorROI
extends AbstractROI
implements VectorROI {
    List<Geometry> rois = new ArrayList<Geometry>();

    public boolean isInside(int cellX, int cellY) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Point point = geomManager.createPoint((double)cellX, (double)cellY, 0);
        return this.isInside((Geometry)point);
    }

    public boolean isInside(Geometry geometry) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.rois != null && !this.rois.isEmpty()) {
            for (Geometry geom : this.rois) {
                if (!geom.contains(geometry)) continue;
                return true;
            }
        }
        return false;
    }

    public Envelope getEnvelope() throws GettingEnvelopeException {
        Envelope envelope = null;
        for (Geometry geom : this.rois) {
            try {
                if (envelope == null) {
                    envelope = (Envelope)geom.getEnvelope().clone();
                    continue;
                }
                envelope.add((Envelope)geom.getEnvelope().clone());
            }
            catch (CloneNotSupportedException e) {
                throw new GettingEnvelopeException(geom, (Throwable)e);
            }
        }
        if (envelope == null) {
            try {
                return GeometryLocator.getGeometryManager().createEnvelope(0);
            }
            catch (CreateEnvelopeException | LocatorException e) {
                throw new GettingEnvelopeException(e);
            }
        }
        return envelope;
    }

    public void addGeometry(Geometry geometry) {
        if (!geometry.getGeometryType().isSubTypeOf(0)) {
            throw new IllegalArgumentException("Vector ROI only supports 2D geometries");
        }
        this.rois.add(geometry);
    }

    public void removeGeometry(int index) {
        this.rois.remove(index);
    }

    public List<Geometry> getGeometries() {
        return Collections.unmodifiableList(this.rois);
    }

    public int getGeometryCount() {
        return this.rois.size();
    }
}

