/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandPageManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractPaginatedBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedBandByte
extends AbstractPaginatedBand
implements Band.BandByte {
    private static final Logger logger = LoggerFactory.getLogger(PaginatedBandByte.class);

    public PaginatedBandByte(int rows, int columns, NoData noData, BandPageManager pageManager) {
        super(rows, columns, noData, pageManager);
    }

    public int getDataType() {
        return 0;
    }

    @Override
    protected int getDataSize() {
        return 1;
    }

    public Object get(int row, int column) {
        return this.getValue(row, column);
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.setValue(row, column, (Byte)value);
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        for (int row = 0; row < this.rows; row += this.rowsPerPage) {
            this.loadPage(row);
            Arrays.fill((byte[])this.data.array(), (Byte)value);
        }
    }

    public byte getValue(int row, int column) {
        this.loadPage(row);
        return ((ByteBuffer)this.data).get((row - this.firstRowOfPage) * this.columns + column);
    }

    public void setValue(int row, int column, byte value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, value}));
    }

    protected void doSetValue(int row, int column, byte value) {
        this.loadPage(row);
        ((ByteBuffer)this.data).put((row - this.firstRowOfPage) * this.columns + column, value);
    }

    public byte[] createRowBuffer() {
        return new byte[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        this.loadPage(row);
        byte[] source = (byte[])this.data.array();
        byte[] target = (byte[])rowBuffer;
        System.arraycopy(source, (row - this.firstRowOfPage) * this.columns, target, 0, this.columns);
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        this.loadPage(row);
        byte[] source = (byte[])rowBuffer;
        byte[] target = (byte[])this.data.array();
        System.arraycopy(source, 0, target, (row - this.firstRowOfPage) * this.columns, this.columns);
    }

    @Override
    protected void loadPage(int row) {
        if (this.data == null) {
            this.data = ByteBuffer.allocate(this.calculateBufferSizeToAllocate(this.rows, this.columns));
        }
        super.loadPage(row);
    }
}

