/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.operations.convolution;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.Kernel;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractSpecifiedBandsOperation;
import org.gvsig.tools.locator.LocatorException;

public class ConvolutionOperation
extends AbstractSpecifiedBandsOperation {
    public static final String AVERAGE_OPERATOR_STRING = "AVERAGE";
    public static final String LOW_PASS_OPERATOR_STRING = "LOW_PASS";
    public static final String HIGH_PASS_OPERATOR_STRING = "HIGH_PASS";
    public static final String GAUSS_OPERATOR_STRING = "GAUSS";
    public static final String CUSTOM_OPERATOR_STRING = "CUSTOM";
    public static String OPERATOR_PARAM = "operator";
    public static String CUSTOM_KERNEL_PARAM = "custom_kernel";
    public static String SHARPNESS_PARAM = "sharpness";
    public static String SIDE_WINDOW_PARAM = "side_window";
    private String operator;
    private int sideWindow;
    private int halfSideWindow;
    private double sharpness;
    private RowProcessor[] rowProcessors;
    private Kernel kernelOperator;
    static final double[][] gauss3x3 = new double[][]{{1.0, 4.0, 1.0}, {4.0, 12.0, 4.0}, {1.0, 4.0, 1.0}};
    static final double[][] gauss5x5 = new double[][]{{1.0, 2.0, 3.0, 2.0, 1.0}, {2.0, 7.0, 11.0, 7.0, 2.0}, {3.0, 11.0, 17.0, 11.0, 3.0}, {2.0, 7.0, 11.0, 7.0, 2.0}, {1.0, 2.0, 3.0, 2.0, 1.0}};
    static final double[][] gauss7x7 = new double[][]{{1.0, 1.0, 2.0, 2.0, 2.0, 1.0, 1.0}, {1.0, 2.0, 2.0, 4.0, 2.0, 2.0, 1.0}, {2.0, 2.0, 4.0, 8.0, 4.0, 2.0, 2.0}, {2.0, 4.0, 8.0, 16.0, 8.0, 4.0, 2.0}, {2.0, 2.0, 4.0, 8.0, 4.0, 2.0, 2.0}, {1.0, 2.0, 2.0, 4.0, 2.0, 2.0, 1.0}, {1.0, 1.0, 2.0, 2.0, 2.0, 1.0, 1.0}};
    static final double[][] gauss7x7aux = new double[][]{{0.0, 0.0, 3.0E-4, 6.0E-4, 3.0E-4, 0.0, 0.0}, {0.0, 0.0011, 0.0079, 0.0153, 0.0079, 0.0011, 0.0}, {3.0E-4, 0.0079, 0.0563, 0.1082, 0.0563, 0.0079, 3.0E-4}, {6.0E-4, 0.0153, 0.1082, 0.2079, 0.1082, 0.0153, 6.0E-4}, {3.0E-4, 0.0079, 0.0563, 0.1082, 0.0563, 0.0079, 3.0E-4}, {0.0, 0.0011, 0.0079, 0.0153, 0.0079, 0.0011, 0.0}, {0.0, 0.0, 3.0E-4, 6.0E-4, 3.0E-4, 0.0, 0.0}};
    static final double[][] lowpass3x3 = new double[][]{{0.0, 1.0, 0.0}, {1.0, 6.0, 1.0}, {0.0, 1.0, 0.0}};
    static final double[][] lowpass5x5 = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 4.0, 4.0, 4.0, 1.0}, {1.0, 4.0, 12.0, 4.0, 1.0}, {1.0, 4.0, 4.0, 4.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}};
    static final double[][] media3x3 = new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
    static final double[][] media5x5 = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}};
    static final double[][] media7x7 = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}};
    static final double[][] highpass3x3 = new double[][]{{-1.0, -1.0, -1.0}, {-1.0, 9.0, -1.0}, {-1.0, -1.0, -1.0}};

    public ConvolutionOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        this.sideWindow = (Integer)this.getParameter(SIDE_WINDOW_PARAM, 3);
        this.halfSideWindow = this.sideWindow / 2;
        this.sharpness = (Double)this.getParameter(SHARPNESS_PARAM, 0);
        block9 : switch (this.operator = (String)this.getParameter(OPERATOR_PARAM, AVERAGE_OPERATOR_STRING)) {
            case "AVERAGE": {
                switch (this.sideWindow) {
                    case 3: {
                        this.kernelOperator = manager.createKernel(media3x3, 9.0);
                        break block9;
                    }
                    case 5: {
                        this.kernelOperator = manager.createKernel(media5x5, 25.0);
                        break block9;
                    }
                    case 7: {
                        this.kernelOperator = manager.createKernel(media7x7, 49.0);
                        break block9;
                    }
                }
                throw new IllegalArgumentException("Kernel side isn't valid for the selected operator.");
            }
            case "LOW_PASS": {
                switch (this.sideWindow) {
                    case 3: {
                        this.kernelOperator = manager.createKernel(lowpass3x3, 10.0);
                        break block9;
                    }
                    case 5: {
                        this.kernelOperator = manager.createKernel(lowpass5x5);
                        break block9;
                    }
                }
                throw new IllegalArgumentException("Kernel side isn't valid for the selected operator.");
            }
            case "HIGH_PASS": {
                switch (this.sideWindow) {
                    case 3: {
                        double[][] h = new double[3][3];
                        for (int i = 0; i < h.length; ++i) {
                            for (int j = 0; j < h[i].length; ++j) {
                                h[i][j] = highpass3x3[i][j];
                            }
                        }
                        h[1][1] = 29.0 - this.sharpness * 20.9 / 100.0;
                        this.kernelOperator = manager.createKernel(h);
                        break block9;
                    }
                }
                throw new IllegalArgumentException("Kernel side isn't valid for the selected operator.");
            }
            case "GAUSS": {
                switch (this.sideWindow) {
                    case 3: {
                        this.kernelOperator = manager.createKernel(gauss3x3, 34.0);
                        break block9;
                    }
                    case 5: {
                        this.kernelOperator = manager.createKernel(gauss5x5, 121.0);
                        break block9;
                    }
                    case 7: {
                        this.kernelOperator = manager.createKernel(gauss7x7aux);
                        break block9;
                    }
                }
                throw new IllegalArgumentException("Kernel side isn't valid for the selected operator.");
            }
            case "CUSTOM": {
                this.kernelOperator = (Kernel)this.getParameter(CUSTOM_KERNEL_PARAM, null);
                if (this.kernelOperator == null) {
                    throw new IllegalArgumentException("A Kernel is needed for the selected operator.");
                }
                if (this.kernelOperator.getSide() == this.sideWindow) break;
                throw new IllegalArgumentException("Kernel side incorrect.");
            }
        }
        int bands = this.getInputBuffer().getBandCount();
        NoData[] noData = this.getInputBuffer().getBandNoData();
        if (this.mustCopyUnprocessedBands()) {
            try {
                this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getInputBuffer().getBandTypes(), this.getInputBuffer().getBandNoData(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
            }
            catch (CreateEnvelopeException | BufferException | LocatorException e) {
                throw new ProcessingOperationException(e);
            }
        }
        try {
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getProcessableBandTypesAsArray(), this.getProcessableBandNoDatasAsArray(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new ProcessingOperationException(e);
        }
        this.rowProcessors = new RowProcessor[bands];
        block45: for (int band = 0; band < noData.length; ++band) {
            if (!this.isProcessableBand(band)) continue;
            int bandType = this.getInputBuffer().getBand(band).getDataType();
            switch (bandType) {
                case 0: {
                    this.rowProcessors[band] = new ByteRowProcessor(band);
                    continue block45;
                }
                case 1: {
                    this.rowProcessors[band] = new UShortRowProcessor(band);
                    continue block45;
                }
                case 2: {
                    this.rowProcessors[band] = new ShortRowProcessor(band);
                    continue block45;
                }
                case 3: {
                    this.rowProcessors[band] = new IntRowProcessor(band);
                    continue block45;
                }
                case 4: {
                    this.rowProcessors[band] = new FloatRowProcessor(band);
                    continue block45;
                }
                case 5: {
                    this.rowProcessors[band] = new DoubleRowProcessor(band);
                    continue block45;
                }
                default: {
                    throw new IllegalArgumentException("Unknow type of band '" + band + "'");
                }
            }
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        for (int band = 0; band < this.getInputBuffer().getBandCount(); ++band) {
            if (this.getBandsToProcess().contains(band)) {
                Band bufferBand = this.getInputBuffer().getBand(band);
                Band outputBufferBand = this.getOutputBuffer().getBand(band);
                for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                    Object rowBuffer = bufferBand.createRowBuffer();
                    bufferBand.fetchRow(row, rowBuffer);
                    ArrayList<Object> bundle = new ArrayList<Object>();
                    if (row - this.halfSideWindow >= 0 && row + this.halfSideWindow < this.getInputBuffer().getRows()) {
                        for (int r = Math.max(row - this.halfSideWindow, 0); r <= Math.min(row + this.halfSideWindow, this.getInputBuffer().getRows() - 1); ++r) {
                            Object bundleRow = bufferBand.createRowBuffer();
                            bufferBand.fetchRow(r, bundleRow);
                            bundle.add(bundleRow);
                        }
                        Object outputRowBuffer = outputBufferBand.createRowBuffer();
                        this.rowProcessors[band].processRow(rowBuffer, bundle, outputRowBuffer);
                        outputBufferBand.putRow(row, outputRowBuffer);
                        continue;
                    }
                    if (this.getInputBuffer().getBandTypes()[band] != 0) continue;
                    outputBufferBand.putRow(row, rowBuffer);
                }
                continue;
            }
            if (!this.mustCopyUnprocessedBands()) continue;
            try {
                this.getOutputBuffer().getBand(band).copyFrom(this.getInputBuffer().getBand(band));
                continue;
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private class DoubleRowProcessor
    extends AbstractRowProcessor {
        public DoubleRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputDoubleRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputDoubleRow.length; ++i) {
                if (i - ConvolutionOperation.this.halfSideWindow >= 0 && i + ConvolutionOperation.this.halfSideWindow < inputDoubleRow.length) {
                    double[][] k = new double[ConvolutionOperation.this.sideWindow][ConvolutionOperation.this.sideWindow];
                    int r = 0;
                    int c = 0;
                    for (double[] dArray : bundleRow) {
                        for (int column = Math.max(i - ConvolutionOperation.this.halfSideWindow, 0); column <= Math.min(i + ConvolutionOperation.this.halfSideWindow, inputDoubleRow.length - 1); ++column) {
                            Double value = dArray[c];
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : value;
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Double)inputDoubleRow[i]).byteValue();
            }
        }
    }

    private class FloatRowProcessor
    extends AbstractRowProcessor {
        public FloatRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputFloatRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputFloatRow.length; ++i) {
                if (i - ConvolutionOperation.this.halfSideWindow >= 0 && i + ConvolutionOperation.this.halfSideWindow < inputFloatRow.length) {
                    double[][] k = new double[ConvolutionOperation.this.sideWindow][ConvolutionOperation.this.sideWindow];
                    int r = 0;
                    int c = 0;
                    for (float[] fArray : bundleRow) {
                        for (int column = Math.max(i - ConvolutionOperation.this.halfSideWindow, 0); column <= Math.min(i + ConvolutionOperation.this.halfSideWindow, inputFloatRow.length - 1); ++column) {
                            Float value = Float.valueOf(fArray[c]);
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : (double)value.floatValue();
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Float)inputFloatRow[i]).byteValue();
            }
        }
    }

    private class IntRowProcessor
    extends AbstractRowProcessor {
        public IntRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputIntRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputIntRow.length; ++i) {
                if (i - ConvolutionOperation.this.halfSideWindow >= 0 && i + ConvolutionOperation.this.halfSideWindow < inputIntRow.length) {
                    double[][] k = new double[ConvolutionOperation.this.sideWindow][ConvolutionOperation.this.sideWindow];
                    int r = 0;
                    int c = 0;
                    for (int[] nArray : bundleRow) {
                        for (int column = Math.max(i - ConvolutionOperation.this.halfSideWindow, 0); column <= Math.min(i + ConvolutionOperation.this.halfSideWindow, inputIntRow.length - 1); ++column) {
                            double value = Integer.valueOf(nArray[c]).intValue();
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : value;
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Integer)inputIntRow[i]).byteValue();
            }
        }
    }

    private class UShortRowProcessor
    extends AbstractRowProcessor {
        public UShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputShortRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                if (i - ConvolutionOperation.this.halfSideWindow >= 0 && i + ConvolutionOperation.this.halfSideWindow < inputShortRow.length) {
                    double[][] k = new double[ConvolutionOperation.this.sideWindow][ConvolutionOperation.this.sideWindow];
                    int r = 0;
                    int c = 0;
                    for (short[] sArray : bundleRow) {
                        for (int column = Math.max(i - ConvolutionOperation.this.halfSideWindow, 0); column <= Math.min(i + ConvolutionOperation.this.halfSideWindow, inputShortRow.length - 1); ++column) {
                            double value = 0xFFFF & Short.valueOf(sArray[c]);
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : value;
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Short)inputShortRow[i]).byteValue();
            }
        }
    }

    private class ShortRowProcessor
    extends AbstractRowProcessor {
        public ShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputShortRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                if (i - ConvolutionOperation.this.halfSideWindow >= 0 && i + ConvolutionOperation.this.halfSideWindow < inputShortRow.length) {
                    double[][] k = new double[ConvolutionOperation.this.sideWindow][ConvolutionOperation.this.sideWindow];
                    int r = 0;
                    int c = 0;
                    for (short[] sArray : bundleRow) {
                        for (int column = Math.max(i - ConvolutionOperation.this.halfSideWindow, 0); column <= Math.min(i + ConvolutionOperation.this.halfSideWindow, inputShortRow.length - 1); ++column) {
                            double value = Short.valueOf(sArray[c]).shortValue();
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : value;
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Short)inputShortRow[i]).byteValue();
            }
        }
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        public ByteRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            byte[] inputByteRow = (byte[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                if (i - ConvolutionOperation.this.halfSideWindow >= 0 && i + ConvolutionOperation.this.halfSideWindow < inputByteRow.length) {
                    double[][] k = new double[ConvolutionOperation.this.sideWindow][ConvolutionOperation.this.sideWindow];
                    int r = 0;
                    Iterator<Object> iterator = bundleRow.iterator();
                    while (iterator.hasNext()) {
                        int c = 0;
                        byte[] row = (byte[])iterator.next();
                        for (int column = Math.max(i - ConvolutionOperation.this.halfSideWindow, 0); column <= Math.min(i + ConvolutionOperation.this.halfSideWindow, inputByteRow.length - 1); ++column) {
                            byte value = row[column];
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : (double)(0xFF & value);
                            ++c;
                        }
                        ++r;
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    if (this.noData.isDefined() && this.noData.getValue().equals(inputByteRow[i])) {
                        outputByteRow[i] = inputByteRow[i];
                        continue;
                    }
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = inputByteRow[i];
            }
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        int band;
        NoData noData;

        public AbstractRowProcessor(int band) {
            this.band = band;
            this.noData = ConvolutionOperation.this.getInputBuffer().getBand(band).getNoData();
        }

        @Override
        public Number processValue(Kernel kernel) {
            double resultConvolution = ConvolutionOperation.this.kernelOperator.convolution(kernel);
            if (resultConvolution > 255.0) {
                resultConvolution = 255.0;
            } else if (resultConvolution < 0.0) {
                resultConvolution = 0.0;
            }
            return (byte)resultConvolution;
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, List<Object> var2, Object var3);

        public Number processValue(Kernel var1);
    }
}

