/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.statistics;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.statistics.HistogramBand;
import org.gvsig.raster.lib.buffer.api.statistics.HistogramClass;
import org.gvsig.raster.lib.buffer.api.statistics.StatisticsBand;
import org.gvsig.raster.lib.buffer.impl.statistics.DefaultHistogramBand;
import org.gvsig.raster.lib.buffer.impl.statistics.DefaultHistogramClass;
import org.gvsig.raster.lib.buffer.impl.statistics.StatisticalOperation;

public class HistogramOperation
implements StatisticalOperation {
    private StatisticsBand statisticsBand;
    private List<HistogramClass> histogramClasses;
    private HistogramBand histogramBand;
    private Band band;

    public HistogramOperation(StatisticsBand statisticsBand, Band band) {
        this.statisticsBand = statisticsBand;
        this.band = band;
    }

    @Override
    public void pre() {
        int dataType = this.statisticsBand.getDataType();
        if (dataType == 5 || dataType == 4) {
            this.calculateHistogramClasses();
            this.histogramBand = new DefaultHistogramBand(this.band, this.histogramClasses);
        } else {
            this.histogramBand = new DefaultHistogramBand(this.band);
        }
    }

    private void calculateHistogramClasses() {
        int classesNumber = new Double(Math.ceil(Math.sqrt(this.statisticsBand.getBandLength() - this.statisticsBand.getNoDataValuesCount()))).intValue();
        this.histogramClasses = new ArrayList<HistogramClass>(classesNumber);
        double range = this.statisticsBand.getMaximum() - this.statisticsBand.getMinimum();
        double widthInterval = range / (double)classesNumber;
        double minInterval = this.statisticsBand.getMinimum();
        for (int i = 0; i < classesNumber - 1; ++i) {
            double maxInterval = minInterval + widthInterval;
            DefaultHistogramClass histogramClass = new DefaultHistogramClass(minInterval, maxInterval);
            histogramClass.setValue(0L);
            this.histogramClasses.add(histogramClass);
            minInterval = maxInterval;
        }
        DefaultHistogramClass histogramClass = new DefaultHistogramClass(minInterval, this.statisticsBand.getMaximum());
        this.histogramClasses.add(histogramClass);
    }

    @Override
    public void addValue(Number value) {
        ((DefaultHistogramBand)this.histogramBand).addValue(value.doubleValue());
    }

    @Override
    public void post() {
    }

    @Override
    public Object getResult() {
        return this.histogramBand;
    }
}

