/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.effects;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.AppResourceLoader;
import com.jeta.open.resources.ResourceLoader;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;

public class ImagePainter
implements Painter {
    private Icon m_icon;
    private int m_halign;
    private int m_valign;
    private static Icon m_design_icon;
    private Rectangle m_rect = new Rectangle();

    public ImagePainter() {
        this(null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePainter(Icon icon, int hAlign, int vAlign) {
        this.m_icon = icon;
        this.m_halign = hAlign;
        this.m_valign = vAlign;
        Class clazz = ImagePainter.class;
        synchronized (clazz) {
            if (m_design_icon == null) {
                try {
                    if (FormUtils.isDesignMode()) {
                        ResourceLoader loader = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
                        FormUtils.safeAssert(loader != null);
                        if (loader != null) {
                            m_design_icon = loader.loadImage("jeta.resources/images/general/16x16/portrait.png");
                        }
                    } else {
                        m_design_icon = AppResourceLoader.getEmptyIcon();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int getIconHeight() {
        if (this.m_icon == null) {
            if (m_design_icon == null) {
                return 0;
            }
            return m_design_icon.getIconHeight();
        }
        return this.m_icon.getIconHeight();
    }

    public int getIconWidth() {
        if (this.m_icon == null) {
            if (m_design_icon == null) {
                return 0;
            }
            return m_design_icon.getIconWidth();
        }
        return this.m_icon.getIconWidth();
    }

    public int getHorizontalAlignment() {
        return this.m_halign;
    }

    public int getVerticalAlignment() {
        return this.m_valign;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setHorizontalAlignment(int halign) {
        this.m_halign = halign;
    }

    public void setVerticalAlignment(int valign) {
        this.m_valign = valign;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    public void paint(Component comp, Graphics g, int x1, int y1, int width, int height) {
        int x = x1;
        int y = y1;
        int halign = this.getHorizontalAlignment();
        x = halign == 1 ? (width - this.getIconWidth()) / 2 : (halign == 2 ? width - this.getIconWidth() : x1);
        int valign = this.getVerticalAlignment();
        y = valign == 1 ? (height - this.getIconHeight()) / 2 : (valign == 5 ? height - this.getIconHeight() : y1);
        if (x < x1) {
            x = x1;
        }
        if (y < y1) {
            y = y1;
        }
        Icon icon = this.getIcon();
        Rectangle clip_rect = g.getClipBounds();
        this.m_rect.setBounds(x, y, width, height);
        if (this.m_rect.intersects(clip_rect)) {
            this.m_rect = this.m_rect.intersection(clip_rect);
            g.setClip(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
            if (icon == null) {
                if (m_design_icon != null) {
                    m_design_icon.paintIcon(comp, g, x, y);
                }
            } else {
                icon.paintIcon(comp, g, x, y);
            }
            g.setClip(clip_rect.x, clip_rect.y, clip_rect.width, clip_rect.height);
        }
    }

    public void paint(Component comp, Graphics g, Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.paint(comp, g, rect.x, rect.y, rect.width, rect.height);
    }
}

