/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.form.FormAccessor;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.gui.form.StandardComponent;
import java.awt.Component;
import java.awt.Container;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FormIterator
implements Iterator {
    private FormAccessor m_accessor;
    private long m_time_stamp;
    private boolean m_nested;
    private int m_index = -1;
    private Iterator m_nested_iter = null;
    private Component m_last_comp;
    private long m_mod_stamp;

    public FormIterator(FormAccessor accessor, boolean nested) {
        this.m_accessor = accessor;
        this.m_nested = nested;
        this.m_index = -1;
        this.m_mod_stamp = ((GridView)accessor).getModificationStamp();
    }

    private void checkConcurrentModification() {
        GridView view = (GridView)this.m_accessor;
        if (this.m_mod_stamp < view.getModificationStamp()) {
            throw new ConcurrentModificationException();
        }
        long nested_stamp = view.getNestedModificationStamp();
        if (nested_stamp <= 0L) {
            nested_stamp = this.m_mod_stamp;
        }
        if (this.isNested() && this.m_mod_stamp < nested_stamp) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean hasNext() {
        Container cc;
        int pos;
        if (this.m_nested_iter != null) {
            if (this.m_nested_iter.hasNext()) {
                return true;
            }
            this.m_nested_iter = null;
        }
        if ((pos = this.m_index + 1) >= (cc = this.m_accessor.getContainer()).getComponentCount()) {
            return false;
        }
        while (pos < cc.getComponentCount()) {
            Component comp = cc.getComponent(pos);
            if (comp instanceof GridComponent) {
                Component jbean;
                GridComponent gc = (GridComponent)comp;
                if (gc instanceof FormComponent) {
                    this.m_index = pos - 1;
                    return true;
                }
                if (gc instanceof StandardComponent && (jbean = gc.getBeanDelegate()) != null) {
                    this.m_index = pos - 1;
                    return true;
                }
            } else if (comp instanceof Component) {
                this.m_index = pos - 1;
                return true;
            }
            ++pos;
        }
        this.m_index = pos;
        return false;
    }

    private boolean isNested() {
        return this.m_nested;
    }

    public Object next() {
        this.checkConcurrentModification();
        if (this.m_nested_iter != null) {
            return this.m_nested_iter.next();
        }
        this.m_last_comp = null;
        ++this.m_index;
        Container cc = this.m_accessor.getContainer();
        if (this.m_index >= cc.getComponentCount()) {
            throw new NoSuchElementException();
        }
        while (this.m_index < cc.getComponentCount()) {
            Component comp = cc.getComponent(this.m_index);
            if (comp instanceof GridComponent) {
                GridComponent gc = (GridComponent)comp;
                if (gc instanceof FormComponent) {
                    FormIterator niter;
                    FormComponent fc = (FormComponent)gc;
                    if (this.isNested() && (niter = new FormIterator(fc.getChildView().getFormAccessor(), this.isNested())).hasNext()) {
                        this.m_nested_iter = niter;
                    }
                    this.m_last_comp = fc;
                    return fc.getChildView();
                }
                if (gc instanceof StandardComponent) {
                    JETABean jetabean = gc.getBean();
                    Component jbean = null;
                    if (jetabean != null) {
                        jbean = jetabean.getBeanChildComponent();
                    }
                    if (jbean != null) {
                        this.m_last_comp = jbean;
                        return jbean;
                    }
                }
            } else if (comp instanceof Component) {
                this.m_last_comp = comp;
                return comp;
            }
            ++this.m_index;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        this.checkConcurrentModification();
        if (this.m_nested_iter != null) {
            this.m_nested_iter.remove();
            return;
        }
        if (this.m_last_comp == null) {
            throw new IllegalStateException();
        }
        if (this.m_accessor.removeBean(this.m_last_comp) != null) {
            --this.m_index;
            this.m_last_comp = null;
            this.m_mod_stamp = ((GridView)this.m_accessor).getModificationStamp();
        }
    }
}

