/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormSpecAdapter;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.components.ComponentFactory;
import com.jeta.forms.gui.components.ComponentSource;
import com.jeta.forms.gui.components.EmptyComponentFactory;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.gui.form.BackgroundPainter;
import com.jeta.forms.gui.form.CellAssignmentCache;
import com.jeta.forms.gui.form.CellPainter;
import com.jeta.forms.gui.form.ComponentConstraints;
import com.jeta.forms.gui.form.FormAccessor;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.FormContainerComponent;
import com.jeta.forms.gui.form.FormIterator;
import com.jeta.forms.gui.form.GridCellEvent;
import com.jeta.forms.gui.form.GridCellListener;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridOverlay;
import com.jeta.forms.gui.form.GridOverlayFactory;
import com.jeta.forms.gui.form.GridViewEvent;
import com.jeta.forms.gui.form.GridViewListener;
import com.jeta.forms.gui.form.JETALayerLayout;
import com.jeta.forms.gui.form.ReadOnlyConstraints;
import com.jeta.forms.gui.form.StandardComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.memento.FormGroupSet;
import com.jeta.forms.store.properties.effects.PaintProperty;
import com.jeta.forms.store.support.Matrix;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.registry.JETARegistry;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class GridView
extends JETAPanel
implements Paintable,
FormAccessor,
GridCellListener {
    private FormLayout m_formlayout;
    private FormContainer m_form;
    private JLayeredPane m_layered_pane;
    private BackgroundPainter m_background_painter;
    private CellAssignmentCache m_assignment_cache = new CellAssignmentCache(this);
    private GridOverlay m_overlay;
    private FormLayout.LayoutInfo m_layoutinfo = null;
    private CellPainter m_cell_painter;
    private Matrix m_cell_painters = new Matrix(0, 0);
    private FormGroupSet m_col_groups = new FormGroupSet();
    private FormGroupSet m_row_groups = new FormGroupSet();
    private long m_nested_mod_stamp = -1L;
    private boolean m_events_enabled = false;
    private LinkedList m_listeners = new LinkedList();
    public static final Integer BACKGROUND_PAINTER_LAYER = new Integer(0);
    public static final Integer CELL_PAINTER_LAYER = new Integer(1);
    public static final Integer FORM_LAYER = new Integer(2);
    public static final Integer OVERLAY_LAYER = new Integer(9);
    public static final Integer FOCUS_LAYER = new Integer(10);
    private GridComponent m_last_comp;

    public GridView() {
        this.setOpaque(true);
    }

    public GridView(String colspecs, String rowspecs) {
        this.initialize(colspecs, rowspecs);
    }

    public GridView(int cols, int rows) {
        this.initialize(cols, rows);
    }

    public void addComponent(GridComponent gc, CellConstraints cc) {
        gc.addListener(this);
        this.m_form.add((Component)gc, cc);
        this.m_assignment_cache.addComponent(gc);
        this.m_form.revalidate();
        this.fireGridEvent(new GridViewEvent(this, 8));
        this.unitTest();
    }

    public void addComponent(GridComponent gc, ComponentConstraints cc) {
        this.addComponent(gc, cc.createCellConstraints());
    }

    public void addListener(GridViewListener listener) {
        if (listener != null && !this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void cellChanged(GridCellEvent evt) {
        if (evt.getId() == 2) {
            this.fireGridEvent(new GridViewEvent(this, 9, evt));
        } else if (evt.getId() == 3) {
            this.fireGridEvent(new GridViewEvent(this, 10, evt));
            this.m_last_comp = evt.getSource();
        } else {
            this.fireGridEvent(new GridViewEvent(this, 8, evt));
        }
    }

    public void deselectAll() {
        if (this.m_last_comp != null) {
            this.m_last_comp.setSelected(false);
        }
    }

    public void doLayout() {
        super.doLayout();
        this.m_form.doLayout();
    }

    public void enableEvents(boolean enable) {
        this.m_events_enabled = enable;
    }

    public void fireGridEvent(GridViewEvent evt) {
        if (this.isEventsEnabled()) {
            if (evt.getId() != 9 && evt.getId() != 10) {
                this.refreshView();
            }
            this.m_layoutinfo = null;
            Iterator iter = this.m_listeners.iterator();
            while (iter.hasNext()) {
                try {
                    GridViewListener listener = (GridViewListener)iter.next();
                    listener.gridChanged(evt);
                }
                catch (Exception e) {
                    FormsLogger.debug(e);
                }
            }
        }
    }

    public static void fillCells(GridView view, ComponentSource compsrc) {
        try {
            for (int col = 1; col <= view.getColumnCount(); ++col) {
                for (int row = 1; row <= view.getRowCount(); ++row) {
                    EmptyComponentFactory factory = new EmptyComponentFactory(compsrc);
                    StandardComponent gc = (StandardComponent)factory.createComponent("empty", view);
                    view.addComponent((GridComponent)gc, new ReadOnlyConstraints(col, row));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Rectangle getCellBounds(int col, int row) {
        try {
            int org_x = this.getColumnOrgX(col);
            int org_y = this.getRowOrgY(row);
            int width = this.getColumnWidth(col);
            int height = this.getRowHeight(col);
            return new Rectangle(org_x, org_y, width, height);
        }
        catch (Exception e) {
            System.out.println("GridView.getCellBounds exception:  col: " + col + "  row: " + row);
            e.printStackTrace();
            return null;
        }
    }

    public Matrix getCellPainters() {
        FormUtils.safeAssert(this.m_cell_painters.getRowCount() == this.getRowCount());
        FormUtils.safeAssert(this.m_cell_painters.getColumnCount() == this.getColumnCount());
        return this.m_cell_painters;
    }

    public int getColumnCount() {
        return this.m_formlayout.getColumnCount();
    }

    public int getColumnOrgX(int col) {
        FormLayout.LayoutInfo linfo = this.getLayoutInfo();
        return linfo.columnOrigins[--col];
    }

    public FormGroupSet getColumnGroups() {
        return this.m_col_groups;
    }

    public String getColumnSpecs() {
        StringBuffer sbuff = new StringBuffer();
        for (int col = 1; col <= this.getColumnCount(); ++col) {
            ColumnSpec cs = this.getColumnSpec(col);
            if (col > 1) {
                sbuff.append(",");
            }
            String colspec = cs.toShortString();
            sbuff.append(FormSpecAdapter.fixup(colspec));
        }
        return sbuff.toString();
    }

    public int getColumnWidth(int col) {
        FormLayout.LayoutInfo linfo = this.getLayoutInfo();
        return linfo.columnOrigins[--col + 1] - linfo.columnOrigins[col];
    }

    public ColumnSpec getColumnSpec(int col) {
        return this.m_formlayout.getColumnSpec(col);
    }

    public FormAccessor getFormAccessor() {
        return this;
    }

    public Container getFormContainer() {
        return this.m_form;
    }

    public String getFormName() {
        return this.getName();
    }

    long getModificationStamp() {
        return this.m_form.getModificationStamp();
    }

    long getNestedModificationStamp() {
        return this.m_nested_mod_stamp;
    }

    public int getRowCount() {
        return this.m_formlayout.getRowCount();
    }

    public FormLayout getFormLayout() {
        return this.m_formlayout;
    }

    public int getFormWidth() {
        FormLayout.LayoutInfo linfo = this.getLayoutInfo();
        return linfo.getWidth();
    }

    public int getFormHeight() {
        FormLayout.LayoutInfo linfo = this.getLayoutInfo();
        return linfo.getHeight();
    }

    public GridComponent getGridComponent(int col, int row) {
        return this.m_assignment_cache.getGridComponent(col, row);
    }

    public int getGridComponentCount() {
        return this.m_form.getComponentCount();
    }

    public GridComponent getGridComponent(int index) {
        Component obj = this.m_form.getComponent(index);
        if (obj instanceof GridComponent) {
            return (GridComponent)obj;
        }
        return null;
    }

    FormLayout.LayoutInfo getLayoutInfo() {
        if (this.m_layoutinfo == null) {
            this.m_layoutinfo = this.m_formlayout.getLayoutInfo((Container)this.m_form);
        }
        return this.m_layoutinfo;
    }

    public PaintProperty getPaintProperty(int col, int row) {
        Object obj = this.m_cell_painters.getValue(row - 1, col - 1);
        if (obj instanceof PaintProperty) {
            PaintProperty pp = (PaintProperty)obj;
            if (pp != null) {
                return pp;
            }
            return null;
        }
        if (obj != null) {
            System.out.println("GridView.getPaintProperty failed  for col: " + col + " row: " + row + "  prop: " + obj.getClass());
        }
        return null;
    }

    public FormComponent getParentForm() {
        for (Container cc = this.getParent(); cc != null && !(cc instanceof Window); cc = cc.getParent()) {
            if (!(cc instanceof FormComponent)) continue;
            FormComponent fc = (FormComponent)cc;
            FormUtils.safeAssert(fc.getBean().getDelegate() == this);
            return fc;
        }
        FormUtils.safeAssert(false);
        return null;
    }

    public int getRowHeight(int row) {
        FormLayout.LayoutInfo linfo = this.getLayoutInfo();
        return linfo.rowOrigins[--row + 1] - linfo.rowOrigins[row];
    }

    public int getRowOrgY(int row) {
        FormLayout.LayoutInfo linfo = this.getLayoutInfo();
        return linfo.rowOrigins[--row];
    }

    public GridComponent getOverlappingComponent(int col, int row) {
        return this.m_assignment_cache.getOverlappingComponent(col, row);
    }

    public GridOverlay getOverlay() {
        return this.m_overlay;
    }

    public FormGroupSet getRowGroups() {
        return this.m_row_groups;
    }

    public RowSpec getRowSpec(int row) {
        FormUtils.safeAssert(row >= 1 && row <= this.getRowCount());
        return this.m_formlayout.getRowSpec(row);
    }

    public String getRowSpecs() {
        StringBuffer sbuff = new StringBuffer();
        for (int row = 1; row <= this.getRowCount(); ++row) {
            RowSpec rs = this.getRowSpec(row);
            if (row > 1) {
                sbuff.append(",");
            }
            String rowspec = rs.toString();
            sbuff.append(FormSpecAdapter.fixup(rowspec));
        }
        return sbuff.toString();
    }

    public GridComponent getSelectedComponent() {
        Iterator iter = this.gridIterator();
        while (iter.hasNext()) {
            GridComponent cc;
            GridComponent gc = (GridComponent)iter.next();
            if (!(gc instanceof FormComponent ? (gc = ((FormComponent)(cc = (FormComponent)gc)).getSelectedComponent()) != null : (gc instanceof FormContainerComponent ? (gc = ((FormContainerComponent)(cc = (FormContainerComponent)gc)).getSelectedComponent()) != null : gc.isSelected()))) continue;
            return gc;
        }
        return null;
    }

    public void initialize(int cols, int rows) {
        this.enableEvents(FormUtils.isDesignMode());
        StringBuffer colspec = new StringBuffer();
        for (int col = 1; col <= cols; ++col) {
            if (col > 1) {
                colspec.append(",");
            }
            colspec.append("f:d:n");
        }
        StringBuffer rowspec = new StringBuffer();
        for (int row = 1; row <= rows; ++row) {
            if (row > 1) {
                rowspec.append(",");
            }
            rowspec.append("c:d:n");
        }
        this.initialize(colspec.toString(), rowspec.toString());
        this.m_cell_painters = new Matrix(this.getRowCount(), this.getColumnCount());
    }

    void initialize(String colspecs, String rowspecs) {
        this.removeAll();
        colspecs = FormSpecAdapter.fixupSpecs(colspecs);
        rowspecs = FormSpecAdapter.fixupSpecs(rowspecs);
        FormUtils.safeAssert(this.m_formlayout == null);
        this.setOpaque(true);
        this.m_formlayout = new FormLayout(colspecs, rowspecs);
        this.m_form = new FormContainer();
        this.m_form.setOpaque(false);
        this.m_form.setLayout((LayoutManager)this.m_formlayout);
        this.setLayout(new BorderLayout());
        this.m_layered_pane = new JLayeredPane();
        this.m_layered_pane.setOpaque(false);
        this.m_layered_pane.setLayout(new JETALayerLayout());
        this.m_background_painter = new BackgroundPainter();
        this.m_cell_painter = new CellPainter(this);
        this.m_layered_pane.add((Component)this.m_background_painter, BACKGROUND_PAINTER_LAYER);
        this.m_layered_pane.add((Component)this.m_cell_painter, CELL_PAINTER_LAYER);
        this.m_layered_pane.add((Component)this.m_form, FORM_LAYER);
        super.add((Component)this.m_layered_pane, "Center");
        if (FormUtils.isDesignMode()) {
            GridOverlayFactory factory = (GridOverlayFactory)JETARegistry.lookup("grid.overlay.factory");
            if (factory != null) {
                this.m_overlay = factory.createOverlay(this);
                ((JComponent)this.getFormContainer()).setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1));
                this.m_layered_pane.add((Component)((JComponent)((Object)this.m_overlay)), OVERLAY_LAYER);
            } else {
                FormUtils.safeAssert(false);
            }
        }
    }

    public void insertColumn(int col, ColumnSpec colspec, ComponentFactory factory) throws FormException {
        Iterator iter;
        int old_col_count = this.getColumnCount();
        LinkedList<GridComponent> comps = new LinkedList<GridComponent>();
        for (int row = 1; row <= this.getRowCount(); ++row) {
            GridComponent gc = factory.createComponent("test", this);
            comps.add(gc);
        }
        CellConstraints cc = new CellConstraints();
        FormLayout layout = this.getFormLayout();
        if (col > this.getColumnCount()) {
            col = this.getColumnCount() + 1;
            layout.appendColumn(colspec);
        } else {
            layout.insertColumn(col, colspec);
        }
        if (FormUtils.isDebug()) {
            iter = this.gridIterator();
            while (iter.hasNext()) {
                GridComponent curr_gc = (GridComponent)iter.next();
                if (curr_gc.getColumn() != col) continue;
                System.out.println("GridView.insertRow failed at: col: " + col + " row: " + curr_gc.getRow() + "  gc: " + curr_gc);
            }
        }
        iter = comps.iterator();
        int row = 1;
        while (iter.hasNext()) {
            GridComponent gc = (GridComponent)iter.next();
            this.addComponent(gc, cc.xy(col, row));
            ++row;
        }
        this.m_cell_painters.insertColumn(col - 1);
        FormUtils.safeAssert(this.getColumnCount() == old_col_count + 1);
        FormUtils.safeAssert(this.getGridComponentCount() == this.getColumnCount() * this.getRowCount());
        this.updateColumnGroups();
        this.fireGridEvent(new GridViewEvent(this, 4));
    }

    public void insertRow(int row, RowSpec rowspec, ComponentFactory factory) throws FormException {
        Iterator iter;
        int old_row_count = this.getRowCount();
        LinkedList<GridComponent> comps = new LinkedList<GridComponent>();
        for (int col = 1; col <= this.getColumnCount(); ++col) {
            GridComponent gc = factory.createComponent("", this);
            comps.add(gc);
        }
        CellConstraints cc = new CellConstraints();
        FormLayout layout = this.getFormLayout();
        if (row > this.getRowCount()) {
            row = this.getRowCount() + 1;
            layout.appendRow(rowspec);
        } else {
            layout.insertRow(row, rowspec);
        }
        if (FormUtils.isDebug()) {
            iter = this.gridIterator();
            while (iter.hasNext()) {
                GridComponent curr_gc = (GridComponent)iter.next();
                if (curr_gc.getRow() != row) continue;
                System.out.println("GridView.insertRow failed at: col: " + curr_gc.getColumn() + " row: " + row + "  gc: " + curr_gc);
            }
        }
        iter = comps.iterator();
        int col = 1;
        while (iter.hasNext()) {
            GridComponent gc = (GridComponent)iter.next();
            this.addComponent(gc, cc.xy(col, row));
            ++col;
        }
        this.m_cell_painters.insertRow(row - 1);
        FormUtils.safeAssert(this.getRowCount() == old_row_count + 1);
        FormUtils.safeAssert(this.getGridComponentCount() == this.getColumnCount() * this.getRowCount());
        this.updateRowGroups();
        this.fireGridEvent(new GridViewEvent(this, 1));
    }

    public boolean isEventsEnabled() {
        return this.m_events_enabled;
    }

    public boolean isGridVisible() {
        return this.m_overlay.isGridVisible();
    }

    public Iterator gridIterator() {
        return new ComponentIterator();
    }

    public Collection listComponents() {
        LinkedList list = new LinkedList();
        Iterator iter = this.gridIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            FormUtils.safeAssert(obj instanceof GridComponent);
            list.add(obj);
        }
        return list;
    }

    public void refreshView() {
        this.syncCellAssignments();
        this.revalidate();
        this.repaint();
    }

    public void removeColumn(int column) {
        GridComponent gc;
        if (column < 1 || column > this.getColumnCount()) {
            FormUtils.safeAssert(false);
            return;
        }
        this.m_cell_painters.removeColumn(column - 1);
        LinkedList<GridComponent> comps = new LinkedList<GridComponent>();
        Iterator iter = this.gridIterator();
        while (iter.hasNext()) {
            gc = (GridComponent)iter.next();
            if (gc.getColumn() != column) continue;
            comps.add(gc);
        }
        iter = comps.iterator();
        while (iter.hasNext()) {
            gc = (GridComponent)iter.next();
            this.m_form.remove(gc);
        }
        this.m_formlayout.removeColumn(column);
        this.updateColumnGroups();
        this.fireGridEvent(new GridViewEvent(this, 5));
    }

    public void removeListener(GridViewListener listener) {
        if (listener != null) {
            this.m_listeners.remove(listener);
        }
    }

    public void removeRow(int row) {
        GridComponent gc;
        if (row < 1 || row > this.getRowCount()) {
            FormUtils.safeAssert(false);
            return;
        }
        this.m_cell_painters.removeRow(row - 1);
        LinkedList<GridComponent> comps = new LinkedList<GridComponent>();
        Iterator iter = this.gridIterator();
        while (iter.hasNext()) {
            gc = (GridComponent)iter.next();
            if (gc.getRow() != row) continue;
            comps.add(gc);
        }
        iter = comps.iterator();
        while (iter.hasNext()) {
            gc = (GridComponent)iter.next();
            this.m_form.remove(gc);
        }
        this.m_formlayout.removeRow(row);
        this.updateRowGroups();
        this.fireGridEvent(new GridViewEvent(this, 2));
    }

    public void replaceComponent(GridComponent newComp, GridComponent oldComp) {
        CellConstraints cc = oldComp.getConstraints().createCellConstraints();
        this.setComponent(newComp, cc);
        this.fireGridEvent(new GridViewEvent(this, 8));
    }

    public void revalidate() {
        if (this.m_form != null) {
            this.m_form.revalidate();
        }
        super.revalidate();
    }

    public void setBackgroundPainter(Painter p) {
        if (this.m_background_painter != null) {
            this.m_background_painter.setBackgroundPainter(p);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.m_layoutinfo = null;
    }

    public void setCellPainters(Matrix painters) {
        if (painters == null) {
            this.m_cell_painters = new Matrix(this.getRowCount(), this.getColumnCount());
        } else {
            this.m_cell_painters = painters;
            if (painters.getRowCount() != this.getRowCount() || painters.getColumnCount() != this.getColumnCount()) {
                this.m_cell_painters = new Matrix(this.getRowCount(), this.getColumnCount());
            }
        }
    }

    public void setColumnSpec(int col, ColumnSpec colspec) {
        FormLayout layout = this.getFormLayout();
        ColumnSpec newspec = new ColumnSpec(colspec.getDefaultAlignment(), colspec.getSize(), colspec.getResizeWeight());
        layout.setColumnSpec(col, newspec);
        this.m_form.revalidate();
        this.fireGridEvent(new GridViewEvent(this, 7));
    }

    public void setComponent(GridComponent gc, CellConstraints cc) {
        GridComponent oldcomp = this.getGridComponent(cc.gridX, cc.gridY);
        if (oldcomp != null) {
            oldcomp.removeListener(this);
            this.m_form.remove(oldcomp);
        }
        gc.addListener(this);
        this.m_form.add((Component)gc, cc);
        this.m_form.revalidate();
        this.syncCellAssignments();
        this.fireGridEvent(new GridViewEvent(this, 8));
        this.unitTest();
    }

    public void setComponent(GridComponent gc, ComponentConstraints cc) {
        this.setComponent(gc, cc.createCellConstraints());
    }

    public void setConstraints(GridComponent gc, CellConstraints cc) {
        this.m_formlayout.setConstraints((Component)gc, cc);
        this.syncCellAssignments();
        this.m_form.revalidate();
        this.fireGridEvent(new GridViewEvent(this, 8, gc));
    }

    public void setConstraints(GridComponent gc, ComponentConstraints cc) {
        this.setConstraints(gc, cc.createCellConstraints());
    }

    public void setGridVisible(boolean bvis) {
        this.m_overlay.setGridVisible(bvis);
    }

    public void setPaintProperty(int col, int row, PaintProperty pp) {
        this.m_cell_painters.setValue(row - 1, col - 1, pp);
        this.repaint();
    }

    public void setColumnGroups(FormGroupSet groups) {
        if (groups != null) {
            int[][] grp_idxs = groups.toArray();
            for (int index = 0; index < grp_idxs.length; ++index) {
                int[] col_grp = grp_idxs[index];
                for (int colidx = 0; colidx < col_grp.length; ++colidx) {
                    int col = col_grp[colidx];
                    if (col >= 1 && col <= this.getColumnCount()) continue;
                    FormUtils.safeAssert(false);
                    return;
                }
            }
            this.m_formlayout.setColumnGroups(grp_idxs);
            this.m_col_groups = groups;
            this.fireGridEvent(new GridViewEvent(this, 12));
        }
    }

    public void setRowGroups(FormGroupSet groups) {
        if (groups != null) {
            int[][] grp_idxs = groups.toArray();
            for (int index = 0; index < grp_idxs.length; ++index) {
                int[] row_grp = grp_idxs[index];
                for (int rowidx = 0; rowidx < row_grp.length; ++rowidx) {
                    int row = row_grp[rowidx];
                    if (row >= 1 && row <= this.getRowCount()) continue;
                    FormUtils.safeAssert(false);
                    return;
                }
            }
            this.m_formlayout.setRowGroups(grp_idxs);
            this.m_row_groups = groups;
            this.fireGridEvent(new GridViewEvent(this, 11));
        }
    }

    public void setRowSpec(int row, RowSpec rowspec) {
        FormLayout layout = this.getFormLayout();
        RowSpec newspec = new RowSpec(rowspec.getDefaultAlignment(), rowspec.getSize(), rowspec.getResizeWeight());
        layout.setRowSpec(row, newspec);
        this.m_form.revalidate();
        this.fireGridEvent(new GridViewEvent(this, 3));
    }

    private void syncCellAssignments() {
        this.m_assignment_cache.sync();
    }

    public void addBean(Component comp, CellConstraints cc) {
        if (comp == null) {
            System.err.println("addBean: comp cannot be null");
            return;
        }
        if (cc == null) {
            System.err.println("addBean: cc cannot be null");
            return;
        }
        this.m_form.add(comp, cc);
        this.refreshView();
    }

    public CellConstraints getConstraints(Component comp) {
        return this.getFormLayout().getConstraints(comp);
    }

    public Container getContainer() {
        return this.getFormContainer();
    }

    public Iterator beanIterator() {
        return new FormIterator(this, false);
    }

    public Iterator beanIterator(boolean nested) {
        return new FormIterator(this, nested);
    }

    public Component removeBean(Component comp) {
        if (comp == null) {
            System.err.println("removeBean: comp cannot be null");
            return null;
        }
        return this.replaceBean(comp, null);
    }

    public Component removeBean(String compName) {
        if (compName == null) {
            System.err.println("removeBean: compName cannot be null");
            return null;
        }
        for (int index = 0; index < this.m_form.getComponentCount(); ++index) {
            Component bean;
            JScrollPane scroll;
            JViewport viewport;
            Component comp = this.m_form.getComponent(index);
            if (compName.equals(comp.getName())) {
                this.m_form.remove(comp);
                this.refreshView();
                return comp;
            }
            if (comp instanceof GridComponent) {
                JScrollPane scroll2;
                JViewport viewport2;
                GridComponent gc = (GridComponent)comp;
                Component bean2 = gc.getBeanChildComponent();
                if (bean2 != null && compName.equals(bean2.getName())) {
                    this.m_form.remove(comp);
                    this.refreshView();
                    return comp;
                }
                if (!(bean2 instanceof JScrollPane) || (viewport2 = (scroll2 = (JScrollPane)bean2).getViewport()) == null || (bean2 = viewport2.getView()) == null || !compName.equals(bean2.getName())) continue;
                this.m_form.remove(scroll2);
                this.refreshView();
                return scroll2;
            }
            if (!(comp instanceof JScrollPane) || (viewport = (scroll = (JScrollPane)comp).getViewport()) == null || (bean = viewport.getView()) == null || !compName.equals(bean.getName())) continue;
            this.m_form.remove(comp);
            this.refreshView();
            return comp;
        }
        return null;
    }

    public Component replaceBean(Component oldComp, Component newComponent) {
        if (oldComp == null) {
            System.err.println("replaceBean: oldComponent cannot be null");
            return null;
        }
        Component comp = null;
        CellConstraints cc = null;
        for (int index = 0; index < this.m_form.getComponentCount(); ++index) {
            Component bean;
            JScrollPane scroll;
            JViewport viewport;
            comp = this.m_form.getComponent(index);
            cc = this.m_formlayout.getConstraints(comp);
            if (oldComp == comp) break;
            if (comp instanceof GridComponent) {
                Component vbean;
                JScrollPane scroll2;
                JViewport viewport2;
                GridComponent gc = (GridComponent)comp;
                Component bean2 = gc.getBeanChildComponent();
                if (bean2 instanceof JScrollPane && (viewport2 = (scroll2 = (JScrollPane)bean2).getViewport()) != null && (vbean = viewport2.getView()) == oldComp) {
                    comp = scroll2;
                    break;
                }
                if (bean2 == oldComp) {
                    break;
                }
            } else if (comp instanceof JScrollPane && (viewport = (scroll = (JScrollPane)comp).getViewport()) != null && (bean = viewport.getView()) == oldComp) break;
            comp = null;
        }
        if (comp != null) {
            this.m_form.remove(comp);
            if (newComponent != null) {
                this.m_form.add(newComponent, cc);
            }
            this.refreshView();
            return comp;
        }
        System.err.println("replaceBean failed.  Unable to find oldComp: " + oldComp.getClass() + "  name: " + oldComp.getName());
        return null;
    }

    public Component replaceBean(String compName, Component newComponent) {
        if (compName == null) {
            System.err.println("replaceBean failed.  compName cannot be null. ");
            return null;
        }
        Iterator iter = this.beanIterator(false);
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (!compName.equals(comp.getName())) continue;
            return this.replaceBean(comp, newComponent);
        }
        System.err.println("replaceBean failed.  Unable to find compName: " + compName);
        return null;
    }

    private void unitTest() {
    }

    public void updateColumnGroups() {
        try {
            FormGroupSet gset = new FormGroupSet();
            int[][] groups = this.m_formlayout.getColumnGroups();
            for (int gindex = 0; gindex < groups.length; ++gindex) {
                int[] cols = groups[gindex];
                if (cols == null) continue;
                Integer ckey = new Integer(gindex + 1);
                for (int cindex = 0; cindex < cols.length; ++cindex) {
                    gset.assignToGroup(ckey, cols[cindex]);
                }
            }
            this.m_col_groups = gset;
        }
        catch (Exception e) {
            FormsLogger.debug(e);
        }
    }

    public void updateRowGroups() {
        try {
            FormGroupSet gset = new FormGroupSet();
            int[][] groups = this.m_formlayout.getRowGroups();
            for (int gindex = 0; gindex < groups.length; ++gindex) {
                int[] rows = groups[gindex];
                if (rows == null) continue;
                Integer rkey = new Integer(gindex + 1);
                for (int rindex = 0; rindex < rows.length; ++rindex) {
                    gset.assignToGroup(rkey, rows[rindex]);
                }
            }
            this.m_row_groups = gset;
        }
        catch (Exception e) {
            FormsLogger.debug(e);
        }
    }

    private void updateParentModicationStamps(Container c, long nestedModStamp) {
        while (c != null) {
            if (c instanceof GridView) {
                GridView gv = (GridView)c;
                gv.m_nested_mod_stamp = nestedModStamp;
            }
            if (!((c = c.getParent()) instanceof Window) && !(c instanceof JInternalFrame)) continue;
            break;
        }
    }

    private class FormContainer
    extends JPanel {
        private long m_mod_stamp;

        private FormContainer() {
        }

        protected void addImpl(Component comp, Object constraints, int index) {
            super.addImpl(comp, constraints, index);
            this.m_mod_stamp = System.currentTimeMillis();
            GridView.this.updateParentModicationStamps(GridView.this.getParent(), this.m_mod_stamp);
        }

        public void remove(int index) {
            super.remove(index);
            this.m_mod_stamp = System.currentTimeMillis();
            GridView.this.updateParentModicationStamps(GridView.this.getParent(), this.m_mod_stamp);
        }

        public void removeAll() {
            super.removeAll();
            this.m_mod_stamp = System.currentTimeMillis();
            GridView.this.updateParentModicationStamps(GridView.this.getParent(), this.m_mod_stamp);
        }

        long getModificationStamp() {
            return this.m_mod_stamp;
        }
    }

    private class ComponentIterator
    implements Iterator {
        private int m_pos = -1;

        private ComponentIterator() {
        }

        public boolean hasNext() {
            for (int pos = this.m_pos + 1; pos < GridView.this.m_form.getComponentCount(); ++pos) {
                Component obj = GridView.this.m_form.getComponent(pos);
                if (!(obj instanceof GridComponent)) continue;
                this.m_pos = pos - 1;
                return true;
            }
            return false;
        }

        public Object next() {
            ++this.m_pos;
            while (this.m_pos < GridView.this.m_form.getComponentCount()) {
                Component obj = GridView.this.m_form.getComponent(this.m_pos);
                if (!(obj instanceof GridComponent)) continue;
                return obj;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

