/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.BorderProperty;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class CompoundBorderProperty
extends BorderProperty {
    static final long serialVersionUID = -8513525079430361312L;
    public static final int VERSION = 1;
    private LinkedList m_borders = new LinkedList();

    public CompoundBorderProperty() {
    }

    public CompoundBorderProperty(BorderProperty prop) {
        this.addBorder(prop);
    }

    public void addBorder(BorderProperty bp) {
        if (bp != null) {
            this.m_borders.addLast(bp);
        }
    }

    public Border createBorder(Component comp) {
        if (this.m_borders.size() == 0) {
            return null;
        }
        if (this.m_borders.size() == 1) {
            BorderProperty bp = (BorderProperty)this.m_borders.getFirst();
            Border b = bp.createBorder(comp);
            return b;
        }
        Border last_border = null;
        Iterator iter = this.m_borders.iterator();
        while (iter.hasNext()) {
            BorderProperty bp = (BorderProperty)iter.next();
            Border b = bp.createBorder(comp);
            if (last_border == null) {
                last_border = b;
                continue;
            }
            last_border = BorderFactory.createCompoundBorder(last_border, b);
        }
        return last_border;
    }

    public boolean equals(Object object) {
        if (object instanceof CompoundBorderProperty) {
            CompoundBorderProperty bp = (CompoundBorderProperty)object;
            boolean bresult = super.equals(object);
            return bresult && CompoundBorderProperty.isEqual(this.m_borders, bp.m_borders);
        }
        return false;
    }

    public BorderProperty getBorder(int index) throws IndexOutOfBoundsException {
        return (BorderProperty)this.m_borders.get(index);
    }

    public Iterator iterator() {
        return this.m_borders.iterator();
    }

    public int size() {
        return this.m_borders.size();
    }

    public void setValue(Object prop) {
        if (prop instanceof CompoundBorderProperty) {
            CompoundBorderProperty cb = (CompoundBorderProperty)prop;
            this.m_borders.clear();
            this.m_borders.addAll(cb.m_borders);
        }
    }

    public void updateBean(JETABean jbean) {
        if (this.m_borders != null) {
            super.updateBean(jbean);
        }
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_borders = (LinkedList)in.readObject("borders");
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(BorderProperty.class));
        out.writeVersion(1);
        out.writeObject("borders", this.m_borders);
    }

    public String toString() {
        if (this.m_borders.size() == 0) {
            return "NO BORDER";
        }
        if (this.m_borders.size() == 1) {
            BorderProperty bp = (BorderProperty)this.m_borders.getFirst();
            return bp.toString();
        }
        return "COMPOUND";
    }

    public int getSize() {
        return this.m_borders.size();
    }
}

