/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.JETAProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.io.IOException;

public class LineProperty
extends JETAProperty {
    static final long serialVersionUID = -6081805367391562785L;
    public static final int VERSION = 2;
    private ColorProperty m_color_prop = new ColorProperty();
    private int m_thickness = 1;
    private float[] m_dash;
    private Stroke m_stroke;
    public static final String PROPERTY_ID = "lineStyle";

    public LineProperty() {
        super(PROPERTY_ID);
    }

    public Color getColor() {
        return this.m_color_prop.getColor();
    }

    public ColorProperty getColorProperty() {
        return this.m_color_prop;
    }

    public Stroke getStroke(int maxThickness) {
        int thickness = Math.min(maxThickness, this.getThickness());
        if (this.m_dash != null && this.m_dash.length > 1) {
            return new BasicStroke(thickness, 0, 2, 1.0f, this.m_dash, 0.0f);
        }
        return new BasicStroke(thickness, 0, 2);
    }

    public Stroke getStroke() {
        if (this.m_stroke == null) {
            this.m_stroke = this.getStroke(this.getThickness());
        }
        return this.m_stroke;
    }

    public int getThickness() {
        return this.m_thickness;
    }

    public float[] getDash() {
        return this.m_dash;
    }

    public void setConstantColor(Color c) {
        this.m_color_prop.setConstantColor(c);
    }

    public void setColorProperty(ColorProperty cprop) {
        this.m_color_prop.setValue(cprop);
    }

    public void setThickness(int t) {
        this.m_thickness = t;
        this.m_stroke = null;
    }

    public void setDash(float[] dash) {
        this.m_dash = dash;
        this.m_stroke = null;
    }

    public void setValue(Object prop) {
        if (prop instanceof LineProperty) {
            LineProperty lp = (LineProperty)prop;
            this.m_color_prop.setValue(lp.m_color_prop);
            this.m_thickness = lp.m_thickness;
            this.m_dash = lp.m_dash;
        }
    }

    public void print() {
        System.out.println("   line component:  thickness: " + this.getThickness() + "   color: " + this.getColor());
    }

    public void updateBean(JETABean jbean) {
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        if (version == 1) {
            Color color = (Color)in.readObject("color");
            this.m_color_prop = new ColorProperty(color);
        } else {
            this.m_color_prop = (ColorProperty)in.readObject("color");
        }
        this.m_thickness = in.readInt("thickness");
        this.m_dash = (float[])in.readObject("dash");
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(2);
        out.writeObject("color", this.m_color_prop);
        out.writeInt("thickness", this.m_thickness);
        out.writeObject("dash", this.m_dash);
    }
}

