/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.components.ComponentSource;
import com.jeta.forms.gui.components.ContainedFormFactory;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.TabProperty;
import com.jeta.open.i18n.I18N;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.support.EmptyCollection;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class TabbedPaneProperties
extends JETAProperty {
    static final long serialVersionUID = 3096566296606257673L;
    public static final int VERSION = 1;
    private LinkedList m_items;
    public static final String PROPERTY_ID = "tabs";
    static final /* synthetic */ boolean $assertionsDisabled;

    public TabbedPaneProperties() {
        super(PROPERTY_ID);
    }

    public void addTab(TabProperty prop) {
        if (this.m_items == null) {
            this.m_items = new LinkedList();
        }
        this.m_items.add(prop);
    }

    public Collection getTabs() {
        if (this.m_items != null) {
            return this.m_items;
        }
        return EmptyCollection.getInstance();
    }

    public void setValue(Object prop) {
        if (prop instanceof TabbedPaneProperties) {
            TabbedPaneProperties tpp = (TabbedPaneProperties)prop;
            this.m_items = new LinkedList();
            if (tpp.m_items != null) {
                Iterator iter = tpp.m_items.iterator();
                while (iter.hasNext()) {
                    TabProperty tp = (TabProperty)iter.next();
                    TabProperty new_tp = new TabProperty();
                    new_tp.setValue(tp);
                    this.m_items.add(new_tp);
                }
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jbean) {
        Component comp = null;
        if (jbean != null) {
            comp = jbean.getDelegate();
        }
        if (comp instanceof JTabbedPane) {
            JTabbedPane tpane = (JTabbedPane)comp;
            int selected_tab = tpane.getSelectedIndex();
            tpane.removeAll();
            if (this.m_items != null) {
                Iterator iter = this.m_items.iterator();
                while (iter.hasNext()) {
                    TabProperty tp = (TabProperty)iter.next();
                    if (FormUtils.isDesignMode()) {
                        try {
                            ContainedFormFactory factory = (ContainedFormFactory)JETARegistry.lookup("contained.form.factory");
                            ComponentSource compsrc = (ComponentSource)JETARegistry.lookup("component.source");
                            FormUtils.safeAssert(compsrc != null);
                            FormUtils.safeAssert(factory != null);
                            FormComponent topparent = factory.createTopParent(tpane, compsrc, tp.getForm());
                            tpane.addTab(tp.getTitle(), tp.icon(), topparent);
                        }
                        catch (FormException e) {
                            FormsLogger.severe(e);
                        }
                        continue;
                    }
                    try {
                        FormComponent fc = FormComponent.create();
                        fc.setState(tp.getFormMemento());
                        fc.setTopLevelForm(true);
                        tpane.addTab(tp.getTitle(), tp.icon(), fc);
                    }
                    catch (FormException e) {
                        FormsLogger.severe(e);
                    }
                }
                if (selected_tab >= 0 && selected_tab < tpane.getTabCount()) {
                    tpane.setSelectedIndex(selected_tab);
                }
            }
            if (FormUtils.isDesignMode() && tpane.getTabCount() == 0) {
                tpane.addTab(I18N.getLocalizedMessage("Tab Pane"), new JLabel(""));
            }
        }
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_items = (LinkedList)in.readObject("items");
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(1);
        out.writeObject("items", this.m_items);
    }

    static {
        $assertionsDisabled = !TabbedPaneProperties.class.desiredAssertionStatus();
    }
}

