/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties.effects;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.gui.effects.RadialGradientPainter;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.effects.PaintSupport;
import com.jeta.open.i18n.I18N;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;

public class RadialGradientProperty
extends JETAProperty
implements PaintSupport {
    static final long serialVersionUID = 1554397018383485167L;
    public static final int VERSION = 1;
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int CENTER = 3;
    public static final int BOTTOM_LEFT = 4;
    public static final int BOTTOM_CENTER = 5;
    public static final int BOTTOM_RIGHT = 6;
    public static final int LEFT_CENTER = 7;
    public static final int RIGHT_CENTER = 8;
    private ColorProperty m_start_color = new ColorProperty(Color.black);
    private ColorProperty m_end_color = new ColorProperty(Color.white);
    private int m_position = 0;
    private int m_magnitude = 100;
    private transient RadialGradientPainter m_painter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RadialGradientProperty() {
    }

    public RadialGradientProperty(ColorProperty startColor, ColorProperty endColor, int position, int magnitude) {
        this.m_start_color = startColor;
        this.m_end_color = endColor;
        this.m_position = position;
        this.m_magnitude = magnitude;
    }

    public Painter createPainter() {
        if (this.m_painter == null) {
            this.m_painter = new RadialGradientPainter(this);
        }
        return this.m_painter;
    }

    public ColorProperty getStartColor() {
        return this.m_start_color;
    }

    public int getPosition() {
        return this.m_position;
    }

    public ColorProperty getEndColor() {
        return this.m_end_color;
    }

    public int getMagnitude() {
        return this.m_magnitude;
    }

    public void setMagnitude(int mag) {
        this.m_magnitude = mag;
        this.m_painter = null;
    }

    public void setPosition(int position) {
        this.m_position = position;
        this.m_painter = null;
    }

    public void setStartColor(ColorProperty c) {
        this.m_start_color = c;
        this.m_painter = null;
    }

    public void setEndColor(ColorProperty c) {
        this.m_end_color = c;
        this.m_painter = null;
    }

    public void setValue(Object prop) {
        if (prop instanceof RadialGradientProperty) {
            RadialGradientProperty gp = (RadialGradientProperty)prop;
            if (this.m_start_color == null) {
                this.m_start_color = new ColorProperty();
            }
            if (this.m_end_color == null) {
                this.m_end_color = new ColorProperty();
            }
            this.m_start_color.setValue(gp.m_start_color);
            this.m_end_color.setValue(gp.m_end_color);
            this.m_position = gp.m_position;
            this.m_magnitude = gp.m_magnitude;
            this.m_painter = null;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jbean) {
        RadialGradientPainter painter = (RadialGradientPainter)this.createPainter();
        if (jbean != null) {
            Component comp = jbean.getDelegate();
            if (comp instanceof Paintable) {
                ((Paintable)((Object)comp)).setBackgroundPainter(painter);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    public String toString() {
        return I18N.getLocalizedMessage("Radial Gradient");
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_start_color = (ColorProperty)in.readObject("startcolor");
        this.m_end_color = (ColorProperty)in.readObject("endcolor");
        this.m_position = in.readInt("position");
        this.m_magnitude = in.readInt("magnitude");
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(1);
        out.writeObject("startcolor", this.m_start_color);
        out.writeObject("endcolor", this.m_end_color);
        out.writeInt("position", this.m_position);
        out.writeInt("magnitude", this.m_magnitude);
    }

    static {
        $assertionsDisabled = !RadialGradientProperty.class.desiredAssertionStatus();
    }
}

