/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.gui.framework;

import com.jeta.open.gui.framework.JETAComponentCleanser;
import com.jeta.open.gui.framework.JETAController;
import com.jeta.open.gui.framework.JETADialogListener;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.gui.utils.JETAToolbox;
import com.jeta.open.i18n.I18N;
import com.jeta.open.rules.JETARule;
import com.jeta.open.rules.RuleResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class JETADialog
extends JDialog {
    private JPanel m_contentpane;
    private CommandListener m_cmdListener = new CommandListener(this);
    private boolean m_bOk = false;
    private JPanel m_btnPanel;
    private JButton m_okbtn;
    private JButton m_closebtn;
    private JButton m_helpbtn;
    private JETAController m_controller;
    private LinkedList m_validators;
    private JComponent m_initialFocusComponent;
    private JComponent m_primaryPanel;
    private LinkedList m_listeners;
    private Timer m_timer;
    public static final String ID_BUTTON_PANEL = "button.panel";
    public static final String ID_OK = "JETADialog.ok";
    public static final String ID_CANCEL = "JETADialog.cancel";
    static final /* synthetic */ boolean $assertionsDisabled;

    public JETADialog(Dialog owner, boolean bModal) {
        super(owner, bModal);
        this._initialize();
    }

    public JETADialog(Frame owner, boolean bModal) {
        super(owner, bModal);
        this._initialize();
    }

    public boolean actionPerformed(String commandId, ActionEvent evt) {
        boolean bresult = false;
        JETAController controller = this.getController();
        if (controller != null) {
            bresult = controller.actionPerformed(commandId, evt);
        }
        if (!bresult) {
            String actionCommand = evt.getActionCommand();
            if (actionCommand.equals(ID_OK)) {
                this.cmdOk();
            } else if (actionCommand.equals(ID_CANCEL)) {
                this.cmdCancel();
            }
        }
        return true;
    }

    public void addController(JETAController controller) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void addDialogListener(JETADialogListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList();
        }
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        this.m_listeners.add(listener);
    }

    public void addValidator(JETARule validator) {
        this.addValidator(null, validator);
    }

    public void addValidator(Object parameter, JETARule validator) {
        if (validator == null) {
            return;
        }
        if (this.m_validators == null) {
            this.m_validators = new LinkedList();
        }
        if (parameter == null) {
            this.m_validators.add(new ValidatorRule(validator, new Object[0]));
        } else if (parameter instanceof Object[]) {
            this.m_validators.add(new ValidatorRule(validator, (Object[])parameter));
        } else {
            Object[] params = new Object[]{parameter};
            this.m_validators.add(new ValidatorRule(validator, params));
        }
    }

    public void cmdCancel() {
        this.setOk(false);
        this.dispose();
    }

    public void cmdOk() {
        if (this.validateValidators() && this.validateListeners()) {
            this.setOk(true);
            this.dispose();
        }
    }

    private JPanel createButtonPanel() {
        JETAPanel btnpanel = new JETAPanel(new FlowLayout(2));
        this.m_okbtn = new JButton(I18N.getLocalizedMessage("Ok"));
        this.m_closebtn = new JButton(I18N.getLocalizedMessage("Cancel"));
        this.m_helpbtn = new JButton(I18N.getLocalizedMessage("Help"));
        this.m_helpbtn.setVisible(false);
        btnpanel.add(this.m_helpbtn);
        btnpanel.add(this.m_okbtn);
        btnpanel.add(this.m_closebtn);
        this.m_btnPanel = btnpanel;
        this.m_btnPanel.setName(ID_BUTTON_PANEL);
        this.m_okbtn.setActionCommand(ID_OK);
        this.m_okbtn.setName(ID_OK);
        this.m_okbtn.addActionListener(this.m_cmdListener);
        this.m_closebtn.setActionCommand(ID_CANCEL);
        this.m_closebtn.setName(ID_CANCEL);
        this.m_closebtn.addActionListener(this.m_cmdListener);
        return this.m_btnPanel;
    }

    public void dispose() {
        super.dispose();
        JETAComponentCleanser cleanser = new JETAComponentCleanser();
        cleanser.cleanse(this);
        this.m_timer.stop();
        ActionListener[] als = (ActionListener[])this.m_timer.getListeners(ActionListener.class);
        if (als != null) {
            for (int index = 0; index < als.length; ++index) {
                this.m_timer.removeActionListener(als[index]);
            }
        }
        this.m_cmdListener = null;
        this.m_controller = null;
        if (this.m_validators != null) {
            this.m_validators.clear();
        }
        this.m_initialFocusComponent = null;
        if (this.m_listeners != null) {
            this.m_listeners.clear();
        }
        if (this.m_contentpane != null) {
            this.m_contentpane.removeAll();
            this.m_contentpane = null;
        }
        this.m_primaryPanel = null;
    }

    public JPanel getButtonPanel() {
        return this.m_btnPanel;
    }

    public JButton getCloseButton() {
        return this.m_closebtn;
    }

    public JETAController getController() {
        return this.m_controller;
    }

    public Container getDialogContentPanel() {
        return this.m_contentpane;
    }

    public JButton getHelpButton() {
        return this.m_helpbtn;
    }

    public JButton getOkButton() {
        return this.m_okbtn;
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getDialogContentPanel().getPreferredSize());
    }

    protected Dimension getPreferredSize(Dimension contentDims) {
        Dimension dbtn = this.m_btnPanel.getPreferredSize();
        Dimension d = new Dimension(contentDims);
        d.height += dbtn.height;
        d.height += JETAToolbox.getTitleBarHeight();
        d.height += JETAToolbox.getFrameBorderThickness();
        d.width += 2 * JETAToolbox.getFrameBorderThickness();
        if (JETAToolbox.isOSX()) {
            d.width -= 6;
        }
        return d;
    }

    public Component getPrimaryPanel() {
        return this.m_primaryPanel;
    }

    protected void _initialize() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.m_contentpane = new JPanel(new BorderLayout());
        container.add((Component)this.m_contentpane, "Center");
        container.add((Component)this.createButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                JETADialog.this.cmdCancel();
            }

            public void windowOpened(WindowEvent we) {
                if (JETADialog.this.m_initialFocusComponent != null) {
                    JETADialog.this.m_initialFocusComponent.requestFocus();
                }
            }
        });
        ActionListener uiupdater = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JETADialog.this.updateComponents(evt);
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().getInputMap().put(ks, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                JETADialog.this.cmdCancel();
            }
        });
        ks = KeyStroke.getKeyStroke(10, 0, true);
        this.getRootPane().getInputMap().put(ks, "EnterAction");
        this.getRootPane().getActionMap().put("EnterAction", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                JETADialog.this.cmdOk();
            }
        });
        int delay = 500;
        this.m_timer = new Timer(delay, uiupdater);
        this.m_timer.start();
    }

    public boolean isOk() {
        return this.m_bOk;
    }

    public void removeAllControllers() {
    }

    public void setButtonPanelVisible(boolean bvis) {
        if (!$assertionsDisabled && bvis) {
            throw new AssertionError();
        }
        Container container = this.getContentPane();
        container.remove(this.m_btnPanel);
    }

    public void setCancelEnabled(boolean bCancel) {
        if (!bCancel) {
            this.m_closebtn.setEnabled(false);
        }
    }

    public void setCloseText(String txt) {
        this.m_closebtn.setText(txt);
    }

    public void setFont(Font f) {
        this.m_okbtn.setFont(f);
        this.m_closebtn.setFont(f);
    }

    public void setPrimaryPanel(JComponent primaryPanel) {
        if (this.m_primaryPanel != null) {
            this.m_contentpane.remove(this.m_primaryPanel);
        }
        this.m_primaryPanel = primaryPanel;
        this.m_contentpane.add((Component)primaryPanel, "Center");
    }

    public void setController(JETAController controller) {
        this.m_controller = controller;
        if (controller instanceof JETARule) {
            this.addValidator((JETARule)((Object)controller));
        }
    }

    public void setInitialFocusComponent(JComponent comp) {
        if (comp == null) {
            return;
        }
        this.m_initialFocusComponent = comp;
        comp.requestFocus();
    }

    protected void setOk(boolean bok) {
        this.m_bOk = bok;
    }

    public void setOkText(String txt) {
        this.m_okbtn.setText(txt);
    }

    public void setTitle(String title) {
        super.setTitle(title);
    }

    public void showCenter() {
        JETAToolbox.centerWindow(this);
        this.show();
    }

    public void showOkButton(boolean bvis) {
        this.m_okbtn.setVisible(bvis);
    }

    public void updateComponents(EventObject evt) {
        JETAController controller = this.getController();
        if (controller == null && this.m_primaryPanel != null && this.m_primaryPanel instanceof JETAPanel) {
            controller = ((JETAPanel)this.m_primaryPanel).getController();
        }
        if (controller != null) {
            controller.updateComponents(evt);
        }
    }

    protected boolean validateListeners() {
        if (this.m_listeners != null) {
            Iterator iter = this.m_listeners.iterator();
            while (iter.hasNext()) {
                JETADialogListener listener = (JETADialogListener)iter.next();
                if (listener.cmdOk()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validateValidators() {
        boolean bresult = true;
        if (this.m_validators != null) {
            Iterator iter = this.m_validators.iterator();
            while (iter.hasNext()) {
                JETARule rule;
                RuleResult result;
                ValidatorRule validator = (ValidatorRule)iter.next();
                if (validator == null || (result = (rule = validator.getRule()).check(validator.getParameters())) == null) continue;
                if (result.getCode() == -1) {
                    String title = I18N.getLocalizedMessage("Error");
                    JOptionPane.showMessageDialog(this, result.getMessage(), title, 0);
                    bresult = false;
                    break;
                }
                if (result.getCode() != -2) continue;
                bresult = false;
                break;
            }
        }
        return bresult;
    }

    static {
        $assertionsDisabled = !JETADialog.class.desiredAssertionStatus();
    }

    static class ValidatorRule {
        private JETARule m_rule;
        private Object[] m_parameters;

        public ValidatorRule(JETARule rule, Object[] params) {
            this.m_rule = rule;
            this.m_parameters = params;
        }

        public Object[] getParameters() {
            return this.m_parameters;
        }

        public JETARule getRule() {
            return this.m_rule;
        }
    }

    static class CommandListener
    implements ActionListener {
        private WeakReference m_dlgref;

        public CommandListener(JETADialog dlg) {
            this.m_dlgref = new WeakReference<JETADialog>(dlg);
        }

        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            JETADialog dlg = (JETADialog)this.m_dlgref.get();
            if (dlg != null) {
                dlg.actionPerformed(actionCommand, e);
            }
        }
    }
}

