/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.raster.impl.store.rmf.IRmfBlock;
import org.gvsig.raster.impl.store.rmf.RmfBlocksManager;
import org.gvsig.raster.multifile.io.MultiFileFormat;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class MultiFileFormatSerializer
extends ClassSerializer {
    public static final String MAIN_TAG = "MultiFileFormat";
    public static final String URIS = "URIs";
    public static final String URI = "URI";
    public static final String NAME = "Name";
    private MultiFileFormat multiFileFormat = null;

    public MultiFileFormatSerializer(MultiFileFormat timeSeriesFormat) {
        this.multiFileFormat = timeSeriesFormat;
    }

    public void parseURIs(KXmlParser parser, String xml, String parseableTag) throws XmlPullParserException, IOException, NumberFormatException, ParsingException, ParseException {
        boolean end = false;
        boolean init = false;
        boolean readFile = false;
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 1: {
                    return;
                }
                case 2: {
                    if (parser.getName().compareTo(parseableTag) == 0) {
                        init = true;
                    }
                    if (!init || parser.getName().compareTo(URI) != 0) break;
                    readFile = true;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo(parseableTag) != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (!readFile) break;
                    String file = parser.getText();
                    this.multiFileFormat.addFile(new File(file));
                    readFile = false;
                }
            }
            if (end) continue;
            tag = parser.next();
        }
    }

    public void read(String xml) throws ParsingException {
        block16: {
            if (this.multiFileFormat == null) {
                this.multiFileFormat = new MultiFileFormat();
            } else {
                this.multiFileFormat.clean();
            }
            boolean init = false;
            boolean end = false;
            KXmlParser parser = new KXmlParser();
            StringReader reader = new StringReader(xml);
            try {
                parser.setInput((Reader)reader);
            }
            catch (XmlPullParserException e) {
                throw new ParsingException(xml);
            }
            try {
                int tag = parser.nextTag();
                if (parser.getEventType() == 1) break block16;
                parser.require(2, null, MAIN_TAG);
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo(MAIN_TAG) != 0) break;
                            init = true;
                            break;
                        }
                        case 3: {
                            if (parser.getName().compareTo(MAIN_TAG) != 0) break;
                            end = true;
                            break;
                        }
                        case 4: {
                            if (!init) break;
                            String name = this.parserString(parser, NAME, null);
                            this.multiFileFormat.setName(name);
                            this.parseURIs(parser, xml, URIS);
                            init = false;
                        }
                    }
                    if (!end) {
                        tag = parser.next();
                        continue;
                    }
                    break;
                }
            }
            catch (XmlPullParserException e) {
                throw new ParsingException(xml);
            }
            catch (IOException e) {
                throw new ParsingException(xml);
            }
            catch (NumberFormatException e) {
                throw new ParsingException(xml);
            }
            catch (ParseException e) {
                throw new ParsingException(xml);
            }
        }
    }

    public static void write(MultiFileFormat multiFileFormat, String fileName) throws IOException {
        File file = new File(fileName);
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        MultiFileFormatSerializer serializer = new MultiFileFormatSerializer(multiFileFormat);
        writer.write(serializer.write());
        writer.close();
    }

    public static MultiFileFormat read(MultiFileFormat timeSeriesFormat, String file) throws IOException, ParsingException {
        RmfBlocksManager manager = new RmfBlocksManager(file);
        MultiFileFormatSerializer serializer = new MultiFileFormatSerializer(timeSeriesFormat);
        manager.addClient((IRmfBlock)serializer);
        manager.read(null);
        return timeSeriesFormat;
    }

    public String write() {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>\n");
        b.append("<MultiFileFormat>\n");
        this.putProperty(b, NAME, this.multiFileFormat.getName(), 2);
        b.append("\t\t<URIs>\n");
        for (int i = 0; i < this.multiFileFormat.getNumberOfFiles(); ++i) {
            this.putProperty(b, URI, this.multiFileFormat.getPathToFile(i), 3);
        }
        b.append("\t\t</URIs>\n");
        b.append("</MultiFileFormat>\n");
        return b.toString();
    }

    public Object getResult() {
        return this.multiFileFormat;
    }

    public String getMainTag() {
        return MAIN_TAG;
    }
}

