/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.io;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.DatasetBand;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.tile.FileTileServer;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.impl.store.properties.MultiProviderHistogramComputer;
import org.gvsig.raster.impl.store.properties.MultiProviderStatistics;
import org.gvsig.raster.multifile.io.MultiFileDataParameters;
import org.gvsig.raster.multifile.io.MultiFileDataParametersImpl;
import org.gvsig.raster.multifile.io.MultiFileFormat;
import org.gvsig.raster.multifile.io.MultiFileFormatSerializer;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFileProvider
extends AbstractRasterProvider {
    public static String NAME = "Multifile Raster";
    public static String DESCRIPTION = "Multifile Raster Support";
    public final String METADATA_DEFINITION_NAME = NAME;
    private Extent viewRequest = null;
    private TileServer tileServer = null;
    private boolean open = false;
    private DataStoreTransparency fileTransparency = null;
    private static final Logger logger = LoggerFactory.getLogger(MultiFileProvider.class);
    protected static String[] formatList = null;

    public static void register() {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        MultiFileProvider.registerFormats();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, MultiFileProvider.class, MultiFileDataParametersImpl.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    private static void registerFormats() {
        formatList = new String[]{"mff"};
        for (int i = 0; i < formatList.length; ++i) {
            RasterLocator.getManager().getProviderServices().addFormat(formatList[i], MultiFileProvider.class);
        }
    }

    public MultiFileProvider() {
    }

    public MultiFileProvider(String params) throws NotSupportedExtensionException, OpenException {
        super(params);
        logger.info("Deprecated use of MultiFileProvider constructor");
        if (params instanceof String) {
            URI uriObj;
            MultiFileDataParametersImpl p = new MultiFileDataParametersImpl();
            try {
                uriObj = new URI(params);
            }
            catch (URISyntaxException e) {
                throw new OpenException("Can't create uri from " + params, (Throwable)e);
            }
            p.setURI(uriObj);
            super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
            this.init(p, null);
        }
    }

    public MultiFileProvider(URI uri) throws NotSupportedExtensionException, OpenException {
        super(uri);
        MultiFileDataParametersImpl p = new MultiFileDataParametersImpl();
        p.setURI(uri);
        super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init(p, null);
    }

    public MultiFileProvider(MultiFileDataParametersImpl params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException, OpenException {
        super((AbstractRasterDataParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init(params, storeServices);
    }

    public void init(MultiFileDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException, OpenException {
        this.openFromMff();
        this.uri = this.getParameters().getURI();
        this.setParam(storeServices, (DataStoreParameters)params);
        try {
            this.setFirstProviderToNotTiled();
        }
        catch (InvalidSourceException e1) {
            throw new OpenException(e1.getMessage(), (Throwable)e1);
        }
        super.init();
        try {
            this.loadFromRmf(this.getRmfBlocksManager());
        }
        catch (ParsingException e) {
            logger.debug("Problems reading from RMF", (Throwable)e);
        }
        this.open = true;
    }

    private void openFromMff() throws OpenException {
        File fileFromUriParam;
        URI uriParam = this.getParameters().getURI();
        if (uriParam != null && (fileFromUriParam = new File(uriParam)).exists()) {
            boolean loadedProviders = true;
            if (this.getParameters().hasProviders()) {
                for (int i = 0; i < this.getParameters().getProviders().size(); ++i) {
                    if (this.getParameters().getProviders().get(i).isOpen()) continue;
                    loadedProviders = false;
                }
            } else {
                loadedProviders = false;
            }
            if (loadedProviders) {
                return;
            }
            try {
                if (this.getParameters().hasProviders()) {
                    this.getParameters().removeAllProviders();
                }
                MultiFileFormat multiFileFormat = new MultiFileFormat();
                multiFileFormat = MultiFileFormatSerializer.read(multiFileFormat, fileFromUriParam.getAbsolutePath());
                for (int i = 0; i < multiFileFormat.getNumberOfFiles(); ++i) {
                    try {
                        File file = new File(multiFileFormat.getPathToFile(i));
                        if (!file.exists()) continue;
                        RasterProvider prov = this.loadProvider(multiFileFormat.getPathToFile(i), this.storeServices);
                        this.getParameters().addProvider((DataStoreProvider)prov);
                        continue;
                    }
                    catch (ProviderNotRegisteredException e) {
                        throw new OpenException("A provider can't be loaded", (Throwable)e);
                    }
                    catch (InitializeException e) {
                        throw new OpenException("A provider can't be initialized", (Throwable)e);
                    }
                }
            }
            catch (IOException e1) {
                throw new OpenException("File .mff can't be read", (Throwable)e1);
            }
            catch (ParsingException e1) {
                throw new OpenException("File .mff can't be parsed", (Throwable)e1);
            }
        }
    }

    private RasterProvider loadProvider(String file, DataStoreProviderServices storeServices) throws ProviderNotRegisteredException, InitializeException {
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        DataStoreProvider prov = null;
        if (file != null) {
            FilesystemServerExplorerParameters paramsExplorer = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
            FilesystemServerExplorer serverExplorer = null;
            try {
                paramsExplorer.setRoot(File.separator);
                serverExplorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)paramsExplorer);
            }
            catch (ValidateDataParametersException e) {
                throw new InitializeException((Throwable)e);
            }
            File f = new File(file);
            List provName = serverExplorer.getProviderNameList(f);
            if (provName.size() > 0) {
                for (int i = 0; i < provName.size(); ++i) {
                    if (((String)provName.get(i)).compareTo("Tile Store") == 0) continue;
                    DataStoreParameters newparams = dataManager.createStoreParameters((String)provName.get(i));
                    ((FilesystemStoreParameters)newparams).setFile(f);
                    prov = dataManager.createProvider(storeServices, newparams);
                }
            }
        }
        if (prov != null && prov instanceof RasterProvider) {
            if (((RasterProvider)prov).isRotated()) {
                throw new InitializeException("Rotation not supported tiling files", new Throwable());
            }
            return (RasterProvider)prov;
        }
        return null;
    }

    private boolean checkNewProvider(RasterProvider p) {
        Rectangle2D extentOrigin = this.getExtent().toRectangle2D();
        Extent extentNewFile = p.getExtent();
        double widthNewFile = extentNewFile.getMax().getX() - extentNewFile.getMin().getX();
        double heightNewFile = extentNewFile.getMax().getY() - extentNewFile.getMin().getY();
        if (widthNewFile - extentOrigin.getWidth() > 1.0 || widthNewFile - extentOrigin.getWidth() < -1.0 || heightNewFile - extentOrigin.getHeight() > 1.0 || heightNewFile - extentOrigin.getHeight() < -1.0) {
            return false;
        }
        return extentNewFile.getMax().getX() - extentNewFile.getMin().getX() == extentOrigin.getWidth() && extentNewFile.getMax().getY() - extentNewFile.getMin().getY() == extentOrigin.getHeight();
    }

    public MultiFileDataParameters getParameters() {
        try {
            return (MultiFileDataParameters)this.parameters;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public RasterProvider load() {
        return this;
    }

    public int getBandCount() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        int bandCount = 0;
        for (int i = 0; i < providerList.size(); ++i) {
            bandCount += providerList.get(i).getBandCount();
        }
        return bandCount;
    }

    public int[] getDataType() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        int[] datatypes = new int[this.getBandCount()];
        int k = 0;
        for (int i = 0; i < providerList.size(); ++i) {
            int[] dtByProv = providerList.get(i).getDataType();
            for (int j = 0; j < dtByProv.length; ++j) {
                datatypes[k] = dtByProv[j];
                ++k;
            }
        }
        return datatypes;
    }

    public URI[] getURIByProvider() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        URI[] uris = new URI[providerList.size()];
        for (int i = 0; i < uris.length; ++i) {
            uris[i] = providerList.get(i).getURIOfFirstProvider();
        }
        return uris;
    }

    public int getBandPositionByProvider(int band) {
        return this.getSubBandByBandNumber(band)[1];
    }

    public URI getURIOfFirstProvider() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        return providerList.get(0).getURIOfFirstProvider();
    }

    public Extent getExtent() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        if (providerList != null && providerList.size() > 0) {
            return providerList.get(0).getExtent();
        }
        return null;
    }

    public AffineTransform getAffineTransform() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        return providerList.get(0).getAffineTransform();
    }

    public void setAffineTransform(AffineTransform t) {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        for (int i = 0; i < providerList.size(); ++i) {
            providerList.get(i).setAffineTransform(t);
        }
    }

    public int getInternalProviderCount() {
        return this.getParameters().getProviders().size();
    }

    public RasterProvider getInternalProvider(int i) {
        return this.getParameters().getProviders().get(i);
    }

    public int[] getBandCountByProvider() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        int[] bc = new int[providerList.size()];
        for (int i = 0; i < bc.length; ++i) {
            bc[i] = providerList.get(i).getBandCount();
        }
        return bc;
    }

    public long[] getFileSizeByProvider() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        long[] fs = new long[providerList.size()];
        for (int i = 0; i < fs.length; ++i) {
            fs[i] = ((AbstractRasterProvider)providerList.get(i)).getFileSize();
        }
        return fs;
    }

    public Point2D rasterToWorld(Point2D pt) {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        return providerList.get(0).rasterToWorld(pt);
    }

    public Point2D worldToRaster(Point2D pt) {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        return providerList.get(0).worldToRaster(pt);
    }

    public boolean isInside(Point2D p) {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        return providerList.get(0).isInside(p);
    }

    public double getCellSize() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        return providerList.get(0).getCellSize();
    }

    public Statistics getStatistics() {
        if (this.stats == null || this.stats instanceof MultiProviderStatistics && ((MultiProviderStatistics)this.stats).getNumberOfProviders() != this.getParameters().getProviders().size()) {
            List<RasterProvider> providerList = this.getParameters().getProviders();
            this.stats = new MultiProviderStatistics(providerList, (RasterProvider)this);
        }
        return this.stats;
    }

    public HistogramComputer getHistogramComputer() {
        if (this.histogram == null || this.histogram instanceof MultiProviderHistogramComputer && ((MultiProviderHistogramComputer)this.histogram).getNumberOfProviders() != this.getParameters().getProviders().size()) {
            this.histogram = new MultiProviderHistogramComputer((RasterProvider)this);
        }
        return this.histogram;
    }

    public ColorTable getColorTable() {
        return null;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
    }

    public URI translateURI(URI uri) {
        return uri;
    }

    public void setView(Extent e) {
        this.viewRequest = new ExtentImpl(e);
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        if (providerList != null && providerList.size() > 0) {
            return providerList.get(0).getWidth();
        }
        return 0.0;
    }

    public double getHeight() {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        if (providerList != null && providerList.size() > 0) {
            return providerList.get(0).getHeight();
        }
        return 0.0;
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        return null;
    }

    private int[] getSubBandByBandNumber(int band) {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        int[] res = new int[2];
        int acum = 0;
        for (int i = 0; i < providerList.size(); ++i) {
            if ((acum += providerList.get(i).getBandCount()) <= band) continue;
            res[0] = i;
            int aux = acum - providerList.get(i).getBandCount();
            res[1] = band - aux;
            return res;
        }
        return res;
    }

    public void loadBuffer(SpiRasterQuery q) throws ProcessInterruptedException, RasterDriverException {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        for (int i = 0; i < providerList.size(); ++i) {
            SpiRasterQuery query = (SpiRasterQuery)q.clone();
            BandList bandListByFile = this.createBandListByProvider(q.getBandList(), providerList.get(i));
            query.setBandList(bandListByFile);
            providerList.get(i).getDataSet(q);
        }
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        int[] sub = this.getSubBandByBandNumber(band);
        RasterProvider prov = this.getParameters().getProviders().get(sub[0]);
        return prov.getData(x, y, sub[1]);
    }

    private BandList createBandListByProvider(BandList globalBandList, RasterProvider provider) {
        if (!provider.isTiled()) {
            BandListImpl bandListByFile = new BandListImpl();
            String pathUriProvider = new File(provider.getURI()).getAbsolutePath();
            for (int i = 0; i < provider.getBandCount(); ++i) {
                try {
                    bandListByFile.addBand((DatasetBand)new DatasetBandImpl(pathUriProvider, i, provider.getDataType()[0], provider.getBandCount()));
                    continue;
                }
                catch (BandNotFoundInListException bandNotFoundInListException) {
                    // empty catch block
                }
            }
            boolean areThereBandsToDraw = false;
            for (int i = 0; i < provider.getBandCount(); ++i) {
                int[] bandsToDrawByProviderBand = globalBandList.getBufferBandToDraw(pathUriProvider, i);
                if (bandsToDrawByProviderBand == null) continue;
                areThereBandsToDraw = true;
                for (int j = 0; j < bandsToDrawByProviderBand.length; ++j) {
                    bandListByFile.getBand(i).addPositionToDrawInBuffer(bandsToDrawByProviderBand[j]);
                }
            }
            if (areThereBandsToDraw) {
                return bandListByFile;
            }
        }
        return null;
    }

    public int getBlockSize() {
        return 0;
    }

    public ColorInterpretation getColorInterpretation() {
        if (super.getColorInterpretation() == null) {
            String[] cis = new String[this.getBandCount()];
            for (int i = 0; i < cis.length; ++i) {
                cis[i] = i == 0 ? "Gray" : "Undefined";
            }
            this.setColorInterpretation((ColorInterpretation)new DataStoreColorInterpretation(cis));
        }
        return super.getColorInterpretation();
    }

    public DataStoreTransparency getTransparency() {
        if (this.fileTransparency == null) {
            this.fileTransparency = new DataStoreTransparency(this.getColorInterpretation());
        }
        return this.fileTransparency;
    }

    public boolean isSupersampling() {
        return false;
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public boolean isMultiFile() {
        return true;
    }

    public boolean isOverviewsSupported() {
        return true;
    }

    public boolean isReproyectable() {
        return true;
    }

    public String getProviderName() {
        return NAME;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof MultiFileProvider) {
            // empty if block
        }
    }

    public boolean isTimeSupported() {
        return true;
    }

    public URI getURIByBand(int band) {
        int[] sub = this.getSubBandByBandNumber(band);
        RasterProvider prov = this.getParameters().getProviders().get(sub[0]);
        return prov.getURIOfFirstProvider();
    }

    public void addFile(String file) throws InvalidSourceException {
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        this.setFirstProviderToNotTiled();
        ArrayList storeParametersList = provServ.createParametersList(file);
        for (int j = 0; j < storeParametersList.size(); ++j) {
            try {
                RasterProvider newFileProv = (RasterProvider)dataManager.createProvider(this.storeServices, (DataStoreParameters)storeParametersList.get(j));
                if (newFileProv.isTiled() || !this.checkNewProvider(newFileProv)) continue;
                this.getParameters().addProvider((DataStoreProvider)newFileProv);
                continue;
            }
            catch (InitializeException e) {
                throw new InvalidSourceException("", (Throwable)e);
            }
            catch (ProviderNotRegisteredException e) {
                throw new InvalidSourceException("", (Throwable)e);
            }
        }
    }

    private void setFirstProviderToNotTiled() throws InvalidSourceException {
        List<RasterProvider> providerList = this.getParameters().getProviders();
        if (providerList == null || providerList.size() <= 0 || !providerList.get(0).isTiled()) {
            return;
        }
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        RasterDataParameters firstDataParameters = providerList.get(0).getDataParameters();
        URI uri = firstDataParameters.getURI();
        ArrayList storeParametersList = provServ.createParametersList(new File(uri).getAbsolutePath());
        for (int j = 0; j < storeParametersList.size(); ++j) {
            try {
                RasterProvider newFileProv = (RasterProvider)dataManager.createProvider(this.storeServices, (DataStoreParameters)storeParametersList.get(j));
                if (newFileProv.isTiled() || !this.checkNewProvider(newFileProv)) continue;
                this.getParameters().setFirstProvider((DataStoreProvider)newFileProv);
                continue;
            }
            catch (InitializeException e) {
                throw new InvalidSourceException("Error replacing the first provider", (Throwable)e);
            }
            catch (ProviderNotRegisteredException e) {
                throw new InvalidSourceException("Error replacing the first provider", (Throwable)e);
            }
        }
    }

    public void removeFile(File file) {
        this.getParameters().removeProvider(file.toURI());
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this);
            this.tileServer = new FileTileServer((RasterDataStore)store);
        }
        return this.tileServer;
    }

    public void addFile(File file) throws InvalidSourceException {
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        this.setFirstProviderToNotTiled();
        ArrayList storeParametersList = provServ.createParametersList(file);
        for (int j = 0; j < storeParametersList.size(); ++j) {
            try {
                RasterProvider newFileProv = (RasterProvider)dataManager.createProvider(this.storeServices, (DataStoreParameters)storeParametersList.get(j));
                if (newFileProv.isTiled() || !this.checkNewProvider(newFileProv)) continue;
                this.getParameters().addProvider((DataStoreProvider)newFileProv);
                continue;
            }
            catch (InitializeException e) {
                throw new InvalidSourceException("", (Throwable)e);
            }
            catch (ProviderNotRegisteredException e) {
                throw new InvalidSourceException("", (Throwable)e);
            }
        }
    }
}

