/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.fmap.dal.store.dwg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cresques.cts.IProjection;
import org.gvsig.dwg.fmap.dal.store.dwg.DWGOpenStoreParameters;
import org.gvsig.dwg.fmap.dal.store.dwg.LegendBuilder;
import org.gvsig.dwg.fmap.dal.store.dwg.UnsupportedDWGVersionException;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgVersionNotSupportedException;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.objects.DwgMText;
import org.gvsig.dwg.lib.objects.DwgText;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.CreateGeometryException;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.memory.AbstractMemoryStoreProvider;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.exception.NotYetImplemented;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWGStoreProvider
extends AbstractMemoryStoreProvider
implements ResourceConsumer {
    private static final Logger logger = LoggerFactory.getLogger(DWGStoreProvider.class);
    public static final String NAME = "DWG";
    public static final String DESCRIPTION = "DWG file";
    public static final String METADATA_DEFINITION_NAME = "DWG";
    public static final String NAME_FIELD_ID = "ID";
    public static final String NAME_FIELD_GEOMETRY = "Geometry";
    public static final String NAME_FIELD_ENTITY = "Entity";
    public static final String NAME_FIELD_LAYER = "Layer";
    public static final String NAME_FIELD_COLOR = "Color";
    public static final String NAME_FIELD_ELEVATION = "Elevation";
    public static final String NAME_FIELD_THICKNESS = "Thickness";
    public static final String NAME_FIELD_TEXT = "Text";
    public static final String NAME_FIELD_HEIGHTTEXT = "HeightText";
    public static final String NAME_FIELD_ROTATIONTEXT = "Rotation";
    private int ID_FIELD_ID = 0;
    private int ID_FIELD_GEOMETRY = 1;
    private int ID_FIELD_ENTITY = 2;
    private int ID_FIELD_LAYER = 3;
    private int ID_FIELD_COLOR = 4;
    private int ID_FIELD_ELEVATION = 5;
    private int ID_FIELD_THICKNESS = 6;
    private int ID_FIELD_TEXT = 7;
    private int ID_FIELD_HEIGHTTEXT = 8;
    private int ID_FIELD_ROTATIONTEXT = 9;
    private IProjection projection;
    private ResourceProvider resource;
    private LegendBuilder legendBuilder;
    private long counterNewsOIDs = 0L;
    protected GeometryManager geomManager = GeometryLocator.getGeometryManager();

    public DWGStoreProvider(DWGOpenStoreParameters parameters, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)parameters, storeServices, FileHelper.newMetadataContainer((String)"DWG"));
        File file = this.getDWGParameters().getFile();
        this.resource = this.createResource("file", new Object[]{file.getAbsolutePath()});
        this.resource.addConsumer((ResourceConsumer)this);
        this.projection = this.getDWGParameters().getCRS();
        try {
            this.legendBuilder = (LegendBuilder)this.invokeDynMethod("getLegendBuilder", null);
        }
        catch (DynMethodException e) {
            this.legendBuilder = null;
        }
        catch (Exception e) {
            throw new InitializeException((Throwable)e);
        }
        this.initializeFeatureTypes();
    }

    private DWGOpenStoreParameters getDWGParameters() {
        return (DWGOpenStoreParameters)this.getParameters();
    }

    public String getProviderName() {
        return "DWG";
    }

    public boolean allowWrite() {
        return false;
    }

    public Object getLegend() throws OpenException {
        this.open();
        if (this.legendBuilder == null) {
            return null;
        }
        return this.legendBuilder.getLegend();
    }

    public Object getLabeling() throws OpenException {
        this.open();
        if (this.legendBuilder == null) {
            return null;
        }
        return this.legendBuilder.getLabeling();
    }

    private AbstractMemoryStoreProvider getStoreProvider() {
        return this;
    }

    public void open() throws OpenException {
        if (this.data != null) {
            return;
        }
        try {
            this.getResource().execute(new ResourceAction(){

                public Object run() throws Exception {
                    ResourceProvider resource = DWGStoreProvider.this.getResource();
                    DWGData dwgData = null;
                    FeatureStoreProviderServices store = DWGStoreProvider.this.getStoreServices();
                    if (resource.getData() != null) {
                        dwgData = (DWGData)((Map)resource.getData()).get(DWGStoreProvider.this.projection.getAbrev());
                    } else {
                        resource.setData(new HashMap());
                    }
                    if (dwgData == null) {
                        dwgData = new DWGData();
                        dwgData.data = new ArrayList();
                        DWGStoreProvider.this.data = dwgData.data;
                        DWGStoreProvider.this.counterNewsOIDs = 0L;
                        Reader reader = new Reader().initialice(DWGStoreProvider.this.getStoreProvider(), (File)resource.get(), DWGStoreProvider.this.projection, DWGStoreProvider.this.legendBuilder);
                        reader.begin(store);
                        dwgData.defaultFType = reader.getDefaultType().getNotEditableCopy();
                        ArrayList<FeatureType> types = new ArrayList<FeatureType>();
                        for (EditableFeatureType fType : reader.getTypes()) {
                            if (fType.getId().equals(dwgData.defaultFType.getId())) {
                                types.add(dwgData.defaultFType);
                                continue;
                            }
                            types.add(fType.getNotEditableCopy());
                        }
                        dwgData.fTypes = types;
                        dwgData.legendBuilder = DWGStoreProvider.this.legendBuilder;
                        resource.notifyOpen();
                        store.setFeatureTypes(dwgData.fTypes, dwgData.defaultFType);
                        reader.load();
                        dwgData.envelope = reader.getEnvelope();
                        dwgData.projection = DWGStoreProvider.this.projection;
                        reader.end();
                        resource.notifyClose();
                        ((Map)resource.getData()).put(DWGStoreProvider.this.projection.getAbrev(), dwgData);
                    }
                    DWGStoreProvider.this.data = dwgData.data;
                    store.setFeatureTypes(dwgData.fTypes, dwgData.defaultFType);
                    DWGStoreProvider.this.legendBuilder = dwgData.legendBuilder;
                    DWGStoreProvider.this.setDynValue("Envelope", dwgData.getEnvelopeCopy());
                    DWGStoreProvider.this.setDynValue("CRS", DWGStoreProvider.this.projection);
                    DWGStoreProvider.this.counterNewsOIDs = DWGStoreProvider.this.data.size();
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.data = null;
            try {
                throw new OpenException(this.resource.getName(), (Throwable)e);
            }
            catch (AccessResourceException e1) {
                throw new OpenException(this.getProviderName(), (Throwable)e);
            }
        }
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getDWGParameters().getFile().getParent());
            return manager.createServerExplorer((DataServerExplorerParameters)params);
        }
        catch (DataException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
        catch (ValidateDataParametersException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        throw new UnsupportedOperationException();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public int getOIDType() {
        return 5;
    }

    public boolean supportsAppendMode() {
        return false;
    }

    public void append(FeatureProvider featureProvider) {
        throw new UnsupportedOperationException();
    }

    public void beginAppend() {
        throw new UnsupportedOperationException();
    }

    public void endAppend() {
        throw new UnsupportedOperationException();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        throw new NotYetImplemented();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        throw new NotYetImplemented();
    }

    public Object createNewOID() {
        return new Long(this.counterNewsOIDs++);
    }

    protected void initializeFeatureTypes() throws InitializeException {
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
    }

    public Envelope getEnvelope() throws DataException {
        this.open();
        return (Envelope)this.getDynValue("Envelope");
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", (Resource)resource);
    }

    public Object getSourceId() {
        return this.getDWGParameters().getFile();
    }

    public String getName() {
        String name = this.getDWGParameters().getFile().getName();
        int n = name.lastIndexOf(".");
        if (n < 1) {
            return name;
        }
        return name.substring(0, n);
    }

    public String getFullName() {
        return this.getDWGParameters().getFile().getAbsolutePath();
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    public class Reader {
        private File file;
        private String fileName;
        private IProjection projection;
        private List types;
        private LegendBuilder leyendBuilder;
        private AbstractMemoryStoreProvider store;
        private Envelope envelope;
        private DwgFile dwgFeatureFile;

        public Reader initialice(AbstractMemoryStoreProvider store, File file, IProjection projection, LegendBuilder leyendBuilder) {
            this.store = store;
            this.file = file;
            this.fileName = file.getAbsolutePath();
            this.projection = projection;
            this.leyendBuilder = leyendBuilder;
            if (leyendBuilder != null) {
                leyendBuilder.initialize((FeatureStoreProvider)store);
            }
            return this;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public void begin(FeatureStoreProviderServices store) throws UnsupportedDWGVersionException, ReadException {
            this.dwgFeatureFile = new DwgFile(this.file.getAbsolutePath());
            try {
                this.dwgFeatureFile.read();
            }
            catch (DwgVersionNotSupportedException e1) {
                throw new UnsupportedDWGVersionException(this.file.getName(), e1);
            }
            catch (IOException e) {
                throw new ReadException("DWG", (Throwable)e);
            }
            EditableFeatureType featureType = store.createFeatureType(DWGStoreProvider.this.getName());
            featureType.setHasOID(true);
            DWGStoreProvider.this.ID_FIELD_ID = featureType.add(DWGStoreProvider.NAME_FIELD_ID, 4).setDefaultValue((Object)0).getIndex();
            EditableFeatureAttributeDescriptor attr = featureType.add(DWGStoreProvider.NAME_FIELD_GEOMETRY, 66);
            attr.setSRS(this.projection);
            attr.setGeometryType(0);
            boolean is3dFile = this.dwgFeatureFile.isDwg3DFile();
            if (is3dFile) {
                attr.setGeometrySubType(1);
            } else {
                attr.setGeometrySubType(0);
            }
            DWGStoreProvider.this.ID_FIELD_GEOMETRY = attr.getIndex();
            featureType.setDefaultGeometryAttributeName(DWGStoreProvider.NAME_FIELD_GEOMETRY);
            DWGStoreProvider.this.ID_FIELD_ENTITY = featureType.add(DWGStoreProvider.NAME_FIELD_ENTITY, 8, 100).setDefaultValue((Object)"").getIndex();
            DWGStoreProvider.this.ID_FIELD_LAYER = featureType.add(DWGStoreProvider.NAME_FIELD_LAYER, 8, 100).setDefaultValue((Object)"default").getIndex();
            DWGStoreProvider.this.ID_FIELD_COLOR = featureType.add(DWGStoreProvider.NAME_FIELD_COLOR, 4).setDefaultValue((Object)0).getIndex();
            DWGStoreProvider.this.ID_FIELD_ELEVATION = featureType.add(DWGStoreProvider.NAME_FIELD_ELEVATION, 7).setDefaultValue((Object)0.0).getIndex();
            DWGStoreProvider.this.ID_FIELD_THICKNESS = featureType.add(DWGStoreProvider.NAME_FIELD_THICKNESS, 7).setDefaultValue((Object)0.0).getIndex();
            DWGStoreProvider.this.ID_FIELD_TEXT = featureType.add(DWGStoreProvider.NAME_FIELD_TEXT, 8, 100).setDefaultValue((Object)"").getIndex();
            DWGStoreProvider.this.ID_FIELD_HEIGHTTEXT = featureType.add(DWGStoreProvider.NAME_FIELD_HEIGHTTEXT, 7).setDefaultValue((Object)10.0).getIndex();
            DWGStoreProvider.this.ID_FIELD_ROTATIONTEXT = featureType.add(DWGStoreProvider.NAME_FIELD_ROTATIONTEXT, 7).setDefaultValue((Object)0.0).getIndex();
            this.types = new ArrayList();
            this.types.add(featureType);
            if (this.leyendBuilder != null) {
                this.leyendBuilder.begin();
            }
        }

        public void end() {
            if (this.leyendBuilder != null) {
                this.leyendBuilder.end();
            }
        }

        public List getTypes() {
            return this.types;
        }

        public EditableFeatureType getDefaultType() {
            return (EditableFeatureType)this.types.get(0);
        }

        private Double toDouble(String value) {
            if (value == null) {
                return 0.0;
            }
            return Double.valueOf(value);
        }

        public void load() throws DataException {
            this.envelope = null;
            long count_not_fmap_interface = 0L;
            long count_null_geometry = 0L;
            long count_bad_envelope = 0L;
            long count_envelope_out_of_aoi = 0L;
            this.dwgFeatureFile.calculateGisModelDwgPolylines();
            this.dwgFeatureFile.blockManagement2();
            List entities = this.dwgFeatureFile.getDwgObjects();
            int id = -1;
            try {
                int envelopeSubType = 0;
                boolean is3dFile = this.dwgFeatureFile.isDwg3DFile();
                this.envelope = DWGStoreProvider.this.geomManager.createEnvelope(envelopeSubType);
                boolean updateEnvelope = true;
                double[] extMin = (double[])this.dwgFeatureFile.getHeader("MSPACE_EXTMIN");
                double[] extMax = (double[])this.dwgFeatureFile.getHeader("MSPACE_EXTMAX");
                if (extMin != null && extMax != null) {
                    updateEnvelope = false;
                    Point point = DWGStoreProvider.this.geomManager.createPoint(extMin[0], extMin[1], envelopeSubType);
                    this.envelope.setLowerCorner(point);
                    point = DWGStoreProvider.this.geomManager.createPoint(extMax[0], extMax[1], envelopeSubType);
                    this.envelope.setUpperCorner(point);
                }
                Iterator iter = entities.iterator();
                while (iter.hasNext()) {
                    ++id;
                    DwgObject entity = (DwgObject)iter.next();
                    if (!(entity instanceof IDwg2FMap)) {
                        ++count_not_fmap_interface;
                        continue;
                    }
                    IDwg2FMap dwgEnt = (IDwg2FMap)entity;
                    Geometry geometry = dwgEnt.toFMapGeometry(is3dFile);
                    if (geometry == null) {
                        ++count_null_geometry;
                        continue;
                    }
                    if (!this.envelope.intersects(geometry.getEnvelope())) {
                        ++count_envelope_out_of_aoi;
                        continue;
                    }
                    FeatureProvider featureProvider = this.store.createFeatureProvider(this.store.getStoreServices().getDefaultFeatureType());
                    featureProvider.set(DWGStoreProvider.this.ID_FIELD_ID, (Object)id);
                    featureProvider.set(DWGStoreProvider.this.ID_FIELD_ENTITY, (Object)dwgEnt.toString());
                    featureProvider.set(DWGStoreProvider.this.ID_FIELD_LAYER, (Object)this.dwgFeatureFile.getLayerName(entity));
                    int colorByLayer = this.dwgFeatureFile.getColorByLayer(entity);
                    int color = entity.getColor();
                    if (color < 0) {
                        color = Math.abs(color);
                    }
                    if (color > 255) {
                        color = colorByLayer;
                    }
                    featureProvider.set(DWGStoreProvider.this.ID_FIELD_COLOR, (Object)color);
                    if (entity instanceof IDwg3DTestable) {
                        featureProvider.set(DWGStoreProvider.this.ID_FIELD_ELEVATION, (Object)((IDwg3DTestable)entity).getZ());
                    }
                    featureProvider.set(DWGStoreProvider.this.ID_FIELD_THICKNESS, (Object)0.0);
                    featureProvider.set(DWGStoreProvider.this.ID_FIELD_HEIGHTTEXT, (Object)0.0);
                    featureProvider.set(DWGStoreProvider.this.ID_FIELD_ROTATIONTEXT, (Object)0.0);
                    featureProvider.set(DWGStoreProvider.this.ID_FIELD_TEXT, (Object)"");
                    if (entity instanceof DwgMText) {
                        DwgMText mtext = (DwgMText)entity;
                        featureProvider.set(DWGStoreProvider.this.ID_FIELD_HEIGHTTEXT, (Object)mtext.getHeight());
                        featureProvider.set(DWGStoreProvider.this.ID_FIELD_TEXT, (Object)mtext.getText());
                    } else if (entity instanceof DwgText) {
                        DwgText text = (DwgText)entity;
                        featureProvider.set(DWGStoreProvider.this.ID_FIELD_THICKNESS, (Object)text.getThickness());
                        featureProvider.set(DWGStoreProvider.this.ID_FIELD_HEIGHTTEXT, (Object)text.getHeight());
                        featureProvider.set(DWGStoreProvider.this.ID_FIELD_ROTATIONTEXT, (Object)text.getRotationAngle());
                        featureProvider.set(DWGStoreProvider.this.ID_FIELD_TEXT, (Object)text.getText());
                    }
                    featureProvider.setDefaultGeometry(geometry);
                    this.store.addFeatureProvider(featureProvider);
                    if (this.leyendBuilder == null) continue;
                    this.leyendBuilder.process(featureProvider);
                }
                logger.info("Issues while loading DWG entities:+\n    Entities not implementing IDwg2FMap interface: " + count_not_fmap_interface + "\n" + "    Entities with non-convertible geometry: " + count_null_geometry + "\n" + "    Entities without valid envelope: " + count_bad_envelope + "\n" + "    Entities with envelope out of global envelope: " + count_envelope_out_of_aoi);
            }
            catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
                throw new CreateGeometryException((Throwable)e);
            }
            catch (CreateEnvelopeException e) {
                throw new CreateGeometryException((Throwable)e);
            }
        }
    }

    private class DWGData {
        public ArrayList data = null;
        public FeatureType defaultFType = null;
        public List fTypes = null;
        public Envelope envelope = null;
        public IProjection projection;
        public LegendBuilder legendBuilder = null;

        private DWGData() {
        }

        public Envelope getEnvelopeCopy() throws CreateEnvelopeException {
            if (this.envelope == null) {
                return null;
            }
            Envelope newEnvelope = this.envelope.getDimension() == 2 ? DWGStoreProvider.this.geomManager.createEnvelope(0) : DWGStoreProvider.this.geomManager.createEnvelope(1);
            newEnvelope.setLowerCorner(this.envelope.getLowerCorner());
            newEnvelope.setUpperCorner(this.envelope.getUpperCorner());
            return newEnvelope;
        }
    }
}

