/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.impl.expressionevaluator;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;

public class ExecuteSQLFunction
extends AbstractFunction {
    public static final String FUNCTION_EXECUTESQL = "EXECUTESQL";

    public ExecuteSQLFunction() {
        super("Data access", FUNCTION_EXECUTESQL, Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), "Receive a connection and SQL string as argument.", "EXECUTESQL({{connection}}, sql)", new String[]{"connection - conextion string (optional)", "sql - sql string"}, "Object", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        JDBCServerExplorer explorer;
        String sql;
        if (args.length == 1) {
            sql = this.getStr(args, 0);
            FeatureStore store = (FeatureStore)interpreter.getSymbolTable().function("CURRENT_STORE").call(interpreter, (Object[])null);
            explorer = (JDBCServerExplorer)store.getExplorer();
        } else {
            String connectionName = this.getStr(args, 0);
            sql = this.getStr(args, 1);
            if (this.getObject(args, 0) instanceof JDBCServerExplorer) {
                explorer = (JDBCServerExplorer)this.getObject(args, 0);
            } else if (this.getObject(args, 0) instanceof FeatureStore) {
                explorer = (JDBCServerExplorer)((FeatureStore)this.getObject(args, 0)).getExplorer();
            } else {
                DataManager dalManager = DALLocator.getManager();
                DataServerExplorerPoolEntry poolEntry = dalManager.getDataServerExplorerPool().get(connectionName);
                DataServerExplorerParameters explorerParameters = poolEntry.getExplorerParameters();
                explorer = (JDBCServerExplorer)dalManager.openServerExplorer(explorerParameters.getProviderName(), explorerParameters);
            }
        }
        Object result = explorer.execute(sql);
        return result;
    }
}

