/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolver;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dispose.Disposable;

public class JDBCSQLBuilderBase
extends SQLBuilderBase {
    private GeometryManager geometryManager = null;
    protected final JDBCHelper helper;

    public JDBCSQLBuilderBase(JDBCHelper helper) {
        this.helper = helper;
    }

    public JDBCHelper getHelper() {
        return this.helper;
    }

    protected GeometryManager getGeometryManager() {
        if (this.geometryManager == null) {
            this.geometryManager = GeometryLocator.getGeometryManager();
        }
        return this.geometryManager;
    }

    public Object srs_id(IProjection projection) {
        JDBCConnection conn = null;
        try {
            Object srscode;
            conn = this.helper.getConnection();
            SRSSolver solver = this.helper.getSRSSolver();
            Object object = srscode = solver.getDatabaseCode(conn, projection);
            return object;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't locate database code for SRS '" + projection.getAbrev() + "'.", ex);
        }
        finally {
            conn.closeQuietly();
        }
    }

    public void setParameters(PreparedStatement st) {
        try {
            int columnIndex = 1;
            for (ExpressionBuilder.Parameter parameter : this.parameters()) {
                st.setObject(columnIndex++, parameter.value());
            }
        }
        catch (Exception ex) {
            String p = "unknow";
            try {
                p = this.parameters().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Can't set parameters to prepared statement from parameters (" + p + ")", ex);
        }
    }

    public List<Object> getParameters(FeatureProvider feature) {
        return this.getParameters(feature, null);
    }

    public List<Object> getParameters(FeatureProvider feature, List<Integer> types) {
        try {
            DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
            FeatureType type = feature.getType();
            ArrayList<Object> values = new ArrayList<Object>();
            block8: for (ExpressionBuilder.Parameter parameter : this.parameters()) {
                Object value;
                if (parameter.is_constant()) {
                    value = parameter.value();
                    values.add(value);
                    if (types == null) continue;
                    if (value == null) {
                        types.add(64);
                        continue;
                    }
                    DataType dataType = dataTypesManager.getDataType(value.getClass());
                    types.add(dataType.getType());
                    continue;
                }
                String name = parameter.name();
                value = feature.get(name);
                FeatureAttributeDescriptor attrDesc = type.getAttributeDescriptor(name);
                switch (attrDesc.getType()) {
                    case 9: {
                        if (value == null) {
                            values.add(null);
                        } else {
                            values.add(new Date(((java.util.Date)value).getTime()));
                        }
                        if (types == null) continue block8;
                        types.add(9);
                        continue block8;
                    }
                    case 66: {
                        Geometry geom = this.forceGeometryType(attrDesc.getGeomType(), (Geometry)value);
                        values.add(geom);
                        if (types == null) continue block8;
                        types.add(66);
                        continue block8;
                    }
                }
                values.add(value);
                if (types == null) continue;
                types.add(attrDesc.getDataType().getType());
            }
            return values;
        }
        catch (Exception ex) {
            String f = "unknow";
            try {
                f = feature.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Can't get parameters to prepared statement from the feature (" + f + ")", ex);
        }
    }

    public Disposable setParameters(PreparedStatement st, FeatureProvider feature) {
        try {
            ArrayList<Integer> types = new ArrayList<Integer>();
            List<Object> values = this.getParameters(feature, types);
            return this.setStatementParameters(st, values, types, this.geometry_support_type());
        }
        catch (Exception ex) {
            String f = "unknow";
            try {
                f = feature.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Can't set parameters to prepared statement from the feature (" + f + ")", ex);
        }
    }

    protected Geometry forceGeometryType(GeometryType geomtype, Geometry geom) throws CreateGeometryException {
        if (geom == null) {
            return null;
        }
        switch (geomtype.getType()) {
            case 22: {
                if (geom.getType() != 19) break;
                MultiPolygon x = this.getGeometryManager().createMultiPolygon(geomtype.getSubType());
                x.addPrimitive((Primitive)geom);
                geom = x;
                break;
            }
            case 21: {
                if (geom.getType() != 18) break;
                MultiLine x = this.getGeometryManager().createMultiLine(geomtype.getSubType());
                x.addPrimitive((Primitive)geom);
                geom = x;
                break;
            }
            case 7: {
                if (geom.getType() != 1) break;
                MultiLine x = this.getGeometryManager().createMultiLine(geomtype.getSubType());
                x.addPrimitive((Primitive)geom);
                geom = x;
                break;
            }
            case 19: {
                MultiPolygon x;
                if (geom.getType() != 22 || (x = (MultiPolygon)geom).getPrimitivesNumber() != 1) break;
                geom = x.getPrimitiveAt(0);
                break;
            }
            case 18: {
                MultiLine x;
                if (geom.getType() != 21 || (x = (MultiLine)geom).getPrimitivesNumber() != 1) break;
                geom = x.getPrimitiveAt(0);
                break;
            }
            case 1: {
                MultiPoint x;
                if (geom.getType() != 7 || (x = (MultiPoint)geom).getPrimitivesNumber() != 1) break;
                geom = x.getPrimitiveAt(0);
            }
        }
        return geom;
    }

    public Disposable setParameters(PreparedStatement st, FeatureReference reference) {
        try {
            ArrayList<Object> values = new ArrayList<Object>();
            for (ExpressionBuilder.Parameter parameter : this.parameters()) {
                if (parameter.is_constant()) {
                    values.add(parameter.value());
                    continue;
                }
                String name = parameter.name();
                values.add(((FeatureReferenceProviderServices)reference).getKeyValue(name));
            }
            return this.setStatementParameters(st, values, null, this.geometry_support_type());
        }
        catch (Exception ex) {
            String f = "unknow";
            try {
                f = reference.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Can't set parameters to prepared statement from the feature (" + f + ")", ex);
        }
    }

    public Disposable setStatementParameters(PreparedStatement st, List values, GeometryExpressionBuilderHelper.GeometrySupportType geometrySupportType) throws SQLException {
        return this.setStatementParameters(st, values, null, geometrySupportType);
    }

    public Disposable setStatementParameters(PreparedStatement st, List values, List<Integer> types, GeometryExpressionBuilderHelper.GeometrySupportType geometrySupportType) throws SQLException {
        if (values == null) {
            return new Disposable(){

                public void dispose() {
                }
            };
        }
        if (LOGGER.isDebugEnabled()) {
            this.debug_setStatementParameters(st, values, types, geometrySupportType);
        }
        int columnIndex = 1;
        try {
            for (Object value : values) {
                if (value instanceof Geometry) {
                    switch (geometrySupportType) {
                        case WKT: {
                            value = ((Geometry)value).convertToWKT();
                            st.setObject(columnIndex, value);
                            break;
                        }
                        case NATIVE: {
                            byte[] bytes = this.getNativeBytes(st.getConnection(), (Geometry)value);
                            st.setBytes(columnIndex, bytes);
                            break;
                        }
                        case WKB: {
                            byte[] bytes = ((Geometry)value).convertToWKB();
                            st.setBytes(columnIndex, bytes);
                            break;
                        }
                        case EWKB: {
                            byte[] bytes = ((Geometry)value).convertToEWKB();
                            st.setBytes(columnIndex, bytes);
                        }
                    }
                } else if (types == null) {
                    st.setObject(columnIndex, value);
                } else {
                    this.setStatementValue(st, columnIndex, types.get(columnIndex - 1), value);
                }
                ++columnIndex;
            }
            return new Disposable(){

                public void dispose() {
                }
            };
        }
        catch (Exception ex) {
            throw new SQLException("Can't set values for the prepared statement.", ex);
        }
    }

    protected byte[] getNativeBytes(Connection conn, Geometry geometry) throws Exception {
        byte[] bytes = geometry.convertToWKB();
        return bytes;
    }

    protected void debug_setStatementParameters(PreparedStatement st, List values, List<Integer> types, GeometryExpressionBuilderHelper.GeometrySupportType geometrySupportType) throws SQLException {
        StringBuilder debug = new StringBuilder();
        debug.append("[");
        debug.append(JDBCUtils.getConnId(st));
        debug.append("] st.set(");
        try {
            int columnIndex = 1;
            for (Object value : values) {
                if (value instanceof Geometry) {
                    switch (geometrySupportType) {
                        case WKT: {
                            value = ((Geometry)value).convertToWKT();
                            debug.append("/*");
                            debug.append(columnIndex);
                            debug.append("*/ ");
                            debug.append(this.as_string(value));
                            debug.append(", ");
                            break;
                        }
                        case NATIVE: 
                        case WKB: {
                            byte[] bytes = ((Geometry)value).convertToWKB();
                            debug.append("/*");
                            debug.append(columnIndex);
                            debug.append("*/ ");
                            debug.append(this.as_string(bytes));
                            debug.append(", ");
                            break;
                        }
                        case EWKB: {
                            byte[] bytes = ((Geometry)value).convertToEWKB();
                            debug.append("/*");
                            debug.append(columnIndex);
                            debug.append("*/ ");
                            debug.append(this.as_string(bytes));
                            debug.append(", ");
                        }
                    }
                } else {
                    debug.append("/*");
                    debug.append(columnIndex);
                    debug.append("*/ ");
                    if (value instanceof String) {
                        debug.append(this.as_string(value));
                    } else if (value instanceof Boolean) {
                        debug.append((Boolean)value != false ? this.constant_true : this.constant_false);
                    } else {
                        debug.append(value);
                    }
                    debug.append(", ");
                }
                ++columnIndex;
            }
            debug.append(")");
            LOGGER.debug(debug.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setStatementValue(PreparedStatement st, int columnIndex, int type, Object value) throws SQLException {
        switch (type) {
            case 1: {
                if (value == null) {
                    st.setNull(columnIndex, -7);
                    break;
                }
                st.setBoolean(columnIndex, (Boolean)value);
                break;
            }
            case 4: {
                if (value == null) {
                    st.setNull(columnIndex, 4);
                    break;
                }
                st.setInt(columnIndex, (Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    st.setNull(columnIndex, -6);
                    break;
                }
                st.setByte(columnIndex, (Byte)value);
                break;
            }
            case 5: {
                if (value == null) {
                    st.setNull(columnIndex, -5);
                    break;
                }
                st.setLong(columnIndex, (Long)value);
                break;
            }
            case 6: {
                if (value == null) {
                    st.setNull(columnIndex, 7);
                    break;
                }
                st.setFloat(columnIndex, ((Float)value).floatValue());
                break;
            }
            case 7: {
                if (value == null) {
                    st.setNull(columnIndex, 8);
                    break;
                }
                st.setDouble(columnIndex, (Double)value);
                break;
            }
            case 19: {
                if (value == null) {
                    st.setNull(columnIndex, 3);
                    break;
                }
                st.setBigDecimal(columnIndex, (BigDecimal)value);
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                value = Objects.toString(value, null);
            }
            case 8: {
                if (value == null) {
                    st.setNull(columnIndex, 12);
                    break;
                }
                st.setString(columnIndex, (String)value);
                break;
            }
            case 11: {
                if (value == null) {
                    st.setNull(columnIndex, 93);
                    break;
                }
                st.setTimestamp(columnIndex, (Timestamp)value);
                break;
            }
            case 10: {
                if (value == null) {
                    st.setNull(columnIndex, 92);
                    break;
                }
                st.setTime(columnIndex, (Time)value);
                break;
            }
            case 9: {
                if (value == null) {
                    st.setNull(columnIndex, 91);
                    break;
                }
                st.setDate(columnIndex, (Date)value);
                break;
            }
            case 12: {
                if (value == null) {
                    st.setNull(columnIndex, -2);
                    break;
                }
                st.setBytes(columnIndex, (byte[])value);
                break;
            }
            default: {
                st.setObject(columnIndex, value);
                LOGGER.debug("Attention, using a statement.setObject");
            }
        }
    }
}

