/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.SupportTransactions;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.spi.CompoundResourcesStorageWithSupportTransactions;
import org.gvsig.fmap.dal.feature.spi.LocalTransaction;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.db.spi.AbstractDBServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCExecuteSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.ConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCHelperBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCResourcesStorage;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CanCreateTablesOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CreateTableOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.DropTableOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ExecuteOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ListTablesOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.RetrieveValueOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.UpdateTableStatisticsOperation;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.resourcesstorage.AbstractResourcesStorage;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.CachedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCServerExplorerBase
extends AbstractDBServerExplorer
implements JDBCServerExplorer,
SupportTransactions {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCServerExplorerBase.class);
    private static final String CONFIG_NAME_CUSTOM_RESOURCES = "CUSTOM_RESOURCES";
    protected JDBCHelper helper = null;
    private Boolean canAdd;
    private static final Map<String, CachedTablesValue> CACHED_TABLES = Collections.synchronizedMap(new LRUMap(10));
    private static final Map<String, CachedValue<CustomResourcesConfig>> CACHED_CUSTOM_RESOURCES_CONFIG = Collections.synchronizedMap(new LRUMap(10));

    public JDBCServerExplorerBase(JDBCServerExplorerParameters parameters, DataServerExplorerProviderServices services, JDBCHelper helper) throws InitializeException {
        super((DataServerExplorerParameters)parameters, services);
        this.helper = helper;
    }

    public String getProviderName() {
        return this.getHelper().getProviderName();
    }

    public String getStoreName() {
        return this.getHelper().getProviderName();
    }

    protected DataManagerProviderServices getManager() {
        return (DataManagerProviderServices)DALLocator.getDataManager();
    }

    public JDBCServerExplorerParameters getParameters() {
        return (JDBCServerExplorerParameters)super.getParameters();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        this.getHelper().getResulSetControler().pack();
        return true;
    }

    public void resourceChanged(ResourceProvider resource) {
    }

    protected JDBCHelper getHelper() {
        return this.helper;
    }

    protected OperationsFactory getOperations() {
        return this.getHelper().getOperations();
    }

    public DataStore open(DataStoreParameters params) throws DataException {
        this.checkIsMine(params);
        try {
            DataStore store = this.getManager().openStore(this.getTransaction(), params.getProviderName(), params);
            return store;
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public DataStore open(String tableName) throws DataException {
        JDBCStoreParameters params = this.get(tableName);
        try {
            DataStore store = this.getManager().openStore(this.getTransaction(), params.getProviderName(), (DataStoreParameters)params);
            return store;
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public List list(int mode) throws DataException {
        return this.list(mode, 0);
    }

    public List list(int mode, int tablesOrViews) throws DataException {
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((DataServerExplorer)this);
            boolean informationTables = BooleanUtils.isTrue((Boolean)this.getParameters().getShowInformationDBTables());
            JDBCServerExplorerParameters serverParams = this.getParameters();
            String key = this.buildKeyForCachedTables(mode, serverParams, informationTables, tablesOrViews);
            CachedTablesValue tablesValue = CACHED_TABLES.get(key);
            List<JDBCStoreParameters> tables = null;
            if (tablesValue != null) {
                tables = tablesValue.get(this.helper);
            }
            if (tables != null) {
                List<JDBCStoreParameters> list = tables;
                return list;
            }
            tablesValue = new CachedTablesValue(this.helper, mode, serverParams, informationTables, 60000L, tablesOrViews);
            CACHED_TABLES.put(key, tablesValue);
            tables = tablesValue.get(this.helper);
            trans.commit();
            List<JDBCStoreParameters> list = tables;
            return list;
        }
        catch (Exception ex) {
            trans.abortQuietly();
            throw ex;
        }
        finally {
            trans.closeQuietly();
        }
    }

    public String buildKeyForCachedTables(int mode, JDBCServerExplorerParameters params, boolean informationTables, int tablesOrViews) {
        JDBCServerExplorerParameters clonedParams = (JDBCServerExplorerParameters)params.getCopy();
        clonedParams.setSchema(null);
        clonedParams.setCatalog(null);
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(mode));
        builder.append(Hex.encodeHex((byte[])clonedParams.toByteArray()));
        builder.append(String.valueOf(informationTables));
        builder.append(String.valueOf(tablesOrViews));
        String key = builder.toString();
        return key;
    }

    public void remove(DataStoreParameters theParams) throws RemoveException {
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((DataServerExplorer)this);
            JDBCStoreParameters params = (JDBCStoreParameters)theParams;
            DropTableOperation removeTable = this.getOperations().createDropTable(this.getOperations().createTableReference(params));
            if (((Boolean)removeTable.perform()).booleanValue()) {
                this.dropCachedTables();
            }
            trans.commit();
        }
        catch (RemoveException ex) {
            trans.abortQuietly();
            throw ex;
        }
        catch (Exception ex) {
            trans.abortQuietly();
            throw new RemoveException("Can't remove " + Objects.toString(theParams), (Throwable)ex);
        }
        finally {
            trans.closeQuietly();
        }
    }

    public JDBCStoreParameters getOpenParameters() throws DataException {
        JDBCStoreParameters params = this.helper.createOpenStoreParameters(this.getParameters());
        if (StringUtils.isBlank((CharSequence)params.getSchema())) {
            params.setSchema(this.createSQLBuilder().default_schema());
        }
        return params;
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        JDBCNewStoreParameters params = this.getAddParameters();
        params.setTable(storeName);
        return params;
    }

    public JDBCNewStoreParameters getAddParameters() throws DataException {
        JDBCServerExplorerParameters parameters = this.getParameters();
        JDBCNewStoreParameters params = this.helper.createNewStoreParameters();
        params.setHost(parameters.getHost());
        params.setPort(parameters.getPort());
        params.setDBName(parameters.getDBName());
        params.setUser(parameters.getUser());
        params.setPassword(parameters.getPassword());
        params.setCatalog(parameters.getCatalog());
        params.setSchema(parameters.getSchema());
        params.setJDBCDriverClassName(parameters.getJDBCDriverClassName());
        params.setUrl(parameters.getUrl());
        if (parameters instanceof FilesystemStoreParameters) {
            File f = ((FilesystemStoreParameters)parameters).getFile();
            ((FilesystemStoreParameters)params).setFile(f);
        }
        params.setDefaultFeatureType((FeatureType)this.getServerExplorerProviderServices().createNewFeatureType());
        return params;
    }

    protected void checkIsMine(DataStoreParameters dsp) {
        if (!(dsp instanceof JDBCConnectionParameters)) {
            throw new IllegalArgumentException("not instance of FilesystemStoreParameters");
        }
        JDBCServerExplorerParameters parameters = this.getParameters();
        JDBCConnectionParameters pgp = (JDBCConnectionParameters)dsp;
        if (!StringUtils.equals((CharSequence)pgp.getHost(), (CharSequence)parameters.getHost())) {
            throw new IllegalArgumentException("wrong explorer: Host (mine: " + parameters.getHost() + " other:" + pgp.getHost() + ")");
        }
        if (!ObjectUtils.equals((Object)pgp.getPort(), (Object)parameters.getPort())) {
            throw new IllegalArgumentException("wrong explorer: Port (mine: " + parameters.getPort() + " other:" + pgp.getPort() + ")");
        }
        if (!StringUtils.equals((CharSequence)pgp.getDBName(), (CharSequence)parameters.getDBName())) {
            throw new IllegalArgumentException("wrong explorer: DBName (mine: " + parameters.getDBName() + " other:" + pgp.getDBName() + ")");
        }
        if (!StringUtils.isEmpty((CharSequence)parameters.getCatalog()) && !StringUtils.equals((CharSequence)pgp.getCatalog(), (CharSequence)parameters.getCatalog())) {
            throw new IllegalArgumentException("wrong explorer: Catalog (mine: " + parameters.getCatalog() + " other:" + pgp.getCatalog() + ")");
        }
        if (!StringUtils.isEmpty((CharSequence)parameters.getSchema()) && !StringUtils.equals((CharSequence)pgp.getSchema(), (CharSequence)parameters.getSchema())) {
            throw new IllegalArgumentException("wrong explorer: Schema (mine: " + parameters.getSchema() + " other:" + pgp.getSchema() + ")");
        }
    }

    public void open() throws OpenException {
    }

    public void close() throws CloseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() throws BaseException {
        Map<String, CachedTablesValue> map = CACHED_TABLES;
        synchronized (map) {
            ArrayList toRemove = new ArrayList();
            this.helper.dispose();
            this.helper = null;
        }
    }

    public boolean canAdd() {
        if (this.canAdd == null) {
            CanCreateTablesOperation canAdd_ = this.getOperations().createCanCreateTables();
            this.canAdd = (Boolean)canAdd_.perform();
        }
        return this.canAdd;
    }

    public FeatureType getFeatureType(DataStoreParameters theParams) throws DataException {
        JDBCStoreParameters params = (JDBCStoreParameters)theParams;
        this.checkIsMine((DataStoreParameters)params);
        EditableFeatureType fetureType = this.getServerExplorerProviderServices().createNewFeatureType();
        List<String> primaryKeys = null;
        if (params.getPkFields() != null) {
            primaryKeys = Arrays.asList(params.getPkFields());
        }
        FetchFeatureTypeOperation fetch = this.getOperations().createFetchFeatureType(fetureType, this.getOperations().createTableReference(params), primaryKeys, params.getDefaultGeometryField(), params.getCRS());
        fetch.perform();
        return fetureType;
    }

    public boolean add(String providerName, NewDataStoreParameters theParams, boolean overwrite) throws DataException {
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            CreateTableOperation createTable;
            boolean isOk;
            trans.begin();
            trans.add((DataServerExplorer)this);
            ArrayList<Pair<String, SQLBuilder.Privilege>> userAndPrivileges = new ArrayList<Pair<String, SQLBuilder.Privilege>>();
            JDBCNewStoreParameters params = (JDBCNewStoreParameters)theParams;
            if (!StringUtils.isEmpty((CharSequence)params.getAllRole())) {
                userAndPrivileges.add((Pair<String, SQLBuilder.Privilege>)new ImmutablePair((Object)params.getAllRole(), (Object)SQLBuilder.Privilege.ALL));
            }
            if (!StringUtils.isEmpty((CharSequence)params.getDeleteRole())) {
                userAndPrivileges.add((Pair<String, SQLBuilder.Privilege>)new ImmutablePair((Object)params.getDeleteRole(), (Object)SQLBuilder.Privilege.DELETE));
            }
            if (!StringUtils.isEmpty((CharSequence)params.getInsertRole())) {
                userAndPrivileges.add((Pair<String, SQLBuilder.Privilege>)new ImmutablePair((Object)params.getInsertRole(), (Object)SQLBuilder.Privilege.INSERT));
            }
            if (!StringUtils.isEmpty((CharSequence)params.getReferenceRole())) {
                userAndPrivileges.add((Pair<String, SQLBuilder.Privilege>)new ImmutablePair((Object)params.getReferenceRole(), (Object)SQLBuilder.Privilege.REFERENCE));
            }
            if (!StringUtils.isEmpty((CharSequence)params.getSelectRole())) {
                userAndPrivileges.add((Pair<String, SQLBuilder.Privilege>)new ImmutablePair((Object)params.getSelectRole(), (Object)SQLBuilder.Privilege.SELECT));
            }
            if (!StringUtils.isEmpty((CharSequence)params.getTriggerRole())) {
                userAndPrivileges.add((Pair<String, SQLBuilder.Privilege>)new ImmutablePair((Object)params.getTriggerRole(), (Object)SQLBuilder.Privilege.TRIGGER));
            }
            if (!StringUtils.isEmpty((CharSequence)params.getTruncateRole())) {
                userAndPrivileges.add((Pair<String, SQLBuilder.Privilege>)new ImmutablePair((Object)params.getTruncateRole(), (Object)SQLBuilder.Privilege.TRUNCATE));
            }
            if (!StringUtils.isEmpty((CharSequence)params.getUpdateRole())) {
                userAndPrivileges.add((Pair<String, SQLBuilder.Privilege>)new ImmutablePair((Object)params.getUpdateRole(), (Object)SQLBuilder.Privilege.UPDATE));
            }
            ArrayList<String> additionalSQLs = new ArrayList<String>();
            if (!StringUtils.isEmpty((CharSequence)params.getPostCreatingStatement())) {
                additionalSQLs.add(params.getPostCreatingStatement());
            }
            if (!(isOk = ((Boolean)(createTable = this.getOperations().createTable(this.getOperations().createTableReference(params), (FeatureType)params.getDefaultFeatureType(), userAndPrivileges, additionalSQLs)).perform()).booleanValue())) {
                trans.commit();
                boolean bl = false;
                return bl;
            }
            params.setDefaultFeatureType(createTable.getType());
            if (theParams instanceof NewFeatureStoreParameters) {
                DataManager dataManager = DALLocator.getDataManager();
                ResourcesStorage resources = this.getResourcesStorage((DataStoreParameters)theParams);
                dataManager.writeDALResource(resources, (FeatureType)((NewFeatureStoreParameters)theParams).getDefaultFeatureType());
            }
            this.dropCachedTables();
            trans.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            trans.abortQuietly();
            throw ex;
        }
        finally {
            trans.closeQuietly();
        }
    }

    public void dropCaches() {
        this.dropCachedTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropCachedTables() {
        boolean informationTables = BooleanUtils.isTrue((Boolean)this.getParameters().getShowInformationDBTables());
        Map<String, CachedTablesValue> map = CACHED_TABLES;
        synchronized (map) {
            CACHED_TABLES.remove(this.buildKeyForCachedTables(0, this.getParameters(), informationTables, 0));
            CACHED_TABLES.remove(this.buildKeyForCachedTables(1, this.getParameters(), informationTables, 0));
            CACHED_TABLES.remove(this.buildKeyForCachedTables(2, this.getParameters(), informationTables, 0));
            CACHED_TABLES.remove(this.buildKeyForCachedTables(0, this.getParameters(), informationTables, 1));
            CACHED_TABLES.remove(this.buildKeyForCachedTables(1, this.getParameters(), informationTables, 1));
            CACHED_TABLES.remove(this.buildKeyForCachedTables(2, this.getParameters(), informationTables, 1));
            CACHED_TABLES.remove(this.buildKeyForCachedTables(0, this.getParameters(), informationTables, 2));
            CACHED_TABLES.remove(this.buildKeyForCachedTables(1, this.getParameters(), informationTables, 2));
            CACHED_TABLES.remove(this.buildKeyForCachedTables(2, this.getParameters(), informationTables, 2));
        }
    }

    public List getDataStoreProviderNames() {
        ArrayList<String> x = new ArrayList<String>(1);
        x.add(this.getProviderName());
        return x;
    }

    public void updateTableStatistics(String database, String schema, String table) throws JDBCExecuteSQLException {
        UpdateTableStatisticsOperation updateStatistics = this.getOperations().createUpdateTableStatistics(this.getOperations().createTableReference(database, schema, table, null));
        updateStatistics.perform();
    }

    public Object execute(String sql) {
        String mode;
        try {
            String sqltrim = sql.trim();
            mode = StringUtils.left((String)sqltrim, (int)sqltrim.indexOf(32)).toLowerCase();
        }
        catch (Exception e) {
            mode = "unknown";
        }
        switch (mode) {
            case "select": {
                try {
                    ExecuteOperation execute = this.getOperations().createExecute(sql);
                    Object res = execute.perform();
                    return res;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException("Can't execute sql '" + sql + "'", ex);
                }
            }
        }
        LocalTransaction trans = new LocalTransaction((DataManager)this.getManager(), new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((DataServerExplorer)this);
            ExecuteOperation execute = this.getOperations().createExecute(sql);
            Object res = execute.perform();
            trans.commit();
            Object object = res;
            return object;
        }
        catch (RuntimeException ex) {
            trans.abortQuietly();
            throw ex;
        }
        catch (Exception ex) {
            trans.abortQuietly();
            throw new RuntimeException("Can't execute sql '" + sql + "'", ex);
        }
        finally {
            trans.closeQuietly();
        }
    }

    public JDBCStoreParameters get(String name) throws DataException {
        JDBCStoreParameters params = this.getOpenParameters(name);
        return params;
    }

    public SQLBuilder createSQLBuilder() {
        JDBCSQLBuilderBase builder = this.getHelper().createSQLBuilder();
        return builder;
    }

    private CustomResourcesConfig getCustomResourcesConfig() {
        JDBCServerExplorerParameters serverParams = this.getParameters();
        String key = this.buildKeyForCachedTables(0, serverParams, false, 0);
        CachedCustomResourcesConfig cachedConfig = CACHED_CUSTOM_RESOURCES_CONFIG.get(key);
        if (cachedConfig != null) {
            CustomResourcesConfig config = (CustomResourcesConfig)cachedConfig.get();
            return config;
        }
        JDBCStoreParameters params = this.helper.createOpenStoreParameters(this.getParameters());
        cachedConfig = new CachedCustomResourcesConfig(params);
        CACHED_CUSTOM_RESOURCES_CONFIG.put(key, cachedConfig);
        return (CustomResourcesConfig)cachedConfig.get();
    }

    private void refreshCustomResourcesConfig() {
        JDBCServerExplorerParameters serverParams = this.getParameters();
        String key = this.buildKeyForCachedTables(0, serverParams, false, 0);
        CachedValue<CustomResourcesConfig> cachedConfig = CACHED_CUSTOM_RESOURCES_CONFIG.get(key);
        if (cachedConfig != null) {
            cachedConfig.expired();
        }
    }

    private ResourcesStorage getResourcesStorage(DataStoreParameters parameters, String storeName) {
        if (DatabaseWorkspaceManager.isInternalTable((String)storeName)) {
            ResourcesStorage resourcesStorage = ResourcesStorage.EMPTY_RESOURCESSTORAGE;
            return resourcesStorage;
        }
        String resourcesTablename = null;
        try {
            CustomResourcesConfig config;
            ResourcesStorage alternateResourcesStorage = null;
            DataManager dataManager = DALLocator.getDataManager();
            DatabaseWorkspaceManager workspace = dataManager.getDatabaseWorkspace(parameters);
            if (workspace != null) {
                alternateResourcesStorage = workspace.getAlternativeResourcesStorage(storeName);
            }
            if (alternateResourcesStorage == null) {
                alternateResourcesStorage = this.getLocalResourcesStorage(parameters, storeName);
            }
            Object defaultResourcesStorage = null;
            JDBCResourcesStorage customResourcesStorage = null;
            resourcesTablename = "GVSIGD_RESOURCES";
            List tables = this.list();
            for (JDBCStoreParameters params : tables) {
                String theTableName = params.getTable();
                if (!StringUtils.equals((CharSequence)theTableName, (CharSequence)resourcesTablename)) continue;
                defaultResourcesStorage = new JDBCResourcesStorage(this.helper, alternateResourcesStorage, params, storeName);
                break;
            }
            if ((config = this.getCustomResourcesConfig()) != null) {
                if (config.isInternalTable(storeName)) {
                    defaultResourcesStorage = ResourcesStorage.EMPTY_RESOURCESSTORAGE;
                } else {
                    resourcesTablename = config.getResourcesTablename(storeName);
                    if (StringUtils.isNotBlank((CharSequence)resourcesTablename)) {
                        JDBCStoreParameters params;
                        params = this.getOpenParameters(resourcesTablename);
                        customResourcesStorage = new JDBCResourcesStorage(this.helper, alternateResourcesStorage, params, storeName, config.isResourcesReadOnly(resourcesTablename));
                    }
                }
            }
            if (defaultResourcesStorage == null && customResourcesStorage == null) {
                defaultResourcesStorage = this.getLocalResourcesStorage(parameters, storeName);
            }
            return new CompoundResourcesStorageWithSupportTransactions(new ResourcesStorage[]{defaultResourcesStorage, customResourcesStorage});
        }
        catch (Throwable ex) {
            LOG.warn("Can't retrieve reources storage for table '" + storeName + "' in '" + this.getParameters().getUrl() + "' (" + resourcesTablename + ").", ex);
            ResourcesStorage theResourcesStorage = ResourcesStorage.EMPTY_RESOURCESSTORAGE;
            return theResourcesStorage;
        }
    }

    protected ResourcesStorage getLocalResourcesStorage(DataStoreParameters parameters, String storeName) {
        try {
            File storeResourcesFolder;
            DataManager dataManager = DALLocator.getDataManager();
            File baseResourcesFolder = dataManager.getLocalResourcesFolder((DataServerExplorerParameters)this.getParameters());
            if (!baseResourcesFolder.exists()) {
                baseResourcesFolder.mkdirs();
            }
            if (!(storeResourcesFolder = FileUtils.getFile((File)baseResourcesFolder, (String[])new String[]{"resources", storeName})).exists()) {
                return null;
            }
            ResourcesStorage resourcesStorage = ResourcesStorage.createFilesResourcesStorage((String)storeResourcesFolder.getAbsolutePath());
            return resourcesStorage;
        }
        catch (Throwable ex) {
            LOG.warn("Can't create local reources storage for table '" + storeName + "' in '" + this.getParameters().getUrl() + "'.", ex);
            return null;
        }
    }

    public ResourcesStorage getResourcesStorage(String name) {
        try {
            JDBCStoreParameters params;
            String resourcesTablename;
            JDBCResourcesStorage customResourcesStorage = null;
            CustomResourcesConfig config = this.getCustomResourcesConfig();
            if (config != null && !config.isInternalTable(name) && StringUtils.isNotBlank((CharSequence)(resourcesTablename = config.getResourcesTablename(name)))) {
                params = this.getOpenParameters(resourcesTablename);
                customResourcesStorage = new JDBCResourcesStorage(this.helper, null, params, "$ServerExplorer", config.isResourcesReadOnly(resourcesTablename));
            }
            params = this.getOpenParameters("GVSIGD_RESOURCES");
            JDBCResourcesStorage defaultResourcesStorage = new JDBCResourcesStorage(this.helper, null, params, "$ServerExplorer");
            if (customResourcesStorage == null) {
                return defaultResourcesStorage;
            }
            return new CompoundResourcesStorageWithSupportTransactions(new ResourcesStorage[]{defaultResourcesStorage, customResourcesStorage});
        }
        catch (DataException ex) {
            return null;
        }
    }

    public ResourcesStorage getResourcesStorage() {
        try {
            AbstractResourcesStorage theResourcesStorage;
            JDBCStoreParameters params = this.getOpenParameters("GVSIGD_RESOURCES");
            if (this.exists((DataStoreParameters)params)) {
                theResourcesStorage = new JDBCResourcesStorage(this.helper, null, params, "$ServerExplorer");
            } else {
                DataManager dataManager = DALLocator.getDataManager();
                File resFolder = FileUtils.getFile((File)dataManager.getLocalResourcesFolder((DataServerExplorerParameters)this.getParameters()), (String[])new String[]{"resources"});
                if (!resFolder.exists()) {
                    return ResourcesStorage.EMPTY_RESOURCESSTORAGE;
                }
                final LinkedHashMap<String, FilesResourcesStorage.FileResource> resources = new LinkedHashMap<String, FilesResourcesStorage.FileResource>();
                for (File resTableFolder : resFolder.listFiles()) {
                    for (File resourceFile : resTableFolder.listFiles()) {
                        String name = resTableFolder.getName() + "." + resourceFile.getName();
                        FilesResourcesStorage.FileResource resource = new FilesResourcesStorage.FileResource(name, resourceFile);
                        resources.put(name, resource);
                    }
                }
                theResourcesStorage = new AbstractResourcesStorage(){

                    public ResourcesStorage.Resource getResource(String resourceName) {
                        return (ResourcesStorage.Resource)resources.get(resourceName);
                    }

                    public List<String> getResourceNames() {
                        return new ArrayList<String>(resources.keySet());
                    }
                };
            }
            return theResourcesStorage;
        }
        catch (DataException ex) {
            return null;
        }
    }

    public ResourcesStorage getResourcesStorage(DataStoreParameters parameters) {
        String tableName;
        if (parameters == null) {
            throw new IllegalArgumentException("null is a valid value for parameters.");
        }
        if (parameters instanceof JDBCNewStoreParameters) {
            tableName = ((JDBCNewStoreParameters)parameters).getTable();
        } else if (parameters instanceof JDBCStoreParameters) {
            tableName = ((JDBCStoreParameters)parameters).getTable();
        } else {
            throw new IllegalArgumentException("Required a JDBCStoreParameters or JDBCNewStoreParameters parameters, received " + parameters.getClass().getName() + ".");
        }
        return this.getResourcesStorage(parameters, tableName);
    }

    public ResourcesStorage getResourcesStorage(DataStore dataStore) {
        return this.getResourcesStorage((DataStoreParameters)((JDBCStoreParameters)dataStore.getParameters()), dataStore.getName());
    }

    public boolean exists(DataStoreParameters parameters) throws DataException {
        JDBCStoreParameters params = (JDBCStoreParameters)parameters;
        JDBCSQLBuilderBase builder = this.getHelper().createSQLBuilder();
        SQLBuilder.TableNameBuilder searchTable = builder.createTableNameBuilder().database(params.getDBName()).schema(params.getSchema()).name(params.getTable());
        SQLBuilder.TableNameBuilder table = builder.createTableNameBuilder();
        List l = this.list();
        for (JDBCStoreParameters current : l) {
            table.database(current.getDBName()).schema(current.getSchema()).name(current.getTable());
            if (!table.equals(searchTable)) continue;
            return true;
        }
        return false;
    }

    public void setCustomResources(String tableName, String resourcesTableName) {
        this.setCustomResources(tableName, resourcesTableName, false);
    }

    public void setCustomResources(String tableName, String resourcesTableName, boolean readonly) {
        CustomResourcesConfig config = this.getCustomResourcesConfig();
        if (config == null) {
            throw new RuntimeException("Can't retrieve alternative resources configuration");
        }
        config.addResourceMapping(tableName, resourcesTableName);
        config.setResourcesReadOnly(resourcesTableName, readonly);
        JDBCStoreParameters params = this.helper.createOpenStoreParameters(this.getParameters());
        if (!JDBCServerExplorerBase.setConfigValue(params, CONFIG_NAME_CUSTOM_RESOURCES, config.toJsonString())) {
            throw new RuntimeException("Can't save custom resources configuration");
        }
        this.refreshCustomResourcesConfig();
        if (StringUtils.isNotBlank((CharSequence)resourcesTableName)) {
            try {
                params = this.getOpenParameters(resourcesTableName);
                JDBCResourcesStorage resourcesStorage = new JDBCResourcesStorage(this.helper, null, params, tableName, config.isResourcesReadOnly(resourcesTableName));
                resourcesStorage.clearCache();
            }
            catch (Exception ex) {
                LOG.debug("Can't remove local cache for table " + tableName, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setConfigValue(JDBCStoreParameters params, String name, String value) {
        FeatureStore store = null;
        try {
            DataManager dataManager = DALLocator.getDataManager();
            params.setTable("GVSIGD_CONFIG");
            store = (FeatureStore)dataManager.openStore(params.getProviderName(), (DataStoreParameters)params);
        }
        catch (Exception ex) {
            LOG.trace("Can't read configuration value '" + name + "'", (Throwable)ex);
        }
        if (store == null) {
            return false;
        }
        try {
            store.edit();
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            String filter = builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)name)).toString();
            Feature feature = store.findFirst(filter);
            if (feature == null) {
                EditableFeature efeature = store.createNewFeature();
                efeature.set("name", (Object)name);
                efeature.set("value", (Object)value);
                store.insert(efeature);
            } else {
                EditableFeature efeature = feature.getEditable();
                efeature.set("value", (Object)value);
                store.update(efeature);
            }
            store.finishEditing();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LOG.debug("Can't write configuration value for '" + name + "'", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getConfigValue(JDBCStoreParameters params, String name) {
        String string;
        JDBCServerExplorerBase explorer = null;
        DataManager dataManager = DALLocator.getDataManager();
        LocalTransaction trans = new LocalTransaction(dataManager, null);
        try {
            trans.begin();
            params.setTable("GVSIGD_CONFIG");
            JDBCServerExplorerParameters explorerParams = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters(params.getProviderName());
            ToolsLocator.getDynObjectManager().copy((DynObject)params, (DynObject)explorerParams);
            explorer = (JDBCServerExplorerBase)dataManager.openServerExplorer(explorerParams.getProviderName(), (DataServerExplorerParameters)explorerParams);
            trans.add((DataServerExplorer)explorer);
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            String filter = builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)name)).toString();
            OperationsFactory operations = explorer.getOperations();
            RetrieveValueOperation op = operations.createRetrieveValue(operations.createTableReference(params), filter, null, "value");
            Object value = op.perform();
            trans.commit();
            string = Objects.toString(value, null);
        }
        catch (Exception ex) {
            String string2;
            try {
                LOG.debug("Can't read configuration value '" + name + "'", (Throwable)ex);
                trans.abortQuietly();
                string2 = null;
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(explorer);
                throw throwable;
            }
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return string2;
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)explorer);
        return string;
    }

    public boolean exists() {
        try {
            JDBCServerExplorerParameters serverParameters = this.getParameters();
            OperationsFactory operations = this.helper.getOperations();
            ListTablesOperation listTables = operations.createListTables(0, serverParameters, false, 1);
            List tables = (List)listTables.perform();
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    public String getConnectionProviderStatus() {
        return this.helper.getConnectionProviderStatus();
    }

    public void setTransaction(DataTransaction transaction) {
        if (this.helper != null) {
            this.helper.setTransaction((DataTransactionServices)transaction);
        }
    }

    public DataTransaction getTransaction() {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getTransaction();
    }

    private JDBCStoreParameters getOpenParameters(String tableName) throws DataException {
        JDBCStoreParameters p = this.getOpenParameters();
        p.setTable(tableName);
        return p;
    }

    public List<String> getCreateTableSQLs(String databaseName, String schemaName, String tableName, FeatureType type) throws DataException {
        OperationsFactory operations = this.helper.getOperations();
        return operations.createTableSQLs(databaseName, schemaName, tableName, type);
    }

    public Connection createConnection() throws SQLException {
        if (!(this.helper instanceof JDBCHelperBase)) {
            return null;
        }
        JDBCHelperBase h = (JDBCHelperBase)this.helper;
        ConnectionProvider cp = h.getConnectionProvider();
        Connection con = cp.getConnection();
        return con;
    }

    private static class CachedTablesValue
    extends CachedValue<List<JDBCStoreParameters>> {
        private final int mode;
        private final JDBCServerExplorerParameters serverParameters;
        private final boolean informationTables;
        private final int tablesOrViews;

        public CachedTablesValue(JDBCHelper helper, int mode, JDBCServerExplorerParameters serverParameters, boolean informationTables, int tablesOrViews) {
            this.mode = mode;
            this.serverParameters = serverParameters;
            this.informationTables = informationTables;
            this.tablesOrViews = tablesOrViews;
        }

        public CachedTablesValue(JDBCHelper helper, int mode, JDBCServerExplorerParameters serverParameters, boolean informationTables, long expireTime, int tablesOrViews) {
            this.mode = mode;
            this.setExpireTime(expireTime);
            this.serverParameters = serverParameters;
            this.informationTables = informationTables;
            this.tablesOrViews = tablesOrViews;
        }

        protected void reload() {
            throw new UnsupportedOperationException("Use get(helper) instead.");
        }

        protected void reload(JDBCHelper helper) {
            List tables = null;
            if (helper == null) {
                this.setValue(tables);
                return;
            }
            OperationsFactory operations = helper.getOperations();
            if (operations == null) {
                this.setValue(null);
                LOG.debug("Sets tables to null to force reload tables from new ServerExplorar.");
                return;
            }
            try {
                ListTablesOperation listTables = operations.createListTables(this.mode, this.serverParameters, this.informationTables, this.tablesOrViews);
                tables = (List)listTables.perform();
                this.setValue(tables);
            }
            catch (Exception ex) {
                LOG.debug("Can't reload cached list of tables.", (Throwable)ex);
                throw new RuntimeException("Can't load list of tables", ex);
            }
        }

        public List<JDBCStoreParameters> get(JDBCHelper helper) {
            if (this.isExpired()) {
                this.reload(helper);
            }
            this.resetAccess();
            return (List)this.getValue();
        }
    }

    private static class CachedCustomResourcesConfig
    extends CachedValue<CustomResourcesConfig> {
        private final JDBCStoreParameters openParameters;

        private CachedCustomResourcesConfig(JDBCStoreParameters openParameters) {
            this.openParameters = openParameters;
            this.setExpireTime(1800000L);
        }

        protected void reload() {
            String jsonConfig = JDBCServerExplorerBase.getConfigValue(this.openParameters, JDBCServerExplorerBase.CONFIG_NAME_CUSTOM_RESOURCES);
            CustomResourcesConfig config = new CustomResourcesConfig(jsonConfig);
            this.setExpireTime(config.getCacheExpireTimeInMillis());
            this.setValue(config);
        }
    }

    private static class CustomResourcesConfig {
        private static final String CUSTOM_RESOURCES_CACHETIME = "CacheTime";
        private static final String CUSTOM_RESOURCES_MAPPING = "Mapping";
        private static final String CUSTOM_RESOURCES_READONLY = "ResourcesReadonly";
        private int cacheTime = 1800000;
        private Map<String, String> mapping = new HashMap<String, String>();
        private Map<String, Boolean> resourcesReadonly = new HashMap<String, Boolean>();

        public CustomResourcesConfig(String jsonConfig) {
            if (StringUtils.isNotBlank((CharSequence)jsonConfig)) {
                try {
                    JsonValue value;
                    String key;
                    JsonObject config = Json.createObject((String)jsonConfig);
                    this.cacheTime = config.getInt(CUSTOM_RESOURCES_CACHETIME, this.cacheTime);
                    if (config.containsKey((Object)CUSTOM_RESOURCES_MAPPING)) {
                        JsonObject m = config.getJsonObject(CUSTOM_RESOURCES_MAPPING);
                        for (Map.Entry entry : m.entrySet()) {
                            key = (String)entry.getKey();
                            value = (JsonValue)entry.getValue();
                            if (!(value instanceof JsonString)) continue;
                            this.mapping.put(key, ((JsonString)value).getString());
                        }
                    }
                    if (config.containsKey((Object)CUSTOM_RESOURCES_READONLY)) {
                        JsonObject resreadonly = config.getJsonObject(CUSTOM_RESOURCES_READONLY);
                        for (Map.Entry entry : resreadonly.entrySet()) {
                            key = (String)entry.getKey();
                            value = (JsonValue)entry.getValue();
                            if (value == JsonValue.TRUE) {
                                this.resourcesReadonly.put(key, true);
                                continue;
                            }
                            if (value != JsonValue.FALSE) continue;
                            this.resourcesReadonly.put(key, false);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.debug("Can't parse json from CUSTOM_RESOURCES variable", (Throwable)ex);
                }
            }
        }

        public String toJsonString() {
            org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add(CUSTOM_RESOURCES_CACHETIME, this.cacheTime);
            org.gvsig.json.JsonObjectBuilder m = Json.createObjectBuilder();
            for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                m.add(key, value);
            }
            builder.add(CUSTOM_RESOURCES_MAPPING, (JsonObjectBuilder)m);
            org.gvsig.json.JsonObjectBuilder resreadonly = Json.createObjectBuilder();
            for (Map.Entry<String, Boolean> entry : this.resourcesReadonly.entrySet()) {
                String key = entry.getKey();
                Boolean readonly = entry.getValue();
                resreadonly.add(key, (Object)readonly);
            }
            builder.add(CUSTOM_RESOURCES_READONLY, (JsonObjectBuilder)resreadonly);
            return builder.build().toString();
        }

        public int getCacheExpireTimeInMillis() {
            return this.cacheTime;
        }

        public String getResourcesTablename(String tablename) {
            String resourceTablename = this.mapping.get(tablename);
            return resourceTablename;
        }

        public void addResourceMapping(String tablename, String resourcesTablename) {
            this.mapping.put(tablename, resourcesTablename);
        }

        private boolean isInternalTable(String storeName) {
            if (DatabaseWorkspaceManager.isInternalTable((String)storeName)) {
                return true;
            }
            for (String resourcesTablename : this.mapping.values()) {
                if (!StringUtils.equals((CharSequence)storeName, (CharSequence)resourcesTablename)) continue;
                return true;
            }
            return false;
        }

        public void setResourcesReadOnly(String resourcesTableName, boolean readonly) {
            this.resourcesReadonly.put(resourcesTableName, readonly);
        }

        public boolean isResourcesReadOnly(String resourcesTableName) {
            return this.resourcesReadonly.getOrDefault(resourcesTableName, false);
        }
    }
}

