/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionWritableOperation;

public class CreateTableOperation
extends AbstractConnectionWritableOperation {
    protected final OperationsFactory.TableReference table;
    protected FeatureType type;
    protected final List<Pair<String, SQLBuilder.Privilege>> userAndPrivileges;
    protected final List<String> additionalSQLs;

    public CreateTableOperation(JDBCHelper helper) {
        this(helper, null, null, null, null);
    }

    public CreateTableOperation(JDBCHelper helper, OperationsFactory.TableReference table, FeatureType type, List<Pair<String, SQLBuilder.Privilege>> userAndPrivileges, List<String> additionalSQLs) {
        super(helper);
        this.table = table;
        this.type = type;
        this.userAndPrivileges = userAndPrivileges;
        this.additionalSQLs = additionalSQLs;
    }

    public FeatureType getType() {
        return this.type;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        return this.performCreateTable(conn);
    }

    protected List<String> buildCreateIndexesSQL(OperationsFactory.TableReference table, FeatureType type) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (FeatureAttributeDescriptor attr : type) {
            if (!attr.isIndexed() || attr.isPrimaryKey()) continue;
            JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
            SQLBuilder.CreateIndexBuilder createIndex = sqlbuilder.create_index();
            createIndex.setFeatureType(type);
            if (attr.getType() == 66) {
                createIndex.spatial();
            }
            createIndex.if_not_exist();
            createIndex.name("idx_" + table.toString().replace(".", "_") + "_" + attr.getName());
            createIndex.column(attr.getName());
            createIndex.table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
            if (!attr.allowIndexDuplicateds()) {
                createIndex.unique();
            }
            sqls.addAll(createIndex.toStrings());
        }
        return sqls;
    }

    public List<String> getSQLs() throws DataException {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        sqlbuilder.create_table().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        for (FeatureAttributeDescriptor attr : this.type) {
            if (attr.isComputed()) continue;
            if (attr.getType() == 66) {
                sqlbuilder.create_table().add_column(attr);
                continue;
            }
            Object defaultValue = attr.getDefaultValue();
            if (defaultValue instanceof CharSequence && ExpressionUtils.isDynamicText((String)defaultValue.toString())) {
                defaultValue = null;
            }
            sqlbuilder.create_table().add_column(attr.getName(), attr.getType(), attr.getSize(), attr.getPrecision(), attr.getScale(), attr.isPrimaryKey(), attr.isIndexed(), attr.allowNull(), attr.isAutomatic(), defaultValue);
            if (!attr.isForeingKey()) continue;
            ForeingKey fk = attr.getForeingKey();
            SQLBuilder.ColumnDescriptor column = sqlbuilder.create_table().getColumnDescriptor(attr.getName());
            if (fk.isClosedList()) {
                column.foreignkey(fk.getTableName(), null);
                column.setCategorized(true);
            }
            if (!fk.getEnsureReferentialIntegrity()) continue;
            column.foreignkey(fk.getTableName(), fk.getCodeName());
        }
        if (this.userAndPrivileges != null) {
            for (Pair<String, SQLBuilder.Privilege> roleAndPrivilege : this.userAndPrivileges) {
                sqlbuilder.grant().role((String)roleAndPrivilege.getLeft()).privilege((SQLBuilder.Privilege)roleAndPrivilege.getRight());
            }
        }
        List sqls = sqlbuilder.create_table().toStrings();
        sqls.addAll(this.buildCreateIndexesSQL(this.table, this.type));
        sqls.addAll(sqlbuilder.grant().toStrings());
        if (this.additionalSQLs != null) {
            sqls.addAll(this.additionalSQLs);
        }
        return sqls;
    }

    public boolean performCreateTable(JDBCConnection conn) throws DataException {
        List<String> sqls = this.getSQLs();
        Statement st = null;
        String currsql = null;
        try {
            st = conn.createStatement(StringUtils.join(sqls, (String)"; "));
            Iterator<String> iterator = sqls.iterator();
            while (iterator.hasNext()) {
                String sql;
                currsql = sql = iterator.next();
                JDBCUtils.execute(st, sql);
            }
        }
        catch (SQLException ex) {
            try {
                throw new JDBCSQLException(ex, currsql);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(st);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly(st);
        return true;
    }
}

