/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.Statement;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;

public class DeletePassThroughOperation
extends AbstractConnectionOperation {
    private final Expression filter;
    private final OperationsFactory.TableReference table;

    public DeletePassThroughOperation(JDBCHelper helper, OperationsFactory.TableReference table, Expression filter) {
        super(helper);
        this.table = table;
        this.filter = filter;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        return this.execute(this.table, this.filter);
    }

    public Object execute(OperationsFactory.TableReference table, Expression filter) {
        Statement st = null;
        String sql = this.getSQL(table, filter);
        try {
            st = this.getConnection().createStatement(sql);
            JDBCUtils.executeUpdate(st, sql);
            JDBCUtils.closeQuietly(st);
            return null;
        }
        catch (Exception ex) {
            JDBCUtils.closeQuietly(st);
            throw new RuntimeException("Can't execute query [" + sql + "].", ex);
        }
    }

    public String getSQL(OperationsFactory.TableReference table, Expression filter) {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        sqlbuilder.delete().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        if (filter != null) {
            sqlbuilder.delete().where().set(filter.getCode().toValue());
        }
        String sql = sqlbuilder.delete().toString();
        return sql;
    }
}

