/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.about.impl;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gvsig.about.AboutContribution;
import org.gvsig.about.AboutDeveloper;
import org.gvsig.about.AboutManager;
import org.gvsig.about.AboutParticipant;
import org.gvsig.about.AboutProject;
import org.gvsig.about.AboutSponsor;
import org.gvsig.about.AboutTranslator;
import org.gvsig.about.impl.DefaultAboutDeveloper;
import org.gvsig.about.impl.DefaultAboutProject;
import org.gvsig.about.impl.DefaultAboutSponsor;
import org.gvsig.about.impl.DefaultAboutTranslator;
import org.gvsig.about.swing.JAboutPanel;

public class DefaultAboutManager
implements AboutManager {
    protected List<AboutDeveloper> developers = new ArrayList<AboutDeveloper>();
    protected List<AboutTranslator> translators;
    protected List<AboutSponsor> sponsors = new ArrayList<AboutSponsor>();
    protected DefaultAboutProject root;
    protected int ICON_SIZE = 16;

    public DefaultAboutManager() {
        this.translators = new ArrayList<AboutTranslator>();
    }

    public void setProject(String name, URL description, URL icon) {
        this.root = new DefaultAboutProject(this, name, description, icon);
    }

    public void setProject(String name, URL description, URL icon, Map<String, String> vars) {
        this.root = new DefaultAboutProject(this, name, description, icon, vars);
    }

    public AboutParticipant addDeveloper(String name, URL description, int priority) {
        return this.addDeveloper(name, description, priority, null);
    }

    public AboutParticipant addDeveloper(String name, URL description, int priority, URL icon) {
        AboutDeveloper participant = this.getDeveloper(name);
        if (participant == null) {
            participant = new DefaultAboutDeveloper(this, name, description, priority, icon);
            this.developers.add(participant);
            Collections.sort(this.developers, new Comparator<AboutDeveloper>(){

                @Override
                public int compare(AboutDeveloper p1, AboutDeveloper p2) {
                    return p1.getPriority() < p2.getPriority() ? -1 : (p1.getPriority() > p2.getPriority() ? 1 : 0);
                }
            });
        }
        return participant;
    }

    public AboutParticipant addSponsor(String name, URL description, int priority) {
        return this.addSponsor(name, description, priority, null);
    }

    public AboutParticipant addSponsor(String name, URL description, int priority, URL icon) {
        AboutSponsor participant = this.getSponsor(name);
        if (participant == null) {
            participant = new DefaultAboutSponsor(this, name, description, priority, icon);
            this.sponsors.add(participant);
            Collections.sort(this.sponsors, new Comparator<AboutSponsor>(){

                @Override
                public int compare(AboutSponsor p1, AboutSponsor p2) {
                    return p1.getPriority() < p2.getPriority() ? -1 : (p1.getPriority() > p2.getPriority() ? 1 : 0);
                }
            });
        }
        return participant;
    }

    public AboutParticipant addTranslator(String name, URL description, int priority) {
        return this.addTranslator(name, description, priority, null);
    }

    public AboutParticipant addTranslator(String name, URL description, int priority, URL icon) {
        AboutTranslator participant = this.getTranslator(name);
        if (participant == null) {
            participant = new DefaultAboutTranslator(this, name, description, priority, icon);
            this.translators.add(participant);
            Collections.sort(this.translators, new Comparator<AboutTranslator>(){

                @Override
                public int compare(AboutTranslator p1, AboutTranslator p2) {
                    return p1.getPriority() < p2.getPriority() ? -1 : (p1.getPriority() > p2.getPriority() ? 1 : 0);
                }
            });
        }
        return participant;
    }

    public JPanel getAboutPanel() {
        JAboutPanel panel = new JAboutPanel(this);
        return panel;
    }

    public List<AboutContribution> getContributions(AboutParticipant participant) {
        return participant.getContributions();
    }

    public ImageIcon getImageIcon(String name) {
        return this.getImageIcon(name, null);
    }

    public ImageIcon getImageIcon(URL url) {
        return this.getImageIcon(url, null);
    }

    public ImageIcon getImageIcon(String name, String defaultName) {
        URL url = this.getClass().getClassLoader().getResource("org/gvsig/about/images/i16x16/" + name);
        return this.getImageIcon(url, defaultName);
    }

    public ImageIcon getImageIcon(URL url, String defaultName) {
        if (url == null) {
            url = this.getClass().getClassLoader().getResource("org/gvsig/about/images/i16x16/" + defaultName);
        }
        if (url == null) {
            url = this.getClass().getClassLoader().getResource("org/gvsig/about/images/i16x16/image-missing.png");
        }
        if (url == null) {
            url = this.getClass().getClassLoader().getResource("org/gvsig/about/images/i16x16/" + defaultName);
        }
        if (url == null) {
            return new ImageIcon();
        }
        return new ImageIcon(url);
    }

    public AboutProject getProject() {
        return this.root;
    }

    public List<AboutDeveloper> getDevelopers() {
        return this.developers;
    }

    public List<AboutSponsor> getSponsors() {
        return this.sponsors;
    }

    public List<AboutTranslator> getTranslators() {
        return this.translators;
    }

    private AboutParticipant getParticipantByName(List l, String name) {
        for (AboutParticipant ap : l) {
            if (!ap.getName().equals(name)) continue;
            return ap;
        }
        return null;
    }

    public AboutDeveloper getDeveloper(String name) {
        AboutDeveloper ap = (AboutDeveloper)this.getParticipantByName(this.developers, name);
        if (ap != null) {
            return ap;
        }
        return null;
    }

    public AboutSponsor getSponsor(String name) {
        AboutSponsor ap = (AboutSponsor)this.getParticipantByName(this.sponsors, name);
        if (ap != null) {
            return ap;
        }
        return null;
    }

    public AboutTranslator getTranslator(String name) {
        AboutTranslator ap = (AboutTranslator)this.getParticipantByName(this.translators, name);
        if (ap != null) {
            return ap;
        }
        return null;
    }

    public String getStringFromFile(String filename) throws FileNotFoundException, IOException {
        String str;
        BufferedReader b = new BufferedReader(new FileReader(filename));
        StringBuffer sb = new StringBuffer();
        while ((str = b.readLine()) != null) {
            sb.append(str);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getStringFromUrl(URL url) {
        InputStream imp = null;
        try {
            imp = url.openStream();
        }
        catch (IOException e) {
            return null;
        }
        BufferedReader b = new BufferedReader(new InputStreamReader(imp));
        StringBuffer sb = new StringBuffer();
        try {
            String str;
            while ((str = b.readLine()) != null) {
                sb.append(str);
                sb.append('\n');
            }
            b.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String data = sb.toString();
        return this.addBaseURLTag(url, data);
    }

    private String addBaseURLTag(URL url, String data) {
        String baseTag = "<base href=\"" + this.getURLBase(url) + "\"/>";
        int index = data.indexOf("<head>");
        data = index > -1 ? data.substring(0, index) + "<head>" + baseTag + data.substring(index + "<head>".length()) : ((index = data.indexOf("<html>")) > -1 ? data.substring(0, index + "<html>".length()) + "<head>" + baseTag + "</head>" + data.substring(index + "<html>".length()) : "<head>" + baseTag + "</head>" + data);
        return data;
    }

    public String getStringFromUrl(URL url, Map<String, String> vars) {
        String data = this.getStringFromUrl(url);
        return this.expandVars(data, vars);
    }

    public String expandVars(String data, Map<String, String> vars) {
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            data = this.replaceVariable(data, entry.getKey(), entry.getValue());
        }
        return data;
    }

    private String replaceVariable(String text, String varName, String replacementString) {
        String searchString = "%(".concat(varName).concat(")");
        StringBuffer sBuffer = new StringBuffer();
        int pos = 0;
        while ((pos = text.indexOf(searchString)) != -1) {
            sBuffer.append(text.substring(0, pos) + replacementString);
            text = text.substring(pos + searchString.length());
        }
        sBuffer.append(text);
        return sBuffer.toString();
    }

    public String getURLBase(URL fileURL) {
        if (fileURL != null) {
            String urlStr = fileURL.toString();
            int index = urlStr.lastIndexOf(47);
            if (index == urlStr.length() - 1) {
                index = urlStr.substring(0, index).lastIndexOf(47);
            }
            return urlStr.substring(0, index + 1);
        }
        return null;
    }
}

