/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.app.ogr.mainplugin.gui;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.gdal.app.ogr.mainplugin.gui.JOGRDataExplorer;
import org.gvsig.gdal.app.ogr.mainplugin.gui.JOGRDataExplorerController;
import org.gvsig.gdal.prov.ogr.OGRDataStoreParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OGRWizarPanel
extends WizardPanel {
    private static final Logger LOG = LoggerFactory.getLogger(OGRWizarPanel.class);
    private static final long serialVersionUID = 678408522883979629L;
    private static final String TAB_NAME = "OGR";
    private final JOGRDataExplorer component = new JOGRDataExplorerController();

    public OGRWizarPanel() {
        this.initWizard();
    }

    public void close() {
    }

    public void execute() {
        List<DataStoreParameters> layerProperties;
        I18nManager i18n = ToolsLocator.getI18nManager();
        String connectionString = this.component.getConnectionString();
        if (StringUtils.isBlank((String)connectionString)) {
            return;
        }
        try {
            layerProperties = this.component.getSelectedLayerProperties();
        }
        catch (Throwable e) {
            LOG.warn("Can not get properties of selected layers", e);
            JOptionPane.showMessageDialog(this.component.asJComponent(), i18n.getTranslation("error_getting_selected_layer_properties"), i18n.getTranslation("error"), 0);
            return;
        }
        if (layerProperties == null || layerProperties.isEmpty()) {
            JOptionPane.showMessageDialog(this.component.asJComponent(), i18n.getTranslation("_You_must_select_at_least_one_layer") + "\n\n" + i18n.getTranslation("_Make_sure_that_in_addition_to_selecting_a_file_click_on_the_open_button_and_you_have_selected_at_least_one_layer_from_the_list"), i18n.getTranslation("_Warning"), 2);
            return;
        }
        for (DataStoreParameters parameters : layerProperties) {
            OGRDataStoreParameters ogrParameters = (OGRDataStoreParameters)parameters;
            if (ogrParameters.getCRS() == null) {
                ogrParameters.setCRS(this.getMapContext().getProjection());
            }
            this.doAddLayer(ogrParameters.getLayerName(), (DataStoreParameters)ogrParameters);
        }
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void initWizard() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.setTabName(i18nManager.getTranslation(TAB_NAME));
        this.setLayout(new BorderLayout());
        this.add(this.component.asJComponent(), "Center");
    }
}

