/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.io;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.List;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorer;
import org.gvsig.fmap.dal.spi.DataServerExplorerProvider;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.wcs.io.WCSConnector;
import org.gvsig.raster.wcs.io.WCSDataParametersImpl;
import org.gvsig.raster.wcs.io.WCSLayerNode;
import org.gvsig.raster.wcs.io.WCSProvider;
import org.gvsig.raster.wcs.io.WCSServerExplorerParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCSServerExplorer
extends AbstractDataServerExplorer
implements RasterDataServerExplorer,
DataServerExplorerProvider {
    private WCSConnector connector = null;
    private static final Logger logger = LoggerFactory.getLogger(WCSServerExplorer.class);

    public WCSServerExplorer(WCSServerExplorerParameters parameters, DataServerExplorerProviderServices services) throws InitializeException {
        super((DataServerExplorerParameters)parameters, services);
    }

    public String getDataStoreProviderName() {
        return WCSProvider.NAME;
    }

    public String getDescription() {
        return WCSProvider.DESCRIPTION;
    }

    public boolean add(String provider, NewDataStoreParameters parameters, boolean overwrite) throws DataException {
        return false;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canAdd(String storeName) throws DataException {
        return false;
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        return null;
    }

    public List getDataStoreProviderNames() {
        return null;
    }

    public WCSServerExplorerParameters getParameters() {
        return (WCSServerExplorerParameters)super.getParameters();
    }

    public List list() throws DataException {
        return null;
    }

    public List list(int mode) throws DataException {
        return null;
    }

    public void remove(DataStoreParameters parameters) throws DataException {
    }

    public String getProviderName() {
        return null;
    }

    public Hashtable getOnlineResources() {
        return null;
    }

    public DataStoreParameters getStoredParameters() {
        DataManager manager = DALLocator.getDataManager();
        WCSDataParametersImpl params = null;
        try {
            params = (WCSDataParametersImpl)manager.createStoreParameters(this.getDataStoreProviderName());
        }
        catch (InitializeException e) {
            logger.warn("Can't get DataStoreParameters from WCSServerExplorer", (Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            logger.warn("Can't get DataStoreParameters from WCSServerExplorer", (Throwable)e);
        }
        String host = this.getParameters().getHost();
        try {
            URI hostURI = new URI(host);
            params.setURI(hostURI);
        }
        catch (URISyntaxException e) {
            logger.warn("Can't create URI from" + host, (Throwable)e);
        }
        return params;
    }

    public void connect(ICancellable cancellable) throws ConnectException {
        URL url = null;
        boolean override = false;
        try {
            url = new URL(this.getParameters().getHost());
        }
        catch (Exception e) {
            throw new ConnectException(Messages.getText((String)"malformed_url"), (Throwable)e);
        }
        try {
            this.connector = WCSProvider.getConnectorFromURL(url);
            if (!this.connector.connect(override, cancellable)) {
                throw new ConnectException(Messages.getText((String)"error_connecting"));
            }
        }
        catch (IOException e) {
            throw new ConnectException(Messages.getText((String)"error_connecting"), (Throwable)e);
        }
    }

    public boolean isHostReachable(int timeout) {
        URL url = null;
        try {
            url = new URL(this.getParameters().getHost());
            URLConnection con = url.openConnection();
            if (con == null) {
                return false;
            }
            con.connect();
            InputStream stream = con.getInputStream();
            if (stream == null) {
                return false;
            }
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean isHostReachable() {
        int timeout = 10000;
        return this.isHostReachable(timeout);
    }

    public boolean isConnected() {
        return this.connector != null;
    }

    public String getAbstract() {
        if (this.connector != null) {
            return this.connector.getDescription();
        }
        return null;
    }

    public String getServerType() {
        if (this.getVersion() == null) {
            return "WCS";
        }
        return "WCS " + this.getVersion();
    }

    public String getVersion() {
        if (this.connector != null) {
            return this.connector.getVersion() == null ? "" : this.connector.getVersion();
        }
        return null;
    }

    public String getHost() {
        return this.getParameters().getHost();
    }

    public String getTitle() {
        return null;
    }

    public DataServerExplorerProviderServices getServerExplorerProviderServices() {
        return null;
    }

    public Point2D getMaxResolution(String layerName) {
        return this.connector.getMaxResolution(layerName);
    }

    public WCSLayerNode[] getCoverageList() {
        return this.connector.getLayerList();
    }

    public WCSLayerNode getCoverageByName(String name) {
        WCSLayerNode[] list = this.getCoverageList();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].getName().compareTo(name) != 0) continue;
            return list[i];
        }
        return null;
    }
}

