/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.io;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorerParameters;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.wcs.io.WCSProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;

public class WCSServerExplorerParameters
extends AbstractDataServerExplorerParameters
implements DataServerExplorerParameters {
    protected static final String FIELD_HOST = "host";
    protected static DynClass DYNCLASS = null;
    private DelegatedDynObject delegatedDynObject = null;
    private static final String AXIS_ORDER = "axisorder";

    public WCSServerExplorerParameters() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(WCSServerExplorerParameters.registerDynClass());
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("WCSServerExplorerParameters_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(WCSServerExplorerParameters.class, "WCSServerExplorerParameters_Persistent", "WCS Explorer DataParameters Persistency", null, null);
        }
        AbstractRasterDataParameters.registerDynClass((DynStruct)definition);
        definition.addDynFieldBoolean(AXIS_ORDER).setDescription("Longitude first in axis order").setMandatory(false);
        definition.addDynFieldString(FIELD_HOST).setDescription("Uniform Resource Identifier (File name or URL)").setMandatory(false);
        return definition;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    public String getHost() {
        return (String)this.getDynValue(FIELD_HOST);
    }

    public void setHost(String host) {
        this.setDynValue(FIELD_HOST, host);
    }

    public String getDataStoreName() {
        return WCSProvider.NAME;
    }

    public String getDescription() {
        return WCSProvider.DESCRIPTION;
    }

    public String getExplorerName() {
        return WCSProvider.NAME;
    }

    public boolean isLongitudeFirst() {
        Object b;
        Object obj = this.getDynValue(AXIS_ORDER);
        if (obj instanceof Boolean && (b = (Boolean)this.getDynValue(AXIS_ORDER)) != null) {
            return (Boolean)b;
        }
        if (obj instanceof String && (b = (String)this.getDynValue(AXIS_ORDER)) != null) {
            return new Boolean((String)b);
        }
        return false;
    }

    public void setLongitudeFirst(boolean longFirst) {
        this.setDynValue(AXIS_ORDER, new Boolean(longFirst));
    }

    public boolean isTheSameServerExplorer(DataServerExplorerParameters params) {
        if (!(params instanceof WCSServerExplorerParameters)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getHost(), (CharSequence)((WCSServerExplorerParameters)params).getHost());
    }
}

