/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.splitline.operation;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperation;

public class SplitLineOperationUtils {
    private static final Map<Integer, SplitLineOperation> operations = new HashMap<Integer, SplitLineOperation>();

    public static void register(SplitLineOperation operation, int geometryType) {
        operations.put(geometryType, operation);
    }

    public static SplitLineOperation getOperation(Primitive geom) {
        Integer type = geom.getGeometryType().getType();
        SplitLineOperation operation = operations.get(type);
        return operation;
    }

    public static boolean intersects(Curve curve, Point projectedPoint) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double tolerance = 1.0;
        return curve.buffer(tolerance).intersects((Geometry)projectedPoint);
    }

    public static Point[] getPerpendicular(Double m, Double b, Point perp, int subtype) throws CreateGeometryException {
        if (m == Double.POSITIVE_INFINITY) {
            Point[] res = new Point[]{SplitLineOperationUtils.createPoint(0.0, perp.getY(), subtype), SplitLineOperationUtils.createPoint(1.0, perp.getY(), subtype)};
            return res;
        }
        if (m == Double.NEGATIVE_INFINITY) {
            Point[] res = new Point[]{SplitLineOperationUtils.createPoint(1.0, perp.getY(), subtype), SplitLineOperationUtils.createPoint(0.0, perp.getY(), subtype)};
            return res;
        }
        Double m1 = -1.0 / m;
        Double b1 = perp.getY() - m1 * perp.getX();
        Point[] res = new Point[2];
        if (Double.isInfinite(m1)) {
            res[0] = SplitLineOperationUtils.createPoint(perp.getX(), 0.0, subtype);
            res[1] = SplitLineOperationUtils.createPoint(perp.getX(), perp.getY(), subtype);
        } else {
            res[0] = SplitLineOperationUtils.createPoint(0.0, 0.0 + b1, subtype);
            res[1] = SplitLineOperationUtils.createPoint(perp.getX(), m1 * perp.getX() + b1, subtype);
        }
        return res;
    }

    public static double getAngle(Point start, Point end) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double angle = Math.acos((end.getX() - start.getX()) / start.distance((Geometry)end));
        if (start.getY() > end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static Point getMidPoint(Point a, Point b, int subtype) throws CreateGeometryException {
        double x = (a.getX() + b.getX()) / 2.0;
        double y = (a.getY() + b.getY()) / 2.0;
        return SplitLineOperationUtils.createPoint(x, y, subtype);
    }

    public static Point createPoint(double x, double y, int subtype) throws CreateGeometryException {
        Point point = (Point)GeometryLocator.getGeometryManager().create(1, subtype);
        point.setX(x);
        point.setY(y);
        return point;
    }

    public static Double[] getLineParams(Point point, Point nextPoint) {
        Double[] lineParams = new Double[2];
        double denom = nextPoint.getX() - point.getX();
        if (denom != 0.0) {
            lineParams[0] = (nextPoint.getY() - point.getY()) / denom;
            lineParams[1] = point.getY() - lineParams[0] * point.getX();
        } else if (nextPoint.getY() >= point.getY()) {
            lineParams[0] = Double.POSITIVE_INFINITY;
            lineParams[1] = Double.NEGATIVE_INFINITY;
            if (point.getX() == 0.0) {
                lineParams[1] = 0.0;
            }
        } else {
            lineParams[0] = Double.NEGATIVE_INFINITY;
            lineParams[1] = Double.POSITIVE_INFINITY;
            if (point.getX() == 0.0) {
                lineParams[1] = 0.0;
            }
        }
        return lineParams;
    }

    public static Point getIntersection(Point[] lineA, Point[] lineB, int subtype) throws CreateGeometryException {
        Point p1 = lineA[0];
        Point p2 = lineA[1];
        Point p3 = lineB[0];
        Point p4 = lineB[1];
        double m1 = Double.POSITIVE_INFINITY;
        if (p2.getX() - p1.getX() != 0.0) {
            m1 = (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
        }
        double m2 = Double.POSITIVE_INFINITY;
        if (p4.getX() - p3.getX() != 0.0) {
            m2 = (p4.getY() - p3.getY()) / (p4.getX() - p3.getX());
        }
        if (m1 == Double.POSITIVE_INFINITY && m2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        double b1 = p2.getY() - m1 * p2.getX();
        double b2 = p4.getY() - m2 * p4.getX();
        if (m1 != Double.POSITIVE_INFINITY && m2 != Double.POSITIVE_INFINITY) {
            if (m1 == m2) {
                return null;
            }
            double x = (b2 - b1) / (m1 - m2);
            return SplitLineOperationUtils.createPoint(x, m1 * x + b1, subtype);
        }
        if (m1 == Double.POSITIVE_INFINITY) {
            double x = p1.getX();
            return SplitLineOperationUtils.createPoint(x, m2 * x + b2, subtype);
        }
        if (m2 == Double.POSITIVE_INFINITY) {
            double x = p3.getX();
            return SplitLineOperationUtils.createPoint(x, m1 * x + b1, subtype);
        }
        return null;
    }
}

