/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperationUtils;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditVertexEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditVertexEditingProvider.class);
    public static final String KEY_INSERT_VERTEX = "+";
    public static final String KEY_REMOVE_VERTEX = "-";
    private final int TOLERANCE_PIXELS = 3;
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter vertexSelectionPointParameter;
    private final EditingServiceParameter actionParameter;
    private FeatureSelection selection;
    private Point selectedVertex;
    private int selectedIndex = -1;
    private Point pointToMove;
    private String action;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private List<Feature> selectedFeatures;

    public EditVertexEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "uniqueselection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.vertexSelectionPointParameter = new DefaultEditingServiceParameter("selectvertex", "selectvertex", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE});
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        DefaultEditingServiceParameterOptions options = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation("insert_vertex"), (Object)KEY_INSERT_VERTEX, KEY_INSERT_VERTEX).add(i18nManager.getTranslation("remove_vertex"), (Object)KEY_REMOVE_VERTEX, KEY_REMOVE_VERTEX);
        String message = this.getProviderServices().makeConsoleMessage("new_position", (EditingServiceParameterOptions)options);
        this.actionParameter = new DefaultEditingServiceParameter("_point_options", message, (EditingServiceParameterOptions)options, null, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.OPTION}).setDataType(8);
    }

    public EditingServiceParameter next() {
        if (this.selection == null) {
            return this.selectionParameter;
        }
        if (this.selectedVertex == null) {
            return this.vertexSelectionPointParameter;
        }
        if (this.action == null && this.pointToMove == null) {
            this.actionParameter.setDefaultValue((Object)this.selectedVertex);
            return this.actionParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol selectedVertexSymbolEditing = editingProviderManager.getSymbol("selected-vertex-symbol-editing");
        ISymbol editedVertexSymbolEditing = editingProviderManager.getSymbol("edited-vertex-symbol-editing");
        Color colorToTextSymbol = Color.BLACK;
        if (selectedVertexSymbolEditing != null) {
            colorToTextSymbol = selectedVertexSymbolEditing.getColor();
        }
        drawingStatus.setPreviewSymbol(this.getPreviewSymbol(this.getCurrentFeature()));
        double translationForTextSymbol = this.mapContext.getViewPort().toMapDistance(8);
        double tolerance = this.mapContext.getViewPort().toMapDistance(3);
        try {
            if (this.selection == null) {
                List<Point> vertexesList;
                Geometry geometry = this.getNearestGeometry(mousePosition);
                if (geometry != null && (vertexesList = this.getVertexesList(geometry)) != null) {
                    int i = 0;
                    for (Point point : vertexesList) {
                        drawingStatus.addStatus((Geometry)point, selectedVertexSymbolEditing, "");
                        Point pointToText = point.cloneGeometry();
                        pointToText.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, translationForTextSymbol, 0.0));
                        drawingStatus.addStatus((Geometry)pointToText, (ISymbol)this.getTextSymbol(colorToTextSymbol), String.valueOf(i++));
                    }
                }
            } else {
                Geometry selectedGeometry = this.getSelectedGeometry();
                if (this.selectedVertex == null) {
                    List<Point> vertexesList = this.getVertexesList(selectedGeometry);
                    Point vertex = this.getVertex(selectedGeometry, mousePosition, tolerance);
                    if (vertexesList != null) {
                        int i = 0;
                        int selectedIndex = -1;
                        for (Point point : vertexesList) {
                            Point pointToText = point.cloneGeometry();
                            pointToText.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, translationForTextSymbol, 0.0));
                            if (vertex != null && vertex.equals(point)) {
                                if (selectedIndex < 0) {
                                    selectedIndex = i++;
                                    continue;
                                }
                                ++i;
                                continue;
                            }
                            drawingStatus.addStatus((Geometry)point, selectedVertexSymbolEditing, "");
                            drawingStatus.addStatus((Geometry)pointToText, (ISymbol)this.getTextSymbol(colorToTextSymbol), String.valueOf(i++));
                        }
                        if (selectedIndex >= 0) {
                            Point pointToText = vertex.cloneGeometry();
                            pointToText.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, translationForTextSymbol, 0.0));
                            drawingStatus.addStatus((Geometry)vertex, editedVertexSymbolEditing, "");
                            drawingStatus.addStatus((Geometry)pointToText, (ISymbol)this.getTextSymbol(colorToTextSymbol), this.createInfoPointMessage(vertex, selectedIndex));
                        }
                    }
                } else {
                    List<Point> vertexesList = this.getVertexesList(selectedGeometry);
                    if (vertexesList != null) {
                        int i = 0;
                        if (this.selectedIndex < 0) {
                            for (Point point : vertexesList) {
                                Point pointToText = point.cloneGeometry();
                                pointToText.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, translationForTextSymbol, 0.0));
                                if (this.selectedVertex.equals(point)) {
                                    if (this.selectedIndex < 0) {
                                        this.selectedIndex = i++;
                                        continue;
                                    }
                                    ++i;
                                    continue;
                                }
                                drawingStatus.addStatus((Geometry)point, selectedVertexSymbolEditing, "");
                                drawingStatus.addStatus((Geometry)pointToText, (ISymbol)this.getTextSymbol(colorToTextSymbol), String.valueOf(i++));
                            }
                        }
                        if (this.selectedIndex >= 0) {
                            Point pointToText = this.selectedVertex.cloneGeometry();
                            pointToText.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, translationForTextSymbol, 0.0));
                            drawingStatus.addStatus((Geometry)this.selectedVertex, editedVertexSymbolEditing, "");
                            drawingStatus.addStatus((Geometry)pointToText, (ISymbol)this.getTextSymbol(colorToTextSymbol), this.createInfoPointMessage(pointToText, this.selectedIndex));
                            Point newPosition = this.selectedVertex.cloneGeometry();
                            newPosition.setX(mousePosition.getX());
                            newPosition.setY(mousePosition.getY());
                            Geometry modifiedGeometry = this.getModifiedGeometry(selectedGeometry, this.selectedIndex, newPosition);
                            this.addToDrawingStatus(drawingStatus, modifiedGeometry);
                            drawingStatus.addStatus((Geometry)mousePosition, selectedVertexSymbolEditing, "");
                            pointToText = this.selectedVertex.cloneGeometry();
                            pointToText.setX(mousePosition.getX());
                            pointToText.setY(mousePosition.getY());
                            pointToText.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, translationForTextSymbol, 0.0));
                            drawingStatus.addStatus((Geometry)pointToText, (ISymbol)this.getTextSymbol(colorToTextSymbol), this.createInfoPointMessage(pointToText, this.selectedIndex));
                        }
                    }
                }
            }
        }
        catch (BaseException e) {
            throw new DrawServiceException((Throwable)e);
        }
        return drawingStatus;
    }

    private String createInfoPointMessage(Point point, int index) throws GeometryOperationNotSupportedException, GeometryOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append(index);
        builder.append(" ");
        builder.append("(");
        for (int i = 0; i < point.getDimension() - 1; ++i) {
            builder.append(point.getCoordinateAt(i));
            builder.append(" , ");
        }
        builder.append(point.getCoordinateAt(point.getDimension() - 1));
        builder.append(")");
        return builder.toString();
    }

    private void addToDrawingStatus(DefaultDrawingStatus drawingStatus, Geometry geometry) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive primitive;
        EditVertexOperation operation;
        if (geometry instanceof MultiPrimitive) {
            MultiPrimitive aggregate = (MultiPrimitive)geometry;
            for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                Primitive primitive2 = aggregate.getPrimitiveAt(i);
                EditVertexOperation operation2 = EditVertexOperationUtils.getOperation(primitive2);
                if (operation2 == null) continue;
                operation2.addToDrawingStatus(drawingStatus, primitive2);
            }
        } else if (geometry instanceof Primitive && (operation = EditVertexOperationUtils.getOperation(primitive = (Primitive)geometry)) != null) {
            operation.addToDrawingStatus(drawingStatus, primitive);
        }
    }

    private Geometry getModifiedGeometry(Geometry geometry, int index, Point newPosition) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive primitive;
        EditVertexOperation operation;
        if (geometry instanceof MultiPrimitive) {
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            MultiPrimitive aggregate = (MultiPrimitive)geometry;
            GeometryType geometryType = aggregate.getGeometryType();
            MultiPrimitive newAggregate = (MultiPrimitive)geometryManager.create(geometryType.getType(), geometryType.getSubType());
            for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                Primitive primitive2 = aggregate.getPrimitiveAt(i);
                EditVertexOperation operation2 = EditVertexOperationUtils.getOperation(primitive2);
                if (operation2 == null) continue;
                int numVertexes = operation2.getNumVertex(primitive2);
                if (index > -1 && index < numVertexes) {
                    Geometry modifiedPrimitive = operation2.moveVertex(primitive2, index, newPosition);
                    newAggregate.addPrimitive((Primitive)modifiedPrimitive);
                    index = -1;
                    continue;
                }
                index -= numVertexes;
                newAggregate.addPrimitive((Primitive)primitive2.cloneGeometry());
            }
            return newAggregate;
        }
        if (geometry instanceof Primitive && (operation = EditVertexOperationUtils.getOperation(primitive = (Primitive)geometry)) != null) {
            return operation.moveVertex(primitive, index, newPosition);
        }
        return null;
    }

    private Geometry getInsertVertexGeometry(Geometry geometry, int index) throws CreateGeometryException {
        Primitive primitive;
        EditVertexOperation operation;
        if (geometry instanceof MultiPrimitive) {
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            MultiPrimitive aggregate = (MultiPrimitive)geometry;
            GeometryType geometryType = aggregate.getGeometryType();
            MultiPrimitive newAggregate = (MultiPrimitive)geometryManager.create(geometryType.getType(), geometryType.getSubType());
            for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                Primitive primitive2 = aggregate.getPrimitiveAt(i);
                EditVertexOperation operation2 = EditVertexOperationUtils.getOperation(primitive2);
                if (operation2 == null) continue;
                int numVertexes = operation2.getNumVertex(primitive2);
                if (operation2.canInsertVertex(primitive2, index) && index > -1 && index < numVertexes) {
                    Geometry modifiedPrimitive = operation2.insertVertex(primitive2, index);
                    newAggregate.addPrimitive((Primitive)modifiedPrimitive);
                    index = -1;
                    continue;
                }
                index -= numVertexes;
                newAggregate.addPrimitive((Primitive)primitive2.cloneGeometry());
            }
            return newAggregate;
        }
        if (geometry instanceof Primitive && (operation = EditVertexOperationUtils.getOperation(primitive = (Primitive)geometry)) != null) {
            return operation.insertVertex(primitive, index);
        }
        return null;
    }

    private Geometry getRemovedVertexGeometry(Geometry geometry, int index) throws CreateGeometryException {
        Primitive primitive;
        EditVertexOperation operation;
        if (geometry instanceof MultiPrimitive) {
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            MultiPrimitive aggregate = (MultiPrimitive)geometry;
            GeometryType geometryType = aggregate.getGeometryType();
            MultiPrimitive newAggregate = (MultiPrimitive)geometryManager.create(geometryType.getType(), geometryType.getSubType());
            for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                Primitive primitive2 = aggregate.getPrimitiveAt(i);
                EditVertexOperation operation2 = EditVertexOperationUtils.getOperation(primitive2);
                if (operation2 == null) continue;
                int numVertexes = operation2.getNumVertex(primitive2);
                if (index > -1 && index < numVertexes) {
                    Geometry modifiedPrimitive = operation2.removeVertex(primitive2, index);
                    newAggregate.addPrimitive((Primitive)modifiedPrimitive);
                    index = -1;
                    continue;
                }
                index -= numVertexes;
                newAggregate.addPrimitive((Primitive)primitive2.cloneGeometry());
            }
            return newAggregate;
        }
        if (geometry instanceof Primitive && (operation = EditVertexOperationUtils.getOperation(primitive = (Primitive)geometry)) != null) {
            return operation.removeVertex(primitive, index);
        }
        return null;
    }

    private ISimpleTextSymbol getTextSymbol(Color color) {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(12.0);
        textSymbol.setColor(color);
        return textSymbol;
    }

    public void stop() throws StopServiceException {
        this.selection = null;
        this.selectedVertex = null;
        this.pointToMove = null;
        this.action = null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        parameters.add(this.vertexSelectionPointParameter);
        parameters.add(this.actionParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        Primitive primitive;
        List<Point> vertexesList;
        Geometry selectedGeometry;
        if (parameter == this.selectionParameter) {
            if (!(value instanceof FeatureSelection)) return;
            FeatureSelection featureSelection = (FeatureSelection)value;
            if (featureSelection.getSelectedCount() != 1L) throw new InvalidEntryException(null);
            this.selection = featureSelection;
            return;
        }
        try {
            selectedGeometry = this.getSelectedGeometry();
        }
        catch (DataException e1) {
            throw new InvalidEntryException((Throwable)e1);
        }
        if (parameter == this.vertexSelectionPointParameter) {
            List<Point> vertexesList2;
            if (value instanceof Point) {
                Point point = (Point)value;
                double tolerance = this.mapContext.getViewPort().toMapDistance(3);
                try {
                    this.selectedVertex = this.getVertex(selectedGeometry, point, tolerance);
                    this.selectedIndex = this.getSelectedIndex(this.getVertexesList(selectedGeometry));
                    return;
                }
                catch (BaseException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
            if (!(value instanceof Double)) return;
            Double index = (Double)value;
            if (index != (double)Math.round(index)) {
                throw new InvalidEntryException(null);
            }
            try {
                vertexesList2 = this.getVertexesList(selectedGeometry);
            }
            catch (BaseException e) {
                throw new InvalidEntryException((Throwable)e);
            }
            if (index >= (double)vertexesList2.size()) {
                throw new InvalidEntryException(null);
            }
            this.selectedIndex = index.intValue();
            this.selectedVertex = vertexesList2.get(this.selectedIndex);
            return;
        }
        if (parameter != this.actionParameter) return;
        if (value instanceof Point) {
            Point valuePoint = (Point)value;
            this.pointToMove = this.selectedVertex.cloneGeometry();
            for (int i = 0; i < valuePoint.getDimension(); ++i) {
                this.pointToMove.setCoordinateAt(i, valuePoint.getCoordinateAt(i));
            }
            return;
        }
        if (!(value instanceof String)) return;
        try {
            vertexesList = this.getVertexesList(selectedGeometry);
        }
        catch (BaseException e) {
            throw new InvalidEntryException((Throwable)e);
        }
        EditVertexOperation operation = null;
        if (vertexesList == null) return;
        if (selectedGeometry instanceof MultiPrimitive) {
            if (this.selectedIndex < 0) {
                MultiPrimitive aggregate = (MultiPrimitive)selectedGeometry;
                boolean found = false;
                for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                    primitive = aggregate.getPrimitiveAt(i);
                    operation = EditVertexOperationUtils.getOperation(primitive);
                    if (operation != null) {
                        int numVertexes = operation.getNumVertex(primitive);
                        if (primitive instanceof OrientablePrimitive) {
                            OrientablePrimitive orientable = (OrientablePrimitive)primitive;
                            for (int j = 0; j < numVertexes; ++j) {
                                if (!this.selectedVertex.equals(orientable.getVertex(j))) continue;
                                this.selectedIndex = j;
                                found = true;
                                break;
                            }
                        }
                    }
                    if (!found) {
                        continue;
                    }
                    break;
                }
            }
        } else if (selectedGeometry instanceof Primitive) {
            primitive = (Primitive)selectedGeometry;
            operation = EditVertexOperationUtils.getOperation(primitive);
            if (this.selectedIndex < 0 && operation != null) {
                int numVertexes = operation.getNumVertex(primitive);
                if (primitive instanceof OrientablePrimitive) {
                    OrientablePrimitive orientable = (OrientablePrimitive)primitive;
                    for (int j = 0; j < numVertexes; ++j) {
                        if (!this.selectedVertex.equals(orientable.getVertex(j))) continue;
                        this.selectedIndex = j;
                        break;
                    }
                }
            }
        }
        int auxSelectedIndex = this.selectedIndex;
        String str = (String)parameter.getOptions2().getValue(value, parameter.getDefaultValue());
        if (!StringUtils.equalsIgnoreCase((String)str, (String)KEY_INSERT_VERTEX) && !StringUtils.equalsIgnoreCase((String)str, (String)KEY_REMOVE_VERTEX)) return;
        if (selectedGeometry instanceof MultiPrimitive) {
            MultiPrimitive aggregate = (MultiPrimitive)selectedGeometry;
            for (int i = 0; i < aggregate.getPrimitivesNumber() && (operation = EditVertexOperationUtils.getOperation(primitive = aggregate.getPrimitiveAt(i))) != null; ++i) {
                int numVertexes = operation.getNumVertex(primitive);
                if (auxSelectedIndex >= numVertexes) {
                    auxSelectedIndex -= numVertexes;
                    continue;
                }
                int primitiveSelectedIndex = auxSelectedIndex;
                if (!(primitive instanceof OrientablePrimitive)) break;
                OrientablePrimitive orientable = (OrientablePrimitive)primitive;
                if (StringUtils.equalsIgnoreCase((String)str, (String)KEY_INSERT_VERTEX)) {
                    if (!operation.canInsertVertex((Primitive)orientable, primitiveSelectedIndex)) {
                        throw new InvalidEntryException(null);
                    }
                    try {
                        operation.insertVertex((Primitive)orientable, primitiveSelectedIndex);
                    }
                    catch (CreateGeometryException e) {
                        throw new InvalidEntryException((Throwable)e);
                    }
                }
                if (!StringUtils.equalsIgnoreCase((String)str, (String)KEY_REMOVE_VERTEX)) break;
                if (!operation.canRemoveVertex((Primitive)orientable, primitiveSelectedIndex)) {
                    throw new InvalidEntryException(null);
                }
                try {
                    operation.removeVertex((Primitive)orientable, primitiveSelectedIndex);
                    break;
                }
                catch (CreateGeometryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        } else if (selectedGeometry instanceof Primitive) {
            primitive = (Primitive)selectedGeometry;
            if (StringUtils.equalsIgnoreCase((String)str, (String)KEY_INSERT_VERTEX)) {
                if (!operation.canInsertVertex(primitive, this.selectedIndex)) {
                    throw new InvalidEntryException(null);
                }
                try {
                    operation.insertVertex(primitive, this.selectedIndex);
                }
                catch (CreateGeometryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
            if (StringUtils.equalsIgnoreCase((String)str, (String)KEY_REMOVE_VERTEX)) {
                if (!operation.canRemoveVertex(primitive, this.selectedIndex)) {
                    throw new InvalidEntryException(null);
                }
                try {
                    operation.removeVertex(primitive, this.selectedIndex);
                }
                catch (CreateGeometryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
        this.action = str;
    }

    private Point getVertex(Geometry geometry, Point point, double tolerance) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        List<Point> vertexesList = this.getVertexesList(geometry);
        double min = Double.POSITIVE_INFINITY;
        Point vertex = null;
        if (vertexesList != null) {
            for (Point point2 : vertexesList) {
                double distance = this.getDistance(point, point2);
                if (!(distance <= tolerance) || !(distance < min)) continue;
                vertex = point2;
                min = distance;
            }
        }
        return vertex;
    }

    private double getDistance(Point p1, Point p2) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (p1.getDimension() == p2.getDimension()) {
            return p1.distance((Geometry)p2);
        }
        Point auxP1 = geomManager.createPoint(p1.getX(), p1.getY(), 0);
        Point auxP2 = geomManager.createPoint(p2.getX(), p2.getY(), 0);
        return auxP1.distance((Geometry)auxP2);
    }

    private List<Point> getVertexesList(Geometry geometry) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive primitive;
        EditVertexOperation operation;
        if (geometry instanceof MultiPrimitive) {
            MultiPrimitive aggregate = (MultiPrimitive)geometry;
            ArrayList<Point> vertexesList = new ArrayList<Point>();
            for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                Primitive primitive2 = aggregate.getPrimitiveAt(i);
                EditVertexOperation operation2 = EditVertexOperationUtils.getOperation(primitive2);
                if (operation2 == null) continue;
                vertexesList.addAll(operation2.getVertexesList(primitive2));
            }
            return vertexesList;
        }
        if (geometry instanceof Primitive && (operation = EditVertexOperationUtils.getOperation(primitive = (Primitive)geometry)) != null) {
            List<Point> vertexesList = operation.getVertexesList(primitive);
            return vertexesList;
        }
        return null;
    }

    private FeatureSet getGeometryByBuffer(Geometry buffer) throws DataException {
        FeatureQuery queryByGeometry = this.featureStore.createFeatureQuery();
        IProjection defaultSRS = this.featureStore.getDefaultFeatureType().getDefaultSRS();
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(buffer, defaultSRS, this.featureStore);
        queryByGeometry.setFilter(iee);
        queryByGeometry.setAttributeNames(null);
        return this.featureStore.getFeatureSet(queryByGeometry);
    }

    private Geometry getNearestGeometry(Point point) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException {
        double tolerance = this.mapContext.getViewPort().toMapDistance(3);
        Geometry buffer = point.buffer(tolerance);
        FeatureSet featureSet = this.getGeometryByBuffer(buffer);
        double min = Double.POSITIVE_INFINITY;
        Geometry geometry = null;
        DisposableIterator iterator = featureSet.fastIterator();
        while (iterator.hasNext()) {
            Feature feat = (Feature)iterator.next();
            double distance = point.distance(feat.getDefaultGeometry());
            if (!(distance < min)) continue;
            geometry = feat.getDefaultGeometry();
            min = distance;
        }
        iterator.dispose();
        return geometry;
    }

    private Geometry getSelectedGeometry() throws DataException {
        Geometry selectedGeometry = null;
        if (this.selection != null && this.selection.getSelectedCount() == 1L) {
            DisposableIterator it = this.selection.fastIterator();
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                selectedGeometry = feature.getDefaultGeometry();
            }
            it.dispose();
        }
        return selectedGeometry;
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        block17: {
            if (this.selection != null) {
                try {
                    Geometry selectedGeometry = this.getSelectedGeometry();
                    List<Point> vertexesList = this.getVertexesList(selectedGeometry);
                    if (vertexesList == null) break block17;
                    if (this.selectedIndex < 0) {
                        this.selectedIndex = this.getSelectedIndex(vertexesList);
                    }
                    Geometry modifiedGeometry = null;
                    if (this.pointToMove != null) {
                        if (this.selectedIndex >= 0) {
                            modifiedGeometry = this.getModifiedGeometry(selectedGeometry, this.selectedIndex, this.pointToMove);
                        }
                    } else if (this.action != null) {
                        if (this.action.equalsIgnoreCase(KEY_INSERT_VERTEX)) {
                            modifiedGeometry = this.getInsertVertexGeometry(selectedGeometry, this.selectedIndex);
                        } else if (this.action.equalsIgnoreCase(KEY_REMOVE_VERTEX)) {
                            modifiedGeometry = this.getRemovedVertexGeometry(selectedGeometry, this.selectedIndex);
                        }
                    }
                    DisposableIterator it = null;
                    try {
                        it = this.selection.fastIterator();
                        while (it.hasNext()) {
                            Feature feature = (Feature)it.next();
                            EditableFeature editableFeature = feature.getEditable();
                            editableFeature.setDefaultGeometry(modifiedGeometry);
                            this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
                        }
                    }
                    catch (BaseException e) {
                        throw new FinishServiceException((Throwable)e);
                    }
                    finally {
                        DisposeUtils.disposeQuietly((Disposable)it);
                    }
                }
                catch (BaseException e) {
                    throw new FinishServiceException((Throwable)e);
                }
            }
        }
    }

    private int getSelectedIndex(List<Point> vertexesList) {
        int theSelectedIndex = -1;
        if (vertexesList != null) {
            int i = 0;
            if (this.selectedVertex != null) {
                for (Point point : vertexesList) {
                    if (this.selectedVertex.equals(point)) {
                        theSelectedIndex = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        return theSelectedIndex;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        if (this.featureStore != null) {
            try {
                FeatureSelection selected = this.featureStore.getFeatureSelection();
                long selectedCount = selected.getSelectedCount();
                if (selectedCount == 1L) {
                    this.selection = selected;
                } else {
                    selected.deselectAll();
                }
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
        }
    }

    public String getName() {
        return "modify-edit-vertex";
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.actionParameter) {
            return this.action;
        }
        if (parameter == this.selectionParameter) {
            return this.selection;
        }
        if (parameter == this.vertexSelectionPointParameter) {
            return this.selectedVertex;
        }
        return null;
    }

    public Object getValue(EditingServiceParameter parameter, EditingServiceParameter.TYPE type) {
        if (parameter == this.actionParameter) {
            return this.action;
        }
        if (parameter == this.selectionParameter) {
            return this.selection;
        }
        if (parameter == this.vertexSelectionPointParameter) {
            if (type == EditingServiceParameter.TYPE.POSITION) {
                return this.selectedVertex;
            }
            if (this.selectedIndex < 0) {
                return null;
            }
            return this.selectedIndex;
        }
        return null;
    }

    private Feature getCurrentFeature() {
        return this.selection.first();
    }
}

