/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex.operation;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Circumference;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.EllipticArc;
import org.gvsig.fmap.geom.primitive.FilledSpline;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.PeriEllipse;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditVertexOperationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditVertexOperationUtils.class);
    private static final Map<Integer, EditVertexOperation> operations = new HashMap<Integer, EditVertexOperation>();

    private EditVertexOperationUtils() {
    }

    public static void register(EditVertexOperation operation, int geometryType) {
        operations.put(geometryType, operation);
    }

    public static EditVertexOperation getOperation(Primitive geom) {
        Integer type = geom.getGeometryType().getType();
        if (EditVertexOperationUtils.isPolygon((Geometry)geom)) {
            type = 19;
        } else if (EditVertexOperationUtils.isLine((Geometry)geom)) {
            type = 18;
        }
        EditVertexOperation operation = operations.get(type);
        return operation;
    }

    private static boolean isPolygon(Geometry geometry) {
        if (!(geometry instanceof Surface)) {
            return false;
        }
        return EditVertexOperationUtils.isLineOrPolygon(geometry);
    }

    private static boolean isLine(Geometry geometry) {
        if (!(geometry instanceof Curve)) {
            return false;
        }
        return EditVertexOperationUtils.isLineOrPolygon(geometry);
    }

    private static boolean isLineOrPolygon(Geometry geometry) {
        if (geometry instanceof Ellipse) {
            return false;
        }
        if (geometry instanceof EllipticArc) {
            return false;
        }
        if (geometry instanceof Circle) {
            return false;
        }
        if (geometry instanceof FilledSpline) {
            return false;
        }
        if (geometry instanceof Arc) {
            return false;
        }
        if (geometry instanceof Spline) {
            return false;
        }
        if (geometry instanceof Circumference) {
            return false;
        }
        return !(geometry instanceof PeriEllipse);
    }

    public static void setVertex(OrientablePrimitive geom, int index, Point p) {
        block6: {
            block5: {
                if (index >= geom.getNumVertices()) break block5;
                Point point = geom.getVertex(index);
                int min = p.getDimension() < point.getDimension() ? p.getDimension() : point.getDimension();
                for (int i = 0; i < min; ++i) {
                    point.setCoordinateAt(i, p.getCoordinateAt(i));
                }
                break block6;
            }
            if (!(geom instanceof Surface)) break block6;
            Surface sgeom = (Surface)geom;
            int count = 0;
            int dif = index - geom.getNumVertices();
            for (int i = 0; i < sgeom.getNumInteriorRings(); ++i) {
                Ring ring = sgeom.getInteriorRing(i);
                for (int ri = 0; ri < ring.getNumVertices(); ++ri) {
                    if (count == dif) {
                        Point point = ring.getVertex(ri);
                        int min = p.getDimension() < point.getDimension() ? p.getDimension() : point.getDimension();
                        for (int vri = 0; vri < min; ++vri) {
                            point.setCoordinateAt(vri, p.getCoordinateAt(vri));
                        }
                        return;
                    }
                    ++count;
                }
            }
        }
    }
}

