/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import java.io.File;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.PersonalDatabaseServerExplorerFactory;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.h2.H2SpatialExplorerParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialHelper;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCServerExplorerFactory;

public class H2SpatialExplorerFactory
extends JDBCServerExplorerFactory
implements PersonalDatabaseServerExplorerFactory {
    public H2SpatialExplorerFactory() {
        super("H2Spatial", "H2Spatial");
    }

    public JDBCServerExplorer create(DataServerExplorerParameters parameters, DataServerExplorerProviderServices providerServices) throws InitializeException {
        H2SpatialHelper helper = new H2SpatialHelper((JDBCConnectionParameters)parameters);
        JDBCServerExplorer server = helper.createServerExplorer((JDBCServerExplorerParameters)parameters, providerServices);
        return server;
    }

    public JDBCServerExplorerParameters createParameters() {
        H2SpatialExplorerParameters params = new H2SpatialExplorerParameters();
        return params;
    }

    public String[] getPossibleExtensions(String extension) {
        String[] extensions = new String[12];
        extensions[0] = "mv.db";
        extensions[1] = "trace.db";
        for (int i = 2; i < extensions.length; ++i) {
            extensions[i] = "mv.db." + (i - 1) + ".part";
        }
        return extensions;
    }

    public File[] getPossibleFiles(File dbfile) {
        return H2SpatialUtils.getH2Files(dbfile);
    }

    public boolean existsdb(File dbfile) {
        return H2SpatialUtils.existsH2db(dbfile);
    }

    public boolean removedb(File dbfile) {
        return H2SpatialUtils.removeH2db(dbfile);
    }

    public File normalizeFile(File dbfile) {
        return H2SpatialUtils.normalizeH2File(dbfile);
    }

    public File removeExtension(File dbfile) {
        return new File(H2SpatialUtils.removeH2FileNameExtension(dbfile.getPath()));
    }

    public boolean isServerModeSupported() {
        return true;
    }

    public void serverStop() {
        H2SpatialUtils.server_stop();
    }

    public void serverStart(Object ... args) {
        H2SpatialUtils.server_start();
    }

    public void serverSetEnabled(boolean enabled) {
        H2SpatialUtils.set_enable_server(enabled);
    }

    public boolean serverIsEnabled() {
        return H2SpatialUtils.is_enable_server();
    }

    public boolean serverIsStarted() {
        return H2SpatialUtils.is_server_started();
    }
}

