/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.postgresql.dal;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.postgresql.dal.PostgreSQLConnectionParameters;
import org.gvsig.postgresql.dal.PostgreSQLHelper;

public class PostgreSQLConnectionParametersHelper {
    private final JDBCConnectionParameters parameters;

    public PostgreSQLConnectionParametersHelper(JDBCConnectionParameters parameters) {
        this.parameters = parameters;
    }

    public String getUrl() {
        String url = (String)this.getDynValue("url");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = PostgreSQLHelper.getConnectionURL((PostgreSQLConnectionParameters)this.parameters);
            this.setDynValue("url", url);
        }
        return url;
    }

    public void validate() throws ValidateDataParametersException {
        if (this.getDynValue("jdbcdriverclass") == null) {
            this.setDynValue("jdbcdriverclass", "org.postgresql.Driver");
        }
        if (this.getDynValue("port") == null) {
            this.setDynValue("port", 5432);
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.getDynValue("url")))) {
            String url = PostgreSQLHelper.getConnectionURL((PostgreSQLConnectionParameters)this.parameters);
            this.setDynValue("url", url);
        }
    }

    private Object getDynValue(String name) {
        return this.parameters.getDynValue(name);
    }

    private void setDynValue(String name, Object value) {
        this.parameters.setDynValue(name, value);
    }

    public int getMaxIdle() {
        return (Integer)this.getDynValue("maxIdle");
    }

    public boolean getUseSSL() {
        return (Boolean)this.getDynValue("UseSSL");
    }

    public void setUseSSL(boolean v) {
        this.setDynValue("UseSSL", v);
    }

    public int getNetworkTimeout() {
        return (Integer)this.getDynValue("networkTimeout");
    }
}

