/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.postgresql.dal.expressionbuilderformatter;

import java.text.MessageFormat;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;

public class Constant
implements Formatter<ExpressionBuilder.Value> {
    private static final String FORMAT_ST_GEOMFROMWKB = "ST_GeomFromWKB(({0}), ({1}))";
    private static final String FORMAT_ST_GEOMFROMEWKB = "ST_GeomFromEWKB(({0}), ({1}))";
    private static final String FORMAT_ST_GEOMFROMTEXT = "ST_GeomFromText(({0}), ({1}))";
    private final SQLBuilder sqlbuilder;
    private final Formatter<ExpressionBuilder.Value> formatter;

    public Constant(SQLBuilder sqlbuilder, Formatter<ExpressionBuilder.Value> formatter) {
        this.sqlbuilder = sqlbuilder;
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.Constant) {
            Object x = ((ExpressionBuilder.Constant)value).value();
            if (x instanceof byte[]) {
                return true;
            }
            if (x instanceof Geometry) {
                return true;
            }
        }
        return false;
    }

    public String format(ExpressionBuilder.Value constant) {
        Object x = ((ExpressionBuilder.Constant)constant).value();
        GeometryExpressionBuilder builder = this.sqlbuilder.expression();
        if (x instanceof byte[]) {
            return builder.string("\\x" + builder.bytearray_hex((byte[])x)) + "::bytea";
        }
        if (x instanceof Geometry) {
            Geometry geometry = (Geometry)x;
            switch (builder.geometry_support_type()) {
                case EWKB: {
                    return MessageFormat.format(FORMAT_ST_GEOMFROMEWKB, builder.string("\\x" + builder.bytearray_hex(GeometryUtils.toEWKB((Geometry)geometry))) + "::bytea", String.valueOf(builder.srs_id(geometry.getProjection())));
                }
                case WKB: {
                    return MessageFormat.format(FORMAT_ST_GEOMFROMWKB, builder.string("\\x" + builder.bytearray_hex(GeometryUtils.toWKB((Geometry)geometry))) + "::bytea", String.valueOf(builder.srs_id(geometry.getProjection())));
                }
            }
            return MessageFormat.format(FORMAT_ST_GEOMFROMTEXT, builder.string(GeometryUtils.toWKT((Geometry)geometry)), String.valueOf(builder.srs_id(geometry.getProjection())));
        }
        return null;
    }
}

