/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.reproject.app;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.reproject.algorithm.RasterReprojectionSwingLocator;
import org.gvsig.raster.reproject.algorithm.swing.api.RasterReprojectionPanel;
import org.gvsig.raster.reproject.algorithm.swing.api.ReprojectionPanelDataModel;
import org.gvsig.raster.reproject.app.ReprojectListener;
import org.gvsig.raster.reproject.app.ReprojectWindow;
import org.gvsig.raster.reproject.app.ReprojectionPanelDataModelImpl;

public class ReprojectTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem {
    private static ReprojectTocMenuEntry singleton = null;
    private ReprojectListener listener = null;

    public String getGroup() {
        return "GeoRaster";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 10;
    }

    public String getText() {
        return Messages.getText((String)"toc_reproject");
    }

    public static ReprojectTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new ReprojectTocMenuEntry();
        }
        return singleton;
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        return true;
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(17);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayer lyr;
        if (selectedItems.length == 1 && (lyr = selectedItems[0]) instanceof FLyrRaster) {
            ReprojectionPanelDataModelImpl dataModel = new ReprojectionPanelDataModelImpl((FLyrRaster)lyr);
            RasterReprojectionPanel reprojectPanel = RasterReprojectionSwingLocator.getSwingManager().createRasterReprojectPanel((ReprojectionPanelDataModel)dataModel);
            Dimension dimension = reprojectPanel.getComponent().getPreferredSize();
            ReprojectWindow window = new ReprojectWindow(reprojectPanel.getComponent(), Messages.getText((String)"reprojection"), dimension.width, dimension.height);
            this.listener = new ReprojectListener(lyr, dataModel, window, reprojectPanel);
            reprojectPanel.addButtonsListener((ActionListener)this.listener);
            PluginServices.getMDIManager().addCentredWindow((IWindow)window);
        }
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"tools-raster-reproject");
    }
}

