/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.tile.impl.pool;

import java.util.LinkedList;
import java.util.Queue;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.pool.AtomicTask;
import org.gvsig.raster.cache.tile.pool.TilePipe;

public class TilePipeImpl
implements TilePipe {
    private boolean isEmpty = true;
    private Queue<AtomicTask> buffer = new LinkedList<AtomicTask>();
    private boolean debug = false;

    public TilePipeImpl() {
        this.debug = false;
    }

    public TilePipeImpl(boolean debug) {
        this.debug = debug;
    }

    public synchronized void setAtomicTask(AtomicTask task) {
        if (task != null) {
            this.buffer.add(task);
        }
        this.isEmpty = false;
        if (this.debug) {
            System.err.println("Setting tile " + ((Tile)task).getCol() + " " + ((Tile)task).getRow());
        }
        this.notify();
    }

    public synchronized AtomicTask getAtomicTask() {
        if (this.debug) {
            System.out.println("0-Getting tile ");
        }
        while (this.isEmpty) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        AtomicTask task = this.buffer.poll();
        if (this.debug) {
            System.out.println("1-Getting tile " + ((Tile)task).getCol() + " " + ((Tile)task).getRow());
        }
        if (this.getSize() == 0) {
            this.isEmpty = true;
        }
        return task;
    }

    public synchronized int getSize() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Queue<AtomicTask> queue = this.buffer;
        synchronized (queue) {
            this.buffer.clear();
        }
    }
}

