/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.reproject;

import es.unex.sextante.core.Sextante;
import java.util.Iterator;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class ReprojectOperation
extends GeometryOperation {
    private ICoordTrans transf = null;

    public ReprojectOperation(IProjection srcProj, IProjection dstProj, AbstractSextanteGeoProcess p) {
        super(p);
        this.transf = srcProj.getCT(dstProj);
    }

    public EditableFeature invoke(Geometry g, Feature feature) {
        List geomList = feature.getGeometries();
        try {
            if (geomList == null) {
                Geometry geom = feature.getDefaultGeometry();
                geom.reProject(this.transf);
                EditableFeature editFeat = feature.getEditable();
                editFeat.setDefaultGeometry(geom);
                this.persister.addFeature(feature, geom);
            } else {
                Iterator itGeom = geomList.iterator();
                EditableFeature editFeat = null;
                boolean first = true;
                int nGeom = 0;
                while (itGeom.hasNext()) {
                    Geometry geom = (Geometry)itGeom.next();
                    geom.reProject(this.transf);
                    editFeat = feature.getEditable();
                    editFeat.setGeometry(nGeom, geom);
                    ++nGeom;
                    if (first) {
                        this.persister.addFeature((Feature)editFeat, geom);
                        continue;
                    }
                    this.persister.addGeometryToExistingFeature(editFeat, geom);
                }
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (CreateGeometryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return this.lastEditFeature;
    }

    public void invoke(Geometry g, EditableFeature featureInput) {
    }
}

