/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.swing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.text.JTextComponent;
import org.gvsig.app.gui.labeling.LabelClassEditor;
import org.gvsig.app.gui.labeling.LabelClassEditorFactory;
import org.gvsig.app.gui.styling.TypeSymbolEditor;
import org.gvsig.app.project.documents.view.legend.gui.ILabelingStrategyPanel;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.ColorTablePainter;
import org.gvsig.gui.ColorTablesFactory;
import org.gvsig.gui.DefaultColorTablesFactory;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.swing.SymbologySwingManager;
import org.gvsig.symbology.swing.SymbologyWindowManager;
import org.gvsig.symbology.swing.impl.DefaultSymbologyWindowManager;
import org.gvsig.symbology.swing.impl.pickercontroller.SymbolPickerController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSymbologySwingManager
implements SymbologySwingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSymbologySwingManager.class);
    private static Map<Integer, List<Class<? extends TypeSymbolEditor>>> symbolEditorRegistry;
    private final SymbologyManager manager;
    private final Map<String, LabelClassEditorFactory> labelClassEditorFactories = new HashMap<String, LabelClassEditorFactory>();
    private I18nManager i18nmanager = null;
    private SymbologyWindowManager windowManager;
    private ColorTablesFactory colorTablesFactory;
    private List<Class<? extends ILegendPanel>> legendEditorRegistry = null;
    private List<Class<? extends ILabelingStrategyPanel>> labelingEditorRegistry = null;
    private List<Action> optionalActionsOfLegendsPanel;

    public DefaultSymbologySwingManager() {
        this.manager = SymbologyLocator.getSymbologyManager();
        this.windowManager = new DefaultSymbologyWindowManager();
        this.colorTablesFactory = new DefaultColorTablesFactory();
        this.legendEditorRegistry = new ArrayList<Class<? extends ILegendPanel>>();
        this.labelingEditorRegistry = new ArrayList<Class<? extends ILabelingStrategyPanel>>();
    }

    public SymbologyManager getManager() {
        return this.manager;
    }

    public String getTranslation(String key) {
        if (this.i18nmanager == null) {
            this.i18nmanager = ToolsLocator.getI18nManager();
        }
        return this.i18nmanager.getTranslation(key);
    }

    public void registerWindowManager(SymbologyWindowManager manager) {
        this.windowManager = manager;
    }

    public SymbologyWindowManager getWindowManager() {
        return this.windowManager;
    }

    public void setColorTablesFactory(ColorTablesFactory factory) {
        this.colorTablesFactory = factory;
    }

    public List<ColorTablePainter> createColorTables() {
        if (this.colorTablesFactory != null) {
            return this.colorTablesFactory.createColorTables();
        }
        return null;
    }

    public ColorTablesFactory getColorTablesFactory() {
        return this.colorTablesFactory;
    }

    public void addSymbolEditorPanel(Class abstractTypeSymbolEditorPanelClass, int shapeType) {
        Class symbolEditor = abstractTypeSymbolEditorPanelClass;
        this.registerSymbolEditor(symbolEditor, shapeType);
    }

    public void registerSymbolEditor(Class<? extends TypeSymbolEditor> symbolEditor, int shapeType) {
        Integer key;
        List<Class<? extends TypeSymbolEditor>> l;
        if (symbolEditorRegistry == null) {
            symbolEditorRegistry = new HashMap<Integer, List<Class<? extends TypeSymbolEditor>>>();
        }
        if ((l = symbolEditorRegistry.get(key = Integer.valueOf(shapeType))) == null) {
            l = new ArrayList<Class<? extends TypeSymbolEditor>>();
        }
        l.add(symbolEditor);
        symbolEditorRegistry.put(key, l);
    }

    public List<Class<? extends TypeSymbolEditor>> getSymbolEditorClassesByGeometryType(GeometryType geometryType) {
        if (symbolEditorRegistry == null) {
            return Collections.emptyList();
        }
        for (int currentType : symbolEditorRegistry.keySet()) {
            if (!geometryType.isTypeOf(currentType)) continue;
            return symbolEditorRegistry.get(currentType);
        }
        return Collections.emptyList();
    }

    public void registerLegendEditor(Class<? extends ILegendPanel> legendEditor) {
        if (this.legendEditorRegistry == null) {
            this.legendEditorRegistry = new ArrayList<Class<? extends ILegendPanel>>();
        }
        if (!this.legendEditorRegistry.contains(legendEditor)) {
            this.legendEditorRegistry.add(legendEditor);
        }
    }

    public List<Class<? extends ILegendPanel>> getLegendEditorClasses() {
        return Collections.unmodifiableList(this.legendEditorRegistry);
    }

    public List<ILegendPanel> getLegendEditors(FLayer layer) {
        ArrayList<ILegendPanel> editors = new ArrayList<ILegendPanel>();
        for (int i = 0; i < this.legendEditorRegistry.size(); ++i) {
            Class<? extends ILegendPanel> legendEditorClass = null;
            try {
                legendEditorClass = this.legendEditorRegistry.get(i);
                ILegendPanel editor = legendEditorClass.newInstance();
                if (!editor.isSuitableFor(layer)) continue;
                editors.add(editor);
                continue;
            }
            catch (Throwable e) {
                LOGGER.warn("Unable to initialize legend editor (" + (legendEditorClass == null ? "NULL" : legendEditorClass.getName()) + ").", e);
            }
        }
        return editors;
    }

    public void registerLabelingEditor(Class<? extends ILabelingStrategyPanel> labelingEditor) {
        if (!this.labelingEditorRegistry.contains(labelingEditor)) {
            this.labelingEditorRegistry.add(labelingEditor);
        }
    }

    public List<ILabelingStrategyPanel> getLabelingEditors() {
        ArrayList<ILabelingStrategyPanel> labelingEditors = new ArrayList<ILabelingStrategyPanel>();
        Iterator<Class<? extends ILabelingStrategyPanel>> it = this.labelingEditorRegistry.iterator();
        while (it.hasNext()) {
            Class<? extends ILabelingStrategyPanel> labelingEditorClass = null;
            try {
                labelingEditorClass = it.next();
                ILabelingStrategyPanel labelingEditor = labelingEditorClass.newInstance();
                labelingEditors.add(labelingEditor);
            }
            catch (Throwable ex) {
                String msg = "Can't create the labeling editor associated to '" + (labelingEditorClass == null ? "NULL" : labelingEditorClass.getName()) + "'.";
                LOGGER.warn(msg, ex);
            }
        }
        return labelingEditors;
    }

    public void registerLabelClassEditor(LabelClassEditorFactory factory) {
        this.labelClassEditorFactories.put(factory.getID().toLowerCase(), factory);
    }

    public Collection<LabelClassEditorFactory> getLabelClassEditorFactories() {
        return Collections.unmodifiableCollection(this.labelClassEditorFactories.values());
    }

    public LabelClassEditorFactory getLabelClassEditorFactory(String id) {
        if (id == null) {
            return null;
        }
        return this.labelClassEditorFactories.get(id.toLowerCase());
    }

    public LabelClassEditorFactory getLabelClassEditorFactory(ILabelClass labelClass) {
        Iterator<LabelClassEditorFactory> it = this.labelClassEditorFactories.values().iterator();
        while (it.hasNext()) {
            LabelClassEditorFactory labelClassEditorFactory = null;
            try {
                labelClassEditorFactory = it.next();
                if (!labelClassEditorFactory.accept(labelClass.getClass())) continue;
                return labelClassEditorFactory;
            }
            catch (Throwable th) {
                LOGGER.warn("Can't check factory '" + (labelClassEditorFactory == null ? "NULL" : labelClassEditorFactory.getName()) + "'.", th);
            }
        }
        return null;
    }

    public LabelClassEditor createLabelClassEditor(ILabelClass labelClass, FeatureStore store) {
        LabelClassEditorFactory f = this.getLabelClassEditorFactory(labelClass);
        if (f == null) {
            return null;
        }
        return f.createEditor(labelClass, store);
    }

    public Iterable<Action> getOptionalActionOfLegendsPanel() {
        if (this.optionalActionsOfLegendsPanel == null) {
            this.optionalActionsOfLegendsPanel = new ArrayList<Action>();
        }
        return this.optionalActionsOfLegendsPanel;
    }

    public void addOptionalActionToLegendsPanel(Action action) {
        if (this.optionalActionsOfLegendsPanel == null) {
            this.optionalActionsOfLegendsPanel = new ArrayList<Action>();
        }
        this.optionalActionsOfLegendsPanel.add(action);
    }

    public PickerController<ISymbol> createSymbolPickerController(JButton btn, ISymbol symbol) {
        return new SymbolPickerController(btn, null, -1, symbol);
    }

    public PickerController<ISymbol> createSymbolPickerController(JButton btnPreview, JTextComponent txtDescription, int geomType, ISymbol symbol) {
        return new SymbolPickerController(btnPreview, txtDescription, geomType, symbol);
    }
}

