/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.parser.sfp0.geometries;

import java.io.IOException;
import org.gvsig.compat.CompatLocator;
import org.gvsig.gpe.prov.gml.parser.GPEDefaultGmlParser;
import org.gvsig.gpe.prov.gml.parser.v2.geometries.DoubleTypeBinding;
import org.gvsig.gpe.prov.gml.utils.GmlTags;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class UpperCornerTypeBinding {
    private String TUPLES_SEPARATOR = "[\n\\s\r\t ]+";
    private String COORDINATES_DECIMAL = ".";
    private IXmlStreamReader parser = null;
    private GPEDefaultGmlParser handler;

    public double[] parse(IXmlStreamReader parser, GPEDefaultGmlParser handler) throws XmlStreamException, IOException {
        boolean endFeature = false;
        this.parser = parser;
        this.handler = handler;
        double[] aCoordinates = null;
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    if (!handler.getQNameComparator().equals(tag, GmlTags.GML_UPPERCORNER)) break;
                    parser.next();
                    String[] coordinates = CompatLocator.getStringUtils().split(parser.getText().trim(), this.TUPLES_SEPARATOR);
                    aCoordinates = new double[3];
                    for (int i = 0; i < coordinates.length; ++i) {
                        aCoordinates[i] = DoubleTypeBinding.parse(coordinates[i], this.COORDINATES_DECIMAL, handler);
                    }
                    if (coordinates.length == 2) {
                        aCoordinates[2] = 0.0;
                        break;
                    }
                    if (coordinates.length == 1) {
                        aCoordinates[1] = 0.0;
                        aCoordinates[2] = 0.0;
                        break;
                    }
                    aCoordinates[0] = 0.0;
                    aCoordinates[1] = 0.0;
                    aCoordinates[2] = 0.0;
                    break;
                }
                case 2: {
                    if (!handler.getQNameComparator().equals(tag, GmlTags.GML_UPPERCORNER)) break;
                    endFeature = true;
                    break;
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
        return aCoordinates;
    }
}

