/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.parser.v2.geometries;

import java.io.IOException;
import java.util.Map;
import org.gvsig.gpe.prov.gml.parser.GPEDefaultGmlParser;
import org.gvsig.gpe.prov.gml.utils.GmlProjectionFactory;
import org.gvsig.gpe.prov.gml.utils.GmlTags;
import org.gvsig.gpe.prov.xml.utils.XMLAttributesIterator;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class GeometryBinding {
    protected String srsName = null;
    protected String id = null;

    public Object parse(IXmlStreamReader parser, GPEDefaultGmlParser handler) throws XmlStreamException, IOException {
        Object geometry = null;
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        switch (currentTag) {
            case 1: {
                geometry = this.parseTag(parser, handler, tag);
            }
        }
        return geometry;
    }

    protected Object parseTag(IXmlStreamReader parser, GPEDefaultGmlParser handler, IQName tag) throws XmlStreamException, IOException {
        Object geometry = null;
        if (handler.getQNameComparator().equals(tag, GmlTags.GML_GEOMETRYPROPERTY)) {
            geometry = handler.getProfile().getGeometryPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_POINTPROPERTY)) {
            geometry = handler.getProfile().getPointPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_LINESTRINGPROPERTY)) {
            geometry = handler.getProfile().getLineStringPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_POLYGONPROPERTY)) {
            geometry = handler.getProfile().getPolygonPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIPOINTPROPERTY)) {
            geometry = handler.getProfile().getMultiPointPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTILINESTRINGPROPERTY)) {
            geometry = handler.getProfile().getMultiLineStringPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIPOLYGONPROPERTY)) {
            geometry = handler.getProfile().getMultiPolygonPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIGEOMETRYPROPERTY)) {
            geometry = handler.getProfile().getMultiGeometryPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_POINTMEMBER)) {
            geometry = handler.getProfile().getPointMemberTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_POINT)) {
            geometry = handler.getProfile().getPointTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_LINESTRINGMEMBER)) {
            geometry = handler.getProfile().getLineStringMemberTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_LINESTRING)) {
            geometry = handler.getProfile().getLineStringTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_LINEARRING)) {
            geometry = handler.getProfile().getLinearRingTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_POLYGONMEMBER)) {
            geometry = handler.getProfile().getPointMemberTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_POLYGON)) {
            geometry = handler.getProfile().getPolygonTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_GEOMETRYMEMBER)) {
            geometry = handler.getProfile().getGeometryMemberTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIPOINT)) {
            geometry = handler.getProfile().getMultiPointTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTILINESTRING)) {
            geometry = handler.getProfile().getMultiLineStringTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIPOLYGON)) {
            geometry = handler.getProfile().getMultiPolygonTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIGEOMETRY)) {
            geometry = handler.getProfile().getMultiGeometryTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_LOCATION) || handler.getQNameComparator().equals(tag, GmlTags.GML_CENTEROF) || handler.getQNameComparator().equals(tag, GmlTags.GML_POSITION)) {
            geometry = handler.getProfile().getPointTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_EDGEOF) || handler.getQNameComparator().equals(tag, GmlTags.GML_CENTERLINEOF)) {
            geometry = handler.getProfile().getLineStringPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_EXTENTOF) || handler.getQNameComparator().equals(tag, GmlTags.GML_COVERAGE)) {
            geometry = handler.getProfile().getPolygonPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTILOCATION) || handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIPOSITION)) {
            geometry = handler.getProfile().getMultiPointPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIEDGEOF) || handler.getQNameComparator().equals(tag, GmlTags.GML_MULTICENTERLINEOF)) {
            geometry = handler.getProfile().getMultiLineStringPropertyTypeBinding().parse(parser, handler);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_MULTIEXTENTOF) || handler.getQNameComparator().equals(tag, GmlTags.GML_MULTICOVERAGE)) {
            geometry = handler.getProfile().getMultiPolygonTypeBinding().parse(parser, handler);
        }
        return geometry;
    }

    protected void setAtributtes(IXmlStreamReader parser, GPEDefaultGmlParser handler) throws XmlStreamException {
        XMLAttributesIterator attributesIteartor = new XMLAttributesIterator(parser);
        Map attributes = attributesIteartor.getAttributes();
        String objId = this.getID(handler, attributes);
        this.id = objId != null ? objId : null;
        String objSrs = this.getSRS(handler, attributes);
        if (objSrs != null) {
            this.srsName = GmlProjectionFactory.fromGMLToGPE(objSrs, handler.getErrorHandler());
        }
    }

    public String getSRS(GPEDefaultGmlParser handler, Map hash) {
        Object objSrs = hash.get(GmlTags.GML_SRS_NAME);
        if (objSrs != null) {
            return (String)objSrs;
        }
        for (IQName name : hash.keySet()) {
            if (!handler.getQNameComparator().equalsWithOutNamespace(name, GmlTags.GML_SRS_NAME)) continue;
            return (String)hash.get(name);
        }
        return null;
    }

    public String getID(GPEDefaultGmlParser handler, Map hash) {
        Object objId = hash.get(GmlTags.GML_GID);
        if (objId != null) {
            return (String)objId;
        }
        for (IQName name : hash.keySet()) {
            if (!handler.getQNameComparator().equalsWithOutNamespace(name, GmlTags.GML_GID)) continue;
            return (String)hash.get(name);
        }
        return null;
    }

    public String getID() {
        return this.id;
    }

    public String getSrs() {
        return this.srsName;
    }
}

