/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.parser.v2.geometries;

import java.io.IOException;
import org.gvsig.gpe.lib.api.parser.ICoordinateIterator;
import org.gvsig.gpe.prov.gml.parser.GPEDefaultGmlParser;
import org.gvsig.gpe.prov.gml.parser.v2.geometries.GeometryBinding;
import org.gvsig.gpe.prov.gml.parser.v2.geometries.InnerBoundaryIsTypeBinding;
import org.gvsig.gpe.prov.gml.parser.v2.geometries.OuterBoundaryIsTypeBinding;
import org.gvsig.gpe.prov.gml.utils.GmlTags;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class PolygonTypeBinding
extends GeometryBinding {
    protected Object polygon = null;

    @Override
    public Object parse(IXmlStreamReader parser, GPEDefaultGmlParser handler) throws XmlStreamException, IOException {
        boolean endFeature = false;
        super.setAtributtes(parser, handler);
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    this.polygon = this.parseTag(parser, handler, tag, this.id, this.srsName);
                    break;
                }
                case 2: {
                    endFeature = this.parseLastTag(parser, handler, tag);
                    if (!endFeature) break;
                    this.polygon = handler.getContentHandler().endPolygon(this.polygon);
                    break;
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
        return this.polygon;
    }

    protected Object parseTag(IXmlStreamReader parser, GPEDefaultGmlParser handler, IQName tag, String id, String srsName) throws XmlStreamException, IOException {
        if (handler.getQNameComparator().equals(tag, GmlTags.GML_OUTERBOUNDARYIS)) {
            OuterBoundaryIsTypeBinding coordinatesBinding = handler.getProfile().getOuterBoundaryIsTypeBinding();
            ICoordinateIterator coordinatesIterator = coordinatesBinding.parse(parser, handler);
            this.polygon = handler.getContentHandler().startPolygon(id, coordinatesIterator, srsName);
        } else if (handler.getQNameComparator().equals(tag, GmlTags.GML_INNERBOUNDARYIS)) {
            InnerBoundaryIsTypeBinding coordinatesBinding = handler.getProfile().getInnerBoundaryIsTypeBinding();
            ICoordinateIterator coordinatesIterator = coordinatesBinding.parse(parser, handler);
            Object innerPolygon = handler.getContentHandler().startInnerPolygon(null, coordinatesIterator, srsName);
            handler.getContentHandler().endInnerPolygon(innerPolygon);
            handler.getContentHandler().addInnerPolygonToPolygon(innerPolygon, this.polygon);
        }
        return this.polygon;
    }

    protected boolean parseLastTag(IXmlStreamReader parser, GPEDefaultGmlParser handler, IQName tag) {
        return handler.getQNameComparator().equals(tag, GmlTags.GML_POLYGON);
    }
}

