/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonObject;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.SupportToExpression;
import org.gvsig.expressionevaluator.SupportToSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.evaluator.EvaluatorFieldsInfo;
import org.gvsig.tools.evaluator.EvaluatorWithDescriptions;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.ListBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseExpressionEvaluator
extends AbstractEvaluator
implements ExpressionEvaluator,
Cloneable,
SupportToExpression,
SupportToSymbolTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseExpressionEvaluator.class);
    private DataSymbolTable dataSymbolTable;
    private SymbolTable symbolTable;
    private Expression expression;
    private EvaluatorWithDescriptions.Description[] availableOperators;
    private EvaluatorWithDescriptions.Description[] availableFunctions;

    public BaseExpressionEvaluator(String source) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        this.symbolTable = manager.createSymbolTable();
        this.dataSymbolTable = new DataSymbolTable();
        this.symbolTable.addSymbolTable(this.dataSymbolTable);
        this.expression = manager.createExpression();
        this.expression.setPhrase(source);
    }

    public BaseExpressionEvaluator(Expression expression) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        this.symbolTable = manager.createSymbolTable();
        this.dataSymbolTable = new DataSymbolTable();
        this.symbolTable.addSymbolTable(this.dataSymbolTable);
        this.expression = expression;
    }

    public String getName() {
        return "Genereric expression";
    }

    public String getDescription() {
        return this.expression.getPhrase();
    }

    @Override
    public String getSQL() {
        return this.expression.getPhrase();
    }

    @Override
    public Expression toExpression() {
        return this.expression;
    }

    @Override
    public SymbolTable toSymbolTable() {
        return this.symbolTable;
    }

    public Object evaluate(EvaluatorData data) throws EvaluatorException {
        this.dataSymbolTable.setData(data);
        Object v = this.expression.execute(this.symbolTable);
        return v;
    }

    public EvaluatorFieldsInfo getFieldsInfo() {
        HashSet names = new HashSet();
        try {
            this.expression.getCode().accept(code -> {
                if (code instanceof Code.Identifier) {
                    Code.Identifier identifier = (Code.Identifier)code;
                    names.add(identifier.name());
                }
            });
            EvaluatorFieldsInfo info = new EvaluatorFieldsInfo();
            for (String name : names) {
                info.addFieldValue(name);
            }
            return info;
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't calculate fields information.", ex);
        }
    }

    public EvaluatorWithDescriptions.Description[] getAvailableOperators() {
        if (this.availableOperators == null) {
            ArrayList<DescriptionAdapter> l = new ArrayList<DescriptionAdapter>();
            for (Function function : this.toSymbolTable()) {
                if (!function.isOperator()) continue;
                l.add(new DescriptionAdapter(function));
            }
            this.availableOperators = l.toArray(new EvaluatorWithDescriptions.Description[l.size()]);
        }
        return this.availableOperators;
    }

    public EvaluatorWithDescriptions.Description[] getAvailableFunctions() {
        if (this.availableFunctions == null) {
            ArrayList<DescriptionAdapter> l = new ArrayList<DescriptionAdapter>();
            for (Function function : this.toSymbolTable()) {
                if (function.isOperator()) continue;
                l.add(new DescriptionAdapter(function));
            }
            this.availableFunctions = l.toArray(new EvaluatorWithDescriptions.Description[l.size()]);
        }
        return this.availableFunctions;
    }

    public Evaluator clone() throws CloneNotSupportedException {
        BaseExpressionEvaluator other = (BaseExpressionEvaluator)super.clone();
        other.expression = this.expression.clone();
        other.availableFunctions = null;
        other.availableOperators = null;
        if (this.dataSymbolTable != null) {
            other.dataSymbolTable = this.dataSymbolTable.clone();
        }
        if (this.symbolTable != null) {
            other.symbolTable = this.symbolTable.clone();
        }
        return other;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("expression", (Persistent)this.expression);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.expression = (Expression)state.get("expression");
        this.availableFunctions = null;
        this.availableOperators = null;
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        this.symbolTable = manager.createSymbolTable();
        this.dataSymbolTable = new DataSymbolTable();
        this.symbolTable.addSymbolTable(this.dataSymbolTable);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("DefaultExpressionEvaluator") == null) {
            DynStruct definition = manager.addDefinition(BaseExpressionEvaluator.class, "DefaultExpressionEvaluator", "DefaultExpressionEvaluator persistence definition", null, null);
            definition.addDynFieldObject("expression").setClassOfValue(Expression.class).setMandatory(false);
        }
    }

    @Override
    public void addSymbolTable(SymbolTable symbolTable) {
        this.symbolTable.addSymbolTable(symbolTable);
    }

    public void fromJson(JsonObject json) {
        this.expression = (Expression)Json.toObject((JsonObject)json, (String)"expression");
        this.availableFunctions = null;
        this.availableOperators = null;
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        this.symbolTable = manager.createSymbolTable();
        this.dataSymbolTable = new DataSymbolTable();
        this.symbolTable.addSymbolTable(this.dataSymbolTable);
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder state = Json.createObjectBuilder();
        state.add("expression", (SupportToJson)this.expression);
        return state;
    }

    private static class DataSymbolTable
    extends AbstractSymbolTable {
        EvaluatorData data;

        public void setData(EvaluatorData data) {
            this.data = data;
        }

        @Override
        public boolean exists(String name) {
            return this.data.hasDataValue(name);
        }

        @Override
        public Object value(String name) {
            return this.data.getDataValue(name);
        }

        @Override
        public Collection<String> localvariables() {
            List names = ListBuilder.create((Iterator)this.data.getDataNames());
            return names;
        }

        @Override
        public DataSymbolTable clone() throws CloneNotSupportedException {
            SymbolTable other = super.clone();
            return (DataSymbolTable)other;
        }
    }

    private static class DescriptionAdapter
    implements EvaluatorWithDescriptions.Description {
        Function function;

        public DescriptionAdapter(Function function) {
            this.function = function;
        }

        public String getName() {
            return this.function.name();
        }

        public String getDescription() {
            return this.function.description();
        }

        public String getTemplate() {
            return this.function.template();
        }

        public int getDataTypeCategories() {
            switch (this.function.group()) {
                case "String": {
                    return 2;
                }
                case "Boolean": {
                    return 8;
                }
                case "Datetime": {
                    return 4;
                }
                case "Numeric": {
                    return 1;
                }
                case "OGC": {
                    return 0;
                }
            }
            return 0;
        }
    }
}

