/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.Cloneable;
import gishur.x.XObject;
import gishur.x2.core.NoninvertibleTransformationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AffineTransformation
implements Cloneable,
Serializable {
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;

    public void setToTranslation(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = d;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = d2;
    }

    public void setTransform(AffineTransformation affineTransformation) {
        this.m00 = affineTransformation.m00;
        this.m01 = affineTransformation.m01;
        this.m02 = affineTransformation.m02;
        this.m10 = affineTransformation.m10;
        this.m11 = affineTransformation.m11;
        this.m12 = affineTransformation.m12;
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
    }

    public double[] deltaTransform(double d, double d2) {
        double[] dArray = new double[]{this.m00 * d + this.m01 * d2, this.m10 * d + this.m11 * d2};
        return dArray;
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray == null || dArray2 == null) {
            return;
        }
        if (n < 0 || n >= dArray.length || n2 < 0 || n2 >= dArray2.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m10;
        double d4 = this.m11;
        while (--n3 >= 0) {
            double d5 = dArray[n++];
            double d6 = dArray[n++];
            dArray2[n2++] = d * d5 + d2 * d6;
            dArray2[n2++] = d3 * d5 + d4 * d6;
        }
    }

    public XObject deltaTransform(XObject xObject) {
        if (xObject == null) {
            return null;
        }
        return xObject.copy().transform_XObject(this.m00, this.m01, 0.0, this.m10, this.m11, 0.0);
    }

    public XObject[] deltaTransform(XObject[] xObjectArray, int n, int n2) {
        if (xObjectArray == null) {
            return null;
        }
        if (n < 0 || n >= xObjectArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        XObject[] xObjectArray2 = new XObject[Math.min(n2, xObjectArray.length - n)];
        int n3 = 0;
        while (n3 < xObjectArray2.length) {
            xObjectArray2[n3] = xObjectArray[n + n3] != null ? xObjectArray[n + n3].copy().transform_XObject(this.m00, this.m01, 0.0, this.m10, this.m11, 0.0) : null;
            ++n3;
        }
        return xObjectArray2;
    }

    public XObject[] deltaTransform(XObject[] xObjectArray) {
        if (xObjectArray == null) {
            return null;
        }
        return this.transform(xObjectArray, 0, xObjectArray.length);
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m11 == 1.0 && this.m01 == 0.0 && this.m10 == 0.0 && this.m02 == 0.0 && this.m12 == 0.0;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public double element(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: 
                    case 1: {
                        return 0.0;
                    }
                    case 2: {
                        return 1.0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void shear(double d, double d2) {
        this.concatenate(1.0, d, 0.0, d2, 1.0, 0.0);
    }

    public void setToRotation(double d) {
        this.m02 = 0.0;
        this.m12 = 0.0;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        if (Math.abs(d2) < 1.0E-15) {
            this.m10 = 0.0;
            this.m01 = 0.0;
            if (d3 < 0.0) {
                this.m11 = -1.0;
                this.m00 = -1.0;
                return;
            }
            this.m11 = 1.0;
            this.m00 = 1.0;
            return;
        }
        if (Math.abs(d3) < 1.0E-15) {
            this.m11 = 0.0;
            this.m00 = 0.0;
            if (d2 < 0.0) {
                this.m01 = 1.0;
                this.m10 = -1.0;
                return;
            }
            this.m01 = -1.0;
            this.m10 = 1.0;
            return;
        }
        this.m00 = d3;
        this.m01 = -d2;
        this.m10 = d2;
        this.m11 = d3;
    }

    public double translateX() {
        return this.m02;
    }

    public void setToRotation(double d, double d2, double d3) {
        this.setToRotation(d);
        double d4 = this.m10;
        double d5 = 1.0 - this.m00;
        this.m02 = d2 * d5 + d3 * d4;
        this.m12 = d3 * d5 - d2 * d4;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    public AffineTransformation createInverse() {
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        if (Math.abs(d) <= Double.MIN_VALUE) {
            throw new NoninvertibleTransformationException("Determinant is " + d);
        }
        return new AffineTransformation(this.m11 / d, -this.m01 / d, (this.m01 * this.m12 - this.m11 * this.m02) / d, -this.m10 / d, this.m00 / d, (this.m10 * this.m02 - this.m00 * this.m12) / d);
    }

    public double determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public double shearY() {
        return this.m10;
    }

    public void concatenate(AffineTransformation affineTransformation) {
        double d = affineTransformation.m00;
        double d2 = affineTransformation.m01;
        double d3 = affineTransformation.m02;
        double d4 = affineTransformation.m10;
        double d5 = affineTransformation.m11;
        double d6 = affineTransformation.m12;
        double d7 = this.m00 * d + this.m01 * d4;
        double d8 = this.m10 * d + this.m11 * d4;
        double d9 = this.m00 * d2 + this.m01 * d5;
        double d10 = this.m10 * d2 + this.m11 * d5;
        double d11 = this.m00 * d3 + this.m01 * d6 + this.m02;
        double d12 = this.m10 * d3 + this.m11 * d6 + this.m12;
        this.m00 = d7;
        this.m01 = d9;
        this.m02 = d11;
        this.m10 = d8;
        this.m11 = d10;
        this.m12 = d12;
    }

    public void concatenate(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.m00 * d + this.m01 * d4;
        double d8 = this.m10 * d + this.m11 * d4;
        double d9 = this.m00 * d2 + this.m01 * d5;
        double d10 = this.m10 * d2 + this.m11 * d5;
        double d11 = this.m00 * d3 + this.m01 * d6 + this.m02;
        double d12 = this.m10 * d3 + this.m11 * d6 + this.m12;
        this.m00 = d7;
        this.m01 = d9;
        this.m02 = d11;
        this.m10 = d8;
        this.m11 = d10;
        this.m12 = d12;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AffineTransformation)) {
            return false;
        }
        AffineTransformation affineTransformation = (AffineTransformation)object;
        return this.m00 == affineTransformation.m00 && this.m01 == affineTransformation.m01 && this.m02 == affineTransformation.m02 && this.m10 == affineTransformation.m10 && this.m11 == affineTransformation.m11 && this.m12 == affineTransformation.m12;
    }

    public static AffineTransformation createScale(double d, double d2) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToScale(d, d2);
        return affineTransformation;
    }

    public double[] transform(double d, double d2) {
        double[] dArray = new double[]{this.m00 * d + this.m01 * d2 + this.m02, this.m10 * d + this.m11 * d2 + this.m12};
        return dArray;
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray == null || dArray2 == null) {
            return;
        }
        if (n < 0 || n >= dArray.length || n2 < 0 || n2 >= dArray2.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m10;
        double d5 = this.m11;
        double d6 = this.m12;
        while (--n3 >= 0) {
            double d7 = dArray[n++];
            double d8 = dArray[n++];
            dArray2[n2++] = d * d7 + d2 * d8 + d3;
            dArray2[n2++] = d4 * d7 + d5 * d8 + d6;
        }
    }

    public double[] inverseTransform(double d, double d2) {
        double d3 = this.m00 * this.m11 - this.m01 * this.m10;
        double[] dArray = new double[]{(this.m11 * (d -= this.m02) - this.m01 * (d2 -= this.m12)) / d3, (this.m00 * d2 - this.m10 * d) / d3};
        return dArray;
    }

    /*
     * Unable to fully structure code
     */
    public void inverseTransform(double[] var1_1, int var2_2, double[] var3_3, int var4_4, int var5_5) {
        if (var1_1 == null || var3_3 == null) {
            return;
        }
        if (var2_2 < 0 || var2_2 >= var1_1.length || var4_4 < 0 || var4_4 >= var3_3.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (var3_3 == var1_1 && var4_4 > var2_2 && var4_4 < var2_2 + var5_5 * 2) {
            System.arraycopy(var1_1, var2_2, var3_3, var4_4, var5_5 * 2);
            var2_2 = var4_4;
        }
        var6_6 = this.m00;
        var8_7 = this.m01;
        var10_8 = this.m02;
        var12_9 = this.m10;
        var14_10 = this.m11;
        var16_11 = this.m12;
        var18_12 = var6_6 * var14_10 - var8_7 * var12_9;
        if (!(Math.abs(var18_12) <= Double.MIN_VALUE)) ** GOTO lbl21
        throw new NoninvertibleTransformationException("Determinant is " + var18_12);
lbl-1000:
        // 1 sources

        {
            var20_13 = var1_1[var2_2++] - var10_8;
            var22_14 = var1_1[var2_2++] - var16_11;
            var3_3[var4_4++] = (var20_13 * var14_10 - var22_14 * var8_7) / var18_12;
            var3_3[var4_4++] = (var22_14 * var6_6 - var20_13 * var12_9) / var18_12;
lbl21:
            // 2 sources

            ** while (--var5_5 >= 0)
        }
lbl22:
        // 1 sources

    }

    public XObject transform(XObject xObject) {
        if (xObject == null) {
            return null;
        }
        return xObject.copy().transform_XObject(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
    }

    public XObject[] transform(XObject[] xObjectArray, int n, int n2) {
        if (xObjectArray == null) {
            return null;
        }
        if (n < 0 || n >= xObjectArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        XObject[] xObjectArray2 = new XObject[Math.min(n2, xObjectArray.length - n)];
        int n3 = 0;
        while (n3 < xObjectArray2.length) {
            xObjectArray2[n3] = xObjectArray[n + n3] != null ? xObjectArray[n + n3].copy().transform_XObject(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12) : null;
            ++n3;
        }
        return xObjectArray2;
    }

    public XObject[] transform(XObject[] xObjectArray) {
        if (xObjectArray == null) {
            return null;
        }
        return this.transform(xObjectArray, 0, xObjectArray.length);
    }

    public XObject inverseTransform(XObject xObject) {
        if (xObject == null) {
            return null;
        }
        return xObject.copy().inverseTransform_XObject(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
    }

    public XObject[] inverseTransform(XObject[] xObjectArray, int n, int n2) {
        if (xObjectArray == null) {
            return null;
        }
        if (n < 0 || n >= xObjectArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        if (Math.abs(d) <= Double.MIN_VALUE) {
            throw new NoninvertibleTransformationException("Determinant is " + d);
        }
        double d2 = this.m11 / d;
        double d3 = -this.m01 / d;
        double d4 = (this.m01 * this.m12 - this.m11 * this.m02) / d;
        double d5 = -this.m10 / d;
        double d6 = this.m00 / d;
        double d7 = (this.m10 * this.m02 - this.m00 * this.m12) / d;
        XObject[] xObjectArray2 = new XObject[Math.min(n2, xObjectArray.length - n)];
        int n3 = 0;
        while (n3 < xObjectArray2.length) {
            xObjectArray2[n3] = xObjectArray[n + n3] != null ? xObjectArray[n + n3].copy().transform_XObject(d2, d3, d4, d5, d6, d7) : null;
            ++n3;
        }
        return xObjectArray2;
    }

    public XObject[] inverseTransform(XObject[] xObjectArray) {
        if (xObjectArray == null) {
            return null;
        }
        return this.transform(xObjectArray, 0, xObjectArray.length);
    }

    public double shearX() {
        return this.m01;
    }

    public void scale(double d, double d2) {
        this.concatenate(d, 0.0, 0.0, 0.0, d2, 0.0);
    }

    public double scaleY() {
        return this.m11;
    }

    public static AffineTransformation createShear(double d, double d2) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToShear(d, d2);
        return affineTransformation;
    }

    public static AffineTransformation createTranslation(double d, double d2) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToTranslation(d, d2);
        return affineTransformation;
    }

    public String toString() {
        return this.getClass().getName() + "[[" + AffineTransformation._matround(this.m00) + "," + AffineTransformation._matround(this.m01) + "," + AffineTransformation._matround(this.m02) + "], [" + AffineTransformation._matround(this.m10) + "," + AffineTransformation._matround(this.m11) + "," + AffineTransformation._matround(this.m12) + "]]";
    }

    public AffineTransformation() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
    }

    public AffineTransformation(AffineTransformation affineTransformation) {
        this.m00 = affineTransformation.m00;
        this.m10 = affineTransformation.m10;
        this.m01 = affineTransformation.m01;
        this.m11 = affineTransformation.m11;
        this.m02 = affineTransformation.m02;
        this.m12 = affineTransformation.m12;
    }

    public AffineTransformation(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d4;
        this.m01 = d2;
        this.m11 = d5;
        this.m02 = d3;
        this.m12 = d6;
    }

    public AffineTransformation(double[] dArray) {
        if (dArray.length > 5) {
            this.m00 = dArray[0];
            this.m01 = dArray[1];
            this.m02 = dArray[2];
            this.m10 = dArray[3];
            this.m11 = dArray[4];
            this.m12 = dArray[5];
        }
    }

    public void translate(double d, double d2) {
        this.concatenate(1.0, 0.0, d, 0.0, 1.0, d2);
    }

    public void rotate(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        this.concatenate(d3, -d2, 0.0, d2, d3, 0.0);
    }

    public void rotate(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        this.concatenate(d5, -d4, d3 * d4 - d2 * d5 + d2, d4, d5, -d2 * d4 - d3 * d5 + d3);
    }

    public void setToScale(double d, double d2) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
    }

    public double scaleX() {
        return this.m00;
    }

    public static AffineTransformation createRotation(double d) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToRotation(d);
        return affineTransformation;
    }

    public static AffineTransformation createRotation(double d, double d2, double d3) {
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.setToRotation(d, d2, d3);
        return affineTransformation;
    }

    public void setToShear(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = d;
        this.m02 = 0.0;
        this.m10 = d2;
        this.m11 = 1.0;
        this.m12 = 0.0;
    }

    public void preConcatenate(AffineTransformation affineTransformation) {
        double d = affineTransformation.m00;
        double d2 = affineTransformation.m01;
        double d3 = affineTransformation.m02;
        double d4 = affineTransformation.m10;
        double d5 = affineTransformation.m11;
        double d6 = affineTransformation.m12;
        double d7 = d * this.m00 + d2 * this.m10;
        double d8 = d4 * this.m00 + d5 * this.m10;
        double d9 = d * this.m01 + d2 * this.m11;
        double d10 = d4 * this.m01 + d5 * this.m11;
        double d11 = d * this.m02 + d2 * this.m12 + d3;
        double d12 = d4 * this.m02 + d5 * this.m12 + d6;
        this.m00 = d7;
        this.m01 = d9;
        this.m02 = d11;
        this.m10 = d8;
        this.m11 = d10;
        this.m12 = d12;
    }

    public void preConcatenate(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d * this.m00 + d2 * this.m10;
        double d8 = d4 * this.m00 + d5 * this.m10;
        double d9 = d * this.m01 + d2 * this.m11;
        double d10 = d4 * this.m01 + d5 * this.m11;
        double d11 = d * this.m02 + d2 * this.m12 + d3;
        double d12 = d4 * this.m02 + d5 * this.m12 + d6;
        this.m00 = d7;
        this.m01 = d9;
        this.m02 = d11;
        this.m10 = d8;
        this.m11 = d10;
        this.m12 = d12;
    }

    private static double _matround(double d) {
        return Math.rint(d * 1.0E15) / 1.0E15;
    }

    public double[] matrix() {
        double[] dArray = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
        return dArray;
    }

    public double translateY() {
        return this.m12;
    }
}

