/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.KeyValueHolder;
import gishur.core.StdComparitor;
import gishur.x.XBaseline;
import gishur.x.XPoint;

public class LineComparitor
extends StdComparitor {
    public static final byte EXACT = 0;
    public static final byte BEFORE = 1;
    public static final byte AFTER = 2;
    private double _x = 0.0;
    private double _y = Double.MIN_VALUE;
    private byte _delta = 0;

    private short inverse(short s) {
        switch (s) {
            case -1: {
                return 1;
            }
            case 1: {
                return -1;
            }
        }
        return s;
    }

    public double getX() {
        return this._x;
    }

    public void setX(double d) {
        this._x = d;
    }

    public String toString() {
        String string = ",unknown delta";
        switch (this._delta) {
            case 0: {
                string = ",compare exact on x";
                break;
            }
            case 1: {
                string = ",compare infinitisimal before x";
                break;
            }
            case 2: {
                string = ",compare infinitisimal after x";
            }
        }
        if (this._y > Double.MIN_VALUE) {
            string = ",y=" + this._y + string;
        }
        return ((Object)((Object)this)).getClass().getName() + "[x=" + this._x + string + "]";
    }

    private XPoint calculateCorrectVerticalPoint(XBaseline xBaseline) {
        XPoint xPoint = new XPoint(this._x, this._y);
        if (xBaseline.liesOn(xPoint)) {
            return xPoint;
        }
        if (this._y > xBaseline.source().y) {
            xPoint.set(this._x, Math.max(xBaseline.source().y, xBaseline.target().y));
        } else {
            xPoint.set(this._x, Math.min(xBaseline.source().y, xBaseline.target().y));
        }
        return xPoint;
    }

    public byte getDelta() {
        return this._delta;
    }

    public void setDelta(byte by) {
        if (by != 0 && by != 1 && by != 2) {
            return;
        }
        this._delta = by;
    }

    public short compare(XBaseline xBaseline, XBaseline xBaseline2) {
        XPoint xPoint = xBaseline.calculatePoint(this._x);
        XPoint xPoint2 = xBaseline2.calculatePoint(this._x);
        if (xPoint == null && xPoint2 == null) {
            return 0;
        }
        if (xPoint == null) {
            return -1;
        }
        if (xPoint2 == null) {
            return 1;
        }
        if (xBaseline.vertical()) {
            xPoint = this.calculateCorrectVerticalPoint(xBaseline);
        }
        if (xBaseline2.vertical()) {
            xPoint2 = this.calculateCorrectVerticalPoint(xBaseline2);
        }
        if (xPoint.equals(xPoint2)) {
            double d;
            if (this._delta == 0) {
                return 0;
            }
            if (xBaseline.vertical() && xBaseline2.vertical()) {
                return 0;
            }
            if (xBaseline.vertical()) {
                if (this._delta == 1) {
                    return -1;
                }
                return 1;
            }
            if (xBaseline2.vertical()) {
                if (this._delta == 1) {
                    return 1;
                }
                return -1;
            }
            double d2 = xBaseline.slope();
            if (d2 < (d = xBaseline2.slope())) {
                if (this._delta == 1) {
                    return 1;
                }
                return -1;
            }
            if (d < d2) {
                if (this._delta == 1) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
        if (xPoint.y < xPoint2.y) {
            return -1;
        }
        return 1;
    }

    public double getY() {
        return this._y;
    }

    public void setY(double d) {
        this._y = d;
    }

    public void resetY() {
        this._y = Double.MIN_VALUE;
    }

    public short compare(XBaseline xBaseline, double d) {
        XPoint xPoint = xBaseline.calculatePoint(this._x);
        if (xPoint == null) {
            return -1;
        }
        if (xPoint.equals(this._x, d)) {
            if (this._delta == 0) {
                return 0;
            }
            double d2 = xBaseline.slope();
            if (d2 < 0.0) {
                if (this._delta == 1) {
                    return 1;
                }
                return -1;
            }
            if (d2 > 0.0) {
                if (this._delta == 1) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
        if (xPoint.y < d) {
            return -1;
        }
        return 1;
    }

    public short compare(Object object, Object object2) {
        if (object instanceof KeyValueHolder) {
            object = ((KeyValueHolder)object).key();
        }
        if (object2 instanceof KeyValueHolder) {
            object2 = ((KeyValueHolder)object2).key();
        }
        if (object instanceof XBaseline && object2 instanceof XBaseline) {
            return this.compare((XBaseline)object, (XBaseline)object2);
        }
        if (object instanceof XBaseline && object2 instanceof Number) {
            return this.compare((XBaseline)object, ((Number)object2).doubleValue());
        }
        if (object2 instanceof XBaseline && object instanceof Number) {
            return this.inverse(this.compare((XBaseline)object2, ((Number)object).doubleValue()));
        }
        return super.compare(object, object2);
    }
}

