/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.CompareException;
import gishur.core.Comparitor;
import gishur.core.KeyValueHolder;
import gishur.core.StdComparitor;
import gishur.x.XPoint;

public class PointComparitor
extends StdComparitor {
    public static final byte X_ORDER = 1;
    public static final byte Y_ORDER = 2;
    public static final byte ANGULAR = 3;
    public static final byte DISTANCE_ORDER = 4;
    private byte _order = 1;
    private XPoint _anglePoint = null;
    private XPoint _angleXPoint = null;
    private XPoint _distancePoint = null;

    public short compareDistance(XPoint xPoint, XPoint xPoint2) {
        double d;
        if (this._distancePoint == null) {
            return PointComparitor.compareX(xPoint, xPoint2);
        }
        double d2 = this._distancePoint.squareDistance(xPoint);
        if (d2 == (d = this._distancePoint.squareDistance(xPoint2))) {
            return PointComparitor.compareX(xPoint, xPoint2);
        }
        if (d2 < d) {
            return -1;
        }
        return 1;
    }

    public static short compareX(XPoint xPoint, XPoint xPoint2) {
        if (xPoint.x < xPoint2.x) {
            return -1;
        }
        if (xPoint.x > xPoint2.x) {
            return 1;
        }
        if (xPoint.y < xPoint2.y) {
            return -1;
        }
        if (xPoint.y > xPoint2.y) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String string = "unknown order";
        switch (this._order) {
            case 1: {
                string = "x-order";
                break;
            }
            case 2: {
                string = "y-order";
                break;
            }
            case 3: {
                string = "angular order,pivot=" + this._anglePoint.toString(true);
                if (this._angleXPoint == null) break;
                string = string + ",sidepoint=" + this._angleXPoint.toString(true);
                break;
            }
            case 4: {
                string = "distance-order,distance-point=" + this._distancePoint.toString(true);
            }
        }
        return ((Object)((Object)this)).getClass().getName() + "[" + string + "]";
    }

    public PointComparitor() {
    }

    public PointComparitor(byte by) {
        this.setOrder(by);
    }

    public PointComparitor(byte by, XPoint xPoint) {
        if (by == 3) {
            this.setAnglePoint(xPoint);
        }
        if (by == 4) {
            this.setReferencePoint(xPoint);
        }
        this.setOrder(by);
    }

    public void setReferencePoint(XPoint xPoint) {
        if (xPoint != null) {
            this._distancePoint = xPoint;
        }
    }

    public byte order() {
        return this._order;
    }

    public void setOrder(byte by) {
        if (by == 1) {
            this._order = 1;
        }
        if (by == 2) {
            this._order = (byte)2;
        }
        if (by == 3 && this._anglePoint != null) {
            this._order = (byte)3;
        }
        if (by == 4) {
            this._order = (byte)4;
            if (this._distancePoint == null) {
                this._distancePoint = new XPoint(0.0, 0.0);
            }
        }
    }

    public boolean setAnglePoint(XPoint xPoint) {
        return this.setAnglePoints(xPoint, null);
    }

    public short compareAngle(XPoint xPoint, XPoint xPoint2) {
        double d;
        double d2;
        if (this._angleXPoint == null) {
            d2 = this._anglePoint.angle(xPoint);
            d = this._anglePoint.angle(xPoint2);
        } else {
            d2 = this._anglePoint.angle(this._angleXPoint, xPoint);
            d = this._anglePoint.angle(this._angleXPoint, xPoint2);
        }
        if (d2 < d) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        d2 = this._anglePoint.squareDistance(xPoint);
        if (d2 < (d = this._anglePoint.squareDistance(xPoint2))) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    public static short compareY(XPoint xPoint, XPoint xPoint2) {
        if (xPoint.y < xPoint2.y) {
            return -1;
        }
        if (xPoint.y > xPoint2.y) {
            return 1;
        }
        if (xPoint.x < xPoint2.x) {
            return -1;
        }
        if (xPoint.x > xPoint2.x) {
            return 1;
        }
        return 0;
    }

    public short compare(XPoint xPoint, XPoint xPoint2) {
        switch (this._order) {
            case 1: {
                return PointComparitor.compareX(xPoint, xPoint2);
            }
            case 2: {
                return PointComparitor.compareY(xPoint, xPoint2);
            }
            case 3: {
                return this.compareAngle(xPoint, xPoint2);
            }
            case 4: {
                return this.compareDistance(xPoint, xPoint2);
            }
        }
        throw new CompareException((Comparitor)this, (Object)xPoint, (Object)xPoint2);
    }

    public short compare(Object object, Object object2) {
        if (object instanceof KeyValueHolder) {
            object = ((KeyValueHolder)object).key();
        }
        if (object2 instanceof KeyValueHolder) {
            object2 = ((KeyValueHolder)object2).key();
        }
        if (object instanceof XPoint && object2 instanceof XPoint) {
            return this.compare((XPoint)object, (XPoint)object2);
        }
        return super.compare(object, object2);
    }

    public boolean setAnglePoints(XPoint xPoint, XPoint xPoint2) {
        this._anglePoint = xPoint;
        this._angleXPoint = xPoint2;
        if (xPoint == null && this._order == 3) {
            this._order = 1;
        }
        return xPoint != null;
    }
}

